/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.actions;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.ir.client.AppState;
import com.android.tools.ir.client.InstantRunClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import icons.AndroidIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestartActivityAction
extends AnAction {
    public RestartActivityAction() {
        super("Restart Activity", null, AndroidIcons.RunIcons.Restart);
    }

    public void update(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module == null) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription(null);
            return;
        }
        if (!InstantRunSettings.isInstantRunEnabled()) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription("Restart Activity (requires Instant Run to be enabled)");
            return;
        }
        AndroidModuleModel model = InstantRunGradleUtils.getAppModel(module);
        if (model == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Project project = module.getProject();
        boolean gradleSupportsIr = InstantRunGradleUtils.getIrSupportStatus(model, null) == InstantRunGradleSupport.SUPPORTED;
        boolean hasActiveSession = !RestartActivityAction.getActiveSessions(project).isEmpty();
        boolean isPausedInDebugger = RestartActivityAction.isDebuggerPaused(project);
        boolean enabled = gradleSupportsIr && hasActiveSession && !isPausedInDebugger;
        e.getPresentation().setEnabled(enabled);
        if (!hasActiveSession) {
            e.getPresentation().setDescription("Restart Activity (requires an active debug session)");
        } else if (!isPausedInDebugger) {
            e.getPresentation().setDescription("Restart Activity (requires the app to not be stopped at a breakpoint)");
        }
    }

    private static List<ProcessHandler> getActiveSessions(@Nullable Project project) {
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList activeHandlers = Lists.newArrayList();
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (handler.isProcessTerminated() || handler.isProcessTerminating()) continue;
            activeHandlers.add(handler);
        }
        return activeHandlers;
    }

    public static boolean isDebuggerPaused(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return session != null && !session.isStopped() && session.isPaused();
    }

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module == null) {
            return;
        }
        InstantRunContext context = InstantRunGradleUtils.createGradleProjectContext(module);
        if (context == null) {
            Logger.getInstance(RestartActivityAction.class).info("Unable to obtain instant run context for module: " + module.getName());
            return;
        }
        RestartActivityAction.restartActivity(module.getProject(), context);
    }

    public static void restartActivity(@NotNull Project project, @NotNull InstantRunContext instantRunContext) {
        if (project == null) {
            RestartActivityAction.$$$reportNull$$$0(0);
        }
        if (instantRunContext == null) {
            RestartActivityAction.$$$reportNull$$$0(1);
        }
        for (IDevice device : RestartActivityAction.findDevices(project)) {
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(instantRunContext);
            if (instantRunClient == null) {
                Logger.getInstance(RestartActivityAction.class).warn("Unable to connect to to app running on device, not restarting.");
                return;
            }
            try {
                if (instantRunClient.getAppState(device) != AppState.FOREGROUND) continue;
                instantRunClient.restartActivity(device);
                if (!InstantRunSettings.isShowToastEnabled()) continue;
                RestartActivityAction.showToast(device, instantRunContext, "Activity Restarted");
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)("Unable to restart activity: " + e), (String)"Instant Run");
                InstantRunManager.LOG.warn("Unable to restart activity", (Throwable)e);
            }
        }
    }

    @NotNull
    private static List<IDevice> findDevices(@Nullable Project project) {
        if (project == null) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                RestartActivityAction.$$$reportNull$$$0(2);
            }
            return list;
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        if (runningProcesses.isEmpty()) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                RestartActivityAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList devices = Lists.newArrayList();
        for (RunContentDescriptor descriptor : runningProcesses) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) continue;
            devices.addAll(RestartActivityAction.getConnectedDevices(processHandler));
        }
        ArrayList arrayList = devices;
        if (arrayList == null) {
            RestartActivityAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static List<IDevice> getConnectedDevices(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            RestartActivityAction.$$$reportNull$$$0(5);
        }
        if (processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                RestartActivityAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (processHandler instanceof AndroidProcessHandler) {
            ImmutableList immutableList = ImmutableList.copyOf(((AndroidProcessHandler)processHandler).getDevices());
            if (immutableList == null) {
                RestartActivityAction.$$$reportNull$$$0(7);
            }
            return immutableList;
        }
        Client c = (Client)processHandler.getUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT);
        if (c != null && c.isValid()) {
            List<IDevice> list = Collections.singletonList(c.getDevice());
            if (list == null) {
                RestartActivityAction.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<IDevice> list = Collections.emptyList();
        if (list == null) {
            RestartActivityAction.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static void showToast(@NotNull IDevice device, @NotNull InstantRunContext context, @NotNull String message) {
        if (device == null) {
            RestartActivityAction.$$$reportNull$$$0(10);
        }
        if (context == null) {
            RestartActivityAction.$$$reportNull$$$0(11);
        }
        if (message == null) {
            RestartActivityAction.$$$reportNull$$$0(12);
        }
        try {
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(context);
            if (instantRunClient == null) {
                InstantRunManager.LOG.warn("Cannot connect to app, not showing toast");
                return;
            }
            instantRunClient.showToast(device, message);
        }
        catch (Throwable e) {
            InstantRunManager.LOG.warn(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantRunContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/actions/RestartActivityAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/actions/RestartActivityAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findDevices";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectedDevices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "restartActivity";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConnectedDevices";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showToast";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

