/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.repositories.FlatDirRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.GoogleDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesModel
extends GradleDslBlockModel {
    public RepositoriesModel(@NotNull RepositoriesDslElement dslElement) {
        if (dslElement == null) {
            RepositoriesModel.$$$reportNull$$$0(0);
        }
        super(dslElement);
    }

    @NotNull
    public List<RepositoryModel> repositories() {
        GradleDslElementList repositoriesElementList = this.myDslElement.getPropertyElement("repositories", GradleDslElementList.class);
        if (repositoriesElementList == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                RepositoriesModel.$$$reportNull$$$0(1);
            }
            return immutableList;
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement element : repositoriesElementList.getElements()) {
            if (element instanceof GradleDslMethodCall) {
                if ("mavenCentral".equals(element.getName())) {
                    result.add(new MavenCentralRepositoryModel(null));
                    continue;
                }
                if ("jcenter".equals(element.getName())) {
                    result.add(new JCenterDefaultRepositoryModel());
                    continue;
                }
                if (!"google".equals(element.getName())) continue;
                result.add(new GoogleDefaultRepositoryModel());
                continue;
            }
            if (element instanceof MavenRepositoryDslElement) {
                if ("maven".equals(element.getName())) {
                    result.add(new MavenRepositoryModel((MavenRepositoryDslElement)element));
                    continue;
                }
                if (!"jcenter".equals(element.getName())) continue;
                result.add(new JCenterRepositoryModel((MavenRepositoryDslElement)element));
                continue;
            }
            if (element instanceof FlatDirRepositoryDslElement) {
                result.add(new FlatDirRepositoryModel((FlatDirRepositoryDslElement)element));
                continue;
            }
            if (!(element instanceof GradleDslExpressionMap)) continue;
            if ("mavenCentral".equals(element.getName())) {
                result.add(new MavenCentralRepositoryModel((GradleDslExpressionMap)element));
                continue;
            }
            if (!"flatDir".equals(element.getName())) continue;
            result.add(new FlatDirRepositoryModel((GradlePropertiesDslElement)element));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            RepositoriesModel.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void addRepositoryByMethodName(@NotNull String methodName) {
        if (methodName == null) {
            RepositoriesModel.$$$reportNull$$$0(3);
        }
        GradleDslElementList repositoriesElementList = this.getRepositoryElementList();
        if (this.containsMethodCall(methodName)) {
            return;
        }
        repositoriesElementList.addNewElement(new GradleDslMethodCall((GradleDslElement)repositoriesElementList, methodName, null));
    }

    public boolean containsMethodCall(@NotNull String methodName) {
        if (methodName == null) {
            RepositoriesModel.$$$reportNull$$$0(4);
        }
        GradleDslElementList list = this.getRepositoryElementList();
        List<GradleDslMethodCall> elements = list.getElements(GradleDslMethodCall.class);
        for (GradleDslMethodCall element : elements) {
            if (!methodName.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    public void addMavenRepositoryByUrl(@NotNull String url, @NotNull String name) {
        if (url == null) {
            RepositoriesModel.$$$reportNull$$$0(5);
        }
        if (name == null) {
            RepositoriesModel.$$$reportNull$$$0(6);
        }
        GradleDslElementList repositoriesElementList = this.getRepositoryElementList();
        if (this.containsMavenRepositoryByUrl(url)) {
            return;
        }
        MavenRepositoryDslElement newElement = new MavenRepositoryDslElement(repositoriesElementList, "maven");
        newElement.setNewLiteral("url", url);
        newElement.setNewLiteral("name", name);
        repositoriesElementList.addNewElement(newElement);
    }

    public boolean containsMavenRepositoryByUrl(@NotNull String repositoryUrl) {
        if (repositoryUrl == null) {
            RepositoriesModel.$$$reportNull$$$0(7);
        }
        GradleDslElementList list = this.getRepositoryElementList();
        List<MavenRepositoryDslElement> elements = list.getElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element : elements) {
            String urlElement = (String)element.getLiteralProperty("url", String.class).value();
            if (!repositoryUrl.equals(urlElement)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private GradleDslElementList getRepositoryElementList() {
        GradleDslElementList repositoriesElementList = this.myDslElement.getPropertyElement("repositories", GradleDslElementList.class);
        if (repositoriesElementList == null) {
            repositoriesElementList = new GradleDslElementList(this.myDslElement, "repositories");
            this.myDslElement.addParsedElement("repositories", repositoriesElementList);
        }
        GradleDslElementList gradleDslElementList = repositoriesElementList;
        if (gradleDslElementList == null) {
            RepositoriesModel.$$$reportNull$$$0(8);
        }
        return gradleDslElementList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/repositories/RepositoriesModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/repositories/RepositoriesModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "repositories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryElementList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRepositoryByMethodName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsMethodCall";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addMavenRepositoryByUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsMavenRepositoryByUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

