/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedFileNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.generated.file.ro");
    @NotNull
    private final Project myProject;
    @NotNull
    private final GeneratedSourceFileChangeTracker myGeneratedSourceFileChangeTracker;
    @NotNull
    private final GradleProjectInfo myProjectInfo;

    public GeneratedFileNotificationProvider(@NotNull Project project, @NotNull GeneratedSourceFileChangeTracker changeTracker, @NotNull GradleProjectInfo projectInfo) {
        if (project == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(0);
        }
        if (changeTracker == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(1);
        }
        if (projectInfo == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myGeneratedSourceFileChangeTracker = changeTracker;
        this.myProjectInfo = projectInfo;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(3);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        AndroidModuleModel androidModel;
        if (file == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(4);
        }
        if (fileEditor == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(5);
        }
        if ((androidModel = this.myProjectInfo.findAndroidModelInModule(file, false)) == null) {
            return null;
        }
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)buildFolderPath, (boolean)false);
        if (buildFolder == null || !buildFolder.isDirectory()) {
            return null;
        }
        if (VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false)) {
            if (this.myGeneratedSourceFileChangeTracker.isEditedGeneratedFile(file)) {
                return null;
            }
            VirtualFile explodedBundled = buildFolder.findChild("exploded-aar");
            boolean inAar = explodedBundled != null && VfsUtilCore.isAncestor((VirtualFile)explodedBundled, (VirtualFile)file, (boolean)true);
            String text = inAar ? "Resource files inside Android library archive files (.aar) should not be edited" : "Files under the \"build\" folder are generated and should not be edited.";
            return new MyEditorNotificationPanel(text);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeTracker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/notification/GeneratedFileNotificationProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/notification/GeneratedFileNotificationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        MyEditorNotificationPanel(@NotNull String text) {
            if (text == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(0);
            }
            this.setText(text);
        }

        @VisibleForTesting
        @Nullable
        String getText() {
            return this.myLabel.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/notification/GeneratedFileNotificationProvider$MyEditorNotificationPanel", "<init>"));
        }
    }
}

