/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingPlatformErrorHandler
extends SyncErrorHandler {
    private static final Pattern[] MISSING_PLATFORM_PATTERNS = new Pattern[]{Pattern.compile("(Cause: )?(F|f)ailed to find target with hash string '(.*)' in: (.*)"), Pattern.compile("(Cause: )?(F|f)ailed to find target (.*) : (.*)"), Pattern.compile("(Cause: )?(F|f)ailed to find target (.*)")};

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String text;
        if (error == null) {
            MissingPlatformErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            MissingPlatformErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            MissingPlatformErrorHandler.$$$reportNull$$$0(2);
        }
        if ((text = this.findErrorMessage(this.getRootCause((Throwable)error))) != null) {
            this.findAndAddQuickFixes(notification, project, text);
            return true;
        }
        return false;
    }

    @Nullable
    private String findErrorMessage(@NotNull Throwable rootCause) {
        if (rootCause == null) {
            MissingPlatformErrorHandler.$$$reportNull$$$0(3);
        }
        String text = rootCause.getMessage();
        if ((rootCause instanceof IllegalStateException || rootCause instanceof ExternalSystemException) && StringUtil.isNotEmpty((String)text) && this.getMissingPlatform(text) != null) {
            MissingPlatformErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.MISSING_ANDROID_PLATFORM);
            return text;
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    String getMissingPlatform(@NotNull String text) {
        if (text == null) {
            MissingPlatformErrorHandler.$$$reportNull$$$0(4);
        }
        String firstLine = MissingPlatformErrorHandler.getFirstLineMessage(text);
        for (Pattern pattern : MISSING_PLATFORM_PATTERNS) {
            Matcher matcher = pattern.matcher(firstLine);
            if (!matcher.matches()) continue;
            return matcher.group(3);
        }
        return null;
    }

    private void findAndAddQuickFixes(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        List facets;
        AndroidVersion version;
        String missingPlatform;
        if (notification == null) {
            MissingPlatformErrorHandler.$$$reportNull$$$0(5);
        }
        if (project == null) {
            MissingPlatformErrorHandler.$$$reportNull$$$0(6);
        }
        if (text == null) {
            MissingPlatformErrorHandler.$$$reportNull$$$0(7);
        }
        if ((missingPlatform = this.getMissingPlatform(text)) == null) {
            return;
        }
        String loadError = null;
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        AndroidSdkHandler sdkHandler = null;
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdkHandler = androidSdkData.getSdkHandler();
        }
        if (sdkHandler != null && (version = AndroidTargetHash.getPlatformVersion((String)missingPlatform)) != null) {
            StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
            loadError = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getErrorForPackage(DetailsTypes.getPlatformPath((AndroidVersion)version));
            hyperlinks.add(new InstallPlatformHyperlink(version));
        }
        if (hyperlinks.isEmpty() && !(facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)).isEmpty()) {
            hyperlinks.add(new OpenAndroidSdkManagerHyperlink());
        }
        if (StringUtil.isNotEmpty(loadError)) {
            text = text + "\nPossible cause: " + loadError;
        }
        GradleSyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMissingPlatform";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndAddQuickFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

