/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.paths.PathTree;
import com.android.tools.idea.navigator.nodes.apk.SourceFolders;
import com.android.tools.idea.navigator.nodes.apk.ndk.LibraryFileNode;
import com.android.tools.idea.navigator.nodes.apk.ndk.NdkSourceNode;
import com.android.tools.idea.navigator.nodes.apk.ndk.PathTrees;
import com.android.tools.idea.navigator.nodes.apk.ndk.SourceCodeFilter;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.base.Joiner;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import icons.StudioIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryNode
extends ProjectViewNode<NativeLibrary> {
    @NotNull
    final NativeLibrary myLibrary;
    @NotNull
    private final String myLibraryName;

    public LibraryNode(@NotNull Project project, @NotNull NativeLibrary library, @NotNull ViewSettings settings) {
        if (project == null) {
            LibraryNode.$$$reportNull$$$0(0);
        }
        if (library == null) {
            LibraryNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            LibraryNode.$$$reportNull$$$0(2);
        }
        super(project, (Object)library, settings);
        this.myLibrary = library;
        this.myLibraryName = this.getLibraryName();
    }

    @NotNull
    private String getLibraryName() {
        VirtualFile file = this.getFirstFile();
        String string = file != null ? file.getNameWithoutExtension() : this.myLibrary.name;
        if (string == null) {
            LibraryNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected VirtualFile getFirstFile() {
        List<VirtualFile> files = this.myLibrary.getSharedObjectFiles();
        return files.isEmpty() ? null : files.get(0);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        assert (this.myProject != null);
        ArrayList<Object> children = new ArrayList<Object>();
        ViewSettings settings = this.getSettings();
        children.add((Object)new LibraryFileNode(this.myProject, this.myLibrary, settings));
        File ndkPath = IdeSdks.getInstance().getAndroidNdkPath();
        String ndkPathValue = ndkPath != null ? ndkPath.getPath() : null;
        List<String> paths = this.myLibrary.getSourceFolderPaths();
        ArrayList<String> srcPaths = new ArrayList<String>();
        ArrayList<String> ndkPaths = new ArrayList<String>();
        if (!paths.isEmpty()) {
            PathTree srcPathTree = new PathTree();
            PathTree ndkPathTree = new PathTree();
            for (String path : paths) {
                if (ndkPath != null && FileUtil.isAncestor((String)ndkPathValue, (String)path, (boolean)false)) {
                    ndkPaths.add(path);
                    ndkPathTree.addPath(path, File.separatorChar);
                    continue;
                }
                srcPaths.add(path);
                srcPathTree.addPath(path, File.separatorChar);
            }
            if (!ndkPathTree.getChildren().isEmpty()) {
                assert (ndkPath != null);
                children.add((Object)new NdkSourceNode(this.myProject, ndkPath, ndkPathTree, new SourceCodeFilter(ndkPaths), settings));
            }
            children.addAll(PathTrees.getSourceFolderNodes(srcPathTree, new SourceCodeFilter(srcPaths), this.myProject, settings));
        }
        ArrayList<Object> arrayList = children;
        if (arrayList == null) {
            LibraryNode.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            LibraryNode.$$$reportNull$$$0(5);
        }
        if (this.myLibrary.sharedObjectFilesByAbi.containsValue(file)) {
            return true;
        }
        return SourceFolders.isInSourceFolder(file, this.myLibrary);
    }

    protected void update(PresentationData presentation) {
        presentation.setIcon(StudioIcons.Shell.Filetree.LIBRARY_MODULE);
        presentation.addText(this.myLibraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String abis = Joiner.on((String)", ").join(this.myLibrary.abis);
        presentation.addText(" (" + abis + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public boolean isAlwaysExpand() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myLibraryName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibraryNode node = (LibraryNode)((Object)o);
        return Objects.equals(this.myLibrary, node.myLibrary) && Objects.equals(this.myLibraryName, node.myLibraryName);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myLibrary, this.myLibraryName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/ndk/LibraryNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/ndk/LibraryNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

