/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AndroidProfilerToolWindowFactory
implements DumbAware,
ToolWindowFactory,
Condition<Project> {
    public static final String ID = "Android Profiler";
    private static final String ANDROID_PROFILER_ACTIVE = "android.profiler.active";

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(1);
        }
        toolWindow.setToHideOnEmptyContent(true);
        ToolWindowManagerEx.getInstanceEx((Project)project).addToolWindowManagerListener(new ToolWindowManagerListener(){

            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void stateChanged() {
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidProfilerToolWindowFactory.ID);
                if (window != null && window.isVisible() && window.getContentManager().getContentCount() == 0) {
                    AndroidProfilerToolWindowFactory.createContent(project, window);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/profilers/AndroidProfilerToolWindowFactory$1", "toolWindowRegistered"));
            }
        });
        toolWindow.hide(null);
        toolWindow.setShowStripeButton(false);
    }

    private static void createContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(2);
        }
        if (toolWindow == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(3);
        }
        AndroidProfilerToolWindow view = new AndroidProfilerToolWindow(project);
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent(view.getComponent(), "", false);
        Disposer.register((Disposable)content, (Disposable)view);
        toolWindow.getContentManager().addContent(content);
        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.ANDROID_PROFILER));
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        properties.setValue(ANDROID_PROFILER_ACTIVE, true);
        toolWindow.show(null);
    }

    public static void removeContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(4);
        }
        if (toolWindow == null) {
            AndroidProfilerToolWindowFactory.$$$reportNull$$$0(5);
        }
        toolWindow.getContentManager().removeAllContents(true);
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
        properties.setValue(ANDROID_PROFILER_ACTIVE, false);
    }

    public boolean value(Project project) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createContent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

