/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.datastore.poller.MemoryDataPoller;
import com.android.tools.idea.profilers.LegacyAllocationConverter;
import com.android.tools.idea.profilers.LegacyAllocationTracker;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class StudioLegacyAllocationTracker
implements LegacyAllocationTracker {
    private IDevice myDevice;
    private Client myClient;
    private final LegacyAllocationConverter myConverter;
    private boolean myOngoingTracking;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryDataPoller.class);
    }

    public StudioLegacyAllocationTracker(@NotNull IDevice device, int processId) {
        if (device == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(0);
        }
        this.myConverter = new LegacyAllocationConverter();
        this.myDevice = device;
        this.myClient = this.getClient(processId);
        if (this.myClient == null) {
            StudioLegacyAllocationTracker.getLogger().info("StudioLegacyAllocationTracker unable to find application with process Id: " + processId);
        }
    }

    @Override
    public boolean trackAllocations(long startTime, long endTime, boolean enabled, Executor executor, LegacyAllocationTracker.LegacyAllocationTrackingCallback allocationConsumer) {
        if (this.myClient == null) {
            return false;
        }
        if (enabled == this.myOngoingTracking) {
            return false;
        }
        this.myOngoingTracking = enabled;
        if (!enabled) {
            assert (executor != null);
            this.getAllocationTrackingDump(executor, data -> {
                assert (allocationConsumer != null);
                if (data == null) {
                    allocationConsumer.accept(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                } else {
                    LegacyAllocationConverter converter = this.parseDump((byte[])data);
                    allocationConsumer.accept((byte[])data, converter.getClassNames(), converter.getAllocationStacks(), converter.getAllocationEvents(startTime, endTime));
                }
            });
        }
        this.myClient.enableAllocationTracker(enabled);
        return true;
    }

    private void getAllocationTrackingDump(final @NotNull Executor executor, final @NotNull Consumer<byte[]> consumer) {
        if (executor == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(2);
        }
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client, int changeMask) {
                if (StudioLegacyAllocationTracker.this.myClient == client && (changeMask & 0x200) != 0) {
                    byte[] data = client.getClientData().getAllocationsData();
                    executor.execute(() -> {
                        if (consumer == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        consumer.accept(data);
                    });
                    AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/profilers/StudioLegacyAllocationTracker$1", "lambda$clientChanged$0"));
            }
        });
        this.myClient.requestAllocationDetails();
    }

    @NotNull
    private LegacyAllocationConverter parseDump(@NotNull byte[] dumpData) {
        AllocationInfo[] rawInfos;
        if (dumpData == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(3);
        }
        this.myConverter.prepare();
        for (AllocationInfo info : rawInfos = AllocationsParser.parse((ByteBuffer)ByteBuffer.wrap(dumpData))) {
            List<StackTraceElement> stackTraceElements = Arrays.asList(info.getStackTrace());
            LegacyAllocationConverter.CallStack callStack = this.myConverter.addCallStack(stackTraceElements);
            int classId = this.myConverter.addClassName(info.getAllocatedClass());
            this.myConverter.addAllocation(new LegacyAllocationConverter.Allocation(classId, info.getSize(), info.getThreadId(), callStack.hashCode()));
        }
        LegacyAllocationConverter legacyAllocationConverter = this.myConverter;
        if (legacyAllocationConverter == null) {
            StudioLegacyAllocationTracker.$$$reportNull$$$0(4);
        }
        return legacyAllocationConverter;
    }

    private Client getClient(int processId) {
        if (!this.myDevice.isOnline()) {
            return null;
        }
        return this.myDevice.getClient(this.myDevice.getClientName(processId));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/StudioLegacyAllocationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/StudioLegacyAllocationTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllocationTrackingDump";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseDump";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

