/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.help.StudioHelpManagerImpl;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigPanel;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigService;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilingConfigurationsDialog
extends SingleConfigurableEditor {
    private final ProfilingConfiguration myPreSelectedConfiguration;
    private Consumer<ProfilingConfiguration> myOnCloseCallback;

    public CpuProfilingConfigurationsDialog(Project project, boolean isDeviceAtLeastO, ProfilingConfiguration preSelectedConfiguration, Consumer<ProfilingConfiguration> onCloseCallback, FeatureTracker featureTracker) {
        super(project, (Configurable)new ProfilingConfigurable(project, preSelectedConfiguration, isDeviceAtLeastO, featureTracker), DialogWrapper.IdeModalityType.IDE);
        this.myPreSelectedConfiguration = preSelectedConfiguration;
        this.myOnCloseCallback = onCloseCallback;
        this.setHorizontalStretch(1.3f);
    }

    @Nullable
    private ProfilingConfiguration getSelectedConfiguration() {
        ProfilingConfigurable configurable = (ProfilingConfigurable)this.getConfigurable();
        return configurable.getSelectedConfiguration();
    }

    public void dispose() {
        ProfilingConfiguration selectedConfig = this.myPreSelectedConfiguration;
        if (this.getExitCode() == 0) {
            selectedConfig = this.getSelectedConfiguration();
        }
        super.dispose();
        this.myOnCloseCallback.accept(selectedConfig);
    }

    private static class ProfilingConfigurable
    extends BaseConfigurable {
        private static final String ADD = "Add";
        private static final String MOVE_DOWN = "Move Down";
        private static final String MOVE_UP = "Move Up";
        private static final String REMOVE = "Remove";
        private final JBSplitter mySplitter = new JBSplitter("ProfilingConfigurable.dividerProportion", 0.3f);
        @NotNull
        private final JList<ProfilingConfiguration> myConfigurations;
        @NotNull
        private final DefaultListModel<ProfilingConfiguration> myConfigurationsModel;
        private int myDefaultConfigurationsCount;
        private final Project myProject;
        private final FeatureTracker myFeatureTracker;
        private CpuProfilingConfigPanel myProfilersPanel;

        public ProfilingConfigurable(Project project, ProfilingConfiguration preSelectedConfiguration, boolean isDeviceAtLeastO, FeatureTracker featureTracker) {
            this.myProject = project;
            this.myFeatureTracker = featureTracker;
            this.myProfilersPanel = new CpuProfilingConfigPanel(isDeviceAtLeastO);
            this.myConfigurationsModel = new DefaultListModel();
            this.myConfigurations = new JBList(this.myConfigurationsModel);
            this.setUpConfigurationsList();
            this.selectConfiguration(preSelectedConfiguration);
        }

        @Nullable
        public String getHelpTopic() {
            return StudioHelpManagerImpl.STUDIO_HELP_PREFIX + "r/studio-ui/cpu-recording-configurations-help-link.html";
        }

        private void setUpConfigurationsList() {
            this.myConfigurations.setSelectionMode(0);
            this.myConfigurations.setCellRenderer(new ProfilingConfigurationsListCellRenderer());
            this.myConfigurations.addListSelectionListener(e -> {
                int index = this.myConfigurations.getSelectedIndex();
                this.myProfilersPanel.setConfiguration(index < 0 ? null : this.myConfigurationsModel.get(index), index >= this.getCustomConfigurationCount());
            });
            for (ProfilingConfiguration configuration : CpuProfilingConfigService.getInstance(this.myProject).getConfigurations()) {
                if (configuration.getProfilerType() == CpuProfiler.CpuProfilerType.SIMPLE_PERF && !StudioFlags.PROFILER_USE_SIMPLEPERF.get().booleanValue()) continue;
                this.myConfigurationsModel.addElement(configuration);
            }
            int defaultConfigCount = 0;
            for (ProfilingConfiguration configuration : ProfilingConfiguration.getDefaultProfilingConfigurations()) {
                if (configuration.getProfilerType() == CpuProfiler.CpuProfilerType.SIMPLE_PERF && !StudioFlags.PROFILER_USE_SIMPLEPERF.get().booleanValue()) continue;
                this.myConfigurationsModel.addElement(configuration);
                ++defaultConfigCount;
            }
            this.myDefaultConfigurationsCount = defaultConfigCount;
        }

        private int getCustomConfigurationCount() {
            return this.myConfigurationsModel.size() - this.myDefaultConfigurationsCount;
        }

        private void selectConfiguration(ProfilingConfiguration configuration) {
            for (int i = 0; i < this.myConfigurationsModel.size(); ++i) {
                if (!configuration.getName().equals(this.myConfigurationsModel.get(i).getName())) continue;
                this.myConfigurations.setSelectedIndex(i);
                return;
            }
        }

        public ProfilingConfiguration getSelectedConfiguration() {
            return this.myConfigurations.getSelectedValue();
        }

        private JComponent createLeftPanel() {
            MyAddAction addAction = new MyAddAction();
            MyRemoveAction removeAction = new MyRemoveAction();
            MyMoveAction moveUpAction = new MyMoveAction(MOVE_UP, -1, IconUtil.getMoveUpIcon());
            MyMoveAction moveDownAction = new MyMoveAction(MOVE_DOWN, 1, IconUtil.getMoveUpIcon());
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myConfigurations).setAsUsualTopToolbar().setMoveUpAction((AnActionButtonRunnable)moveUpAction).setMoveUpActionUpdater((AnActionButtonUpdater)moveUpAction).setMoveUpActionName(MOVE_UP).setMoveDownAction((AnActionButtonRunnable)moveDownAction).setMoveDownActionUpdater((AnActionButtonUpdater)moveDownAction).setMoveDownActionName(MOVE_DOWN).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction).setRemoveActionName(REMOVE).setAddAction((AnActionButtonRunnable)addAction).setAddActionUpdater((AnActionButtonUpdater)addAction).setAddActionName(ADD).setMinimumSize((Dimension)new JBDimension(200, 200)).setForcedDnD();
            return toolbarDecorator.createPanel();
        }

        @Nls
        public String getDisplayName() {
            return "CPU Recording Configurations";
        }

        @Nullable
        public JComponent createComponent() {
            JPanel mainComponent = new JPanel(new BorderLayout());
            this.mySplitter.setFirstComponent(this.createLeftPanel());
            this.mySplitter.setHonorComponentsMinimumSize(true);
            this.mySplitter.setSecondComponent(this.myProfilersPanel.getComponent());
            mainComponent.add((Component)this.mySplitter, "Center");
            mainComponent.setPreferredSize(new Dimension(800, 600));
            return mainComponent;
        }

        public void apply() throws ConfigurationException {
            CpuProfilingConfigService profilingConfigService = CpuProfilingConfigService.getInstance(this.myProject);
            ArrayList<ProfilingConfiguration> configsToSave = new ArrayList<ProfilingConfiguration>();
            for (int i = 0; i < this.getCustomConfigurationCount(); ++i) {
                configsToSave.add(this.myConfigurationsModel.get(i));
            }
            List defaultConfigs = ProfilingConfiguration.getDefaultProfilingConfigurations();
            HashSet<String> configNames = new HashSet<String>();
            for (ProfilingConfiguration config : configsToSave) {
                String configName = config.getName();
                if (StringUtil.isEmpty((String)configName)) {
                    throw new ConfigurationException("Empty configuration names are not allowed. Please rename or delete them before continuing.");
                }
                if (configNames.contains(configName)) {
                    throw new ConfigurationException("Configuration with name \"" + configName + "\" already exists.");
                }
                for (ProfilingConfiguration defaultConfig : defaultConfigs) {
                    if (!configName.equals(defaultConfig.getName())) continue;
                    throw new ConfigurationException("\"" + configName + "\" is already being used as a default configuration. Please choose another name.");
                }
                configNames.add(configName);
            }
            profilingConfigService.setConfigurations(configsToSave);
        }

        public boolean isModified() {
            return true;
        }

        private class MyMoveAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            private int myMoveDownCount;

            public MyMoveAction(String actionText, int moveDownCount, Icon icon) {
                super(actionText, null, icon);
                this.myMoveDownCount = moveDownCount;
            }

            public void actionPerformed(AnActionEvent e) {
                this.moveSelectedElement();
            }

            public void run(AnActionButton button) {
                this.moveSelectedElement();
            }

            public boolean isEnabled(AnActionEvent e) {
                return this.validSelectionExists();
            }

            private void moveSelectedElement() {
                if (this.validSelectionExists()) {
                    int origin = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                    int dest = origin + this.myMoveDownCount;
                    ProfilingConfiguration temp = (ProfilingConfiguration)ProfilingConfigurable.this.myConfigurationsModel.get(origin);
                    ProfilingConfigurable.this.myConfigurationsModel.set(origin, ProfilingConfigurable.this.myConfigurationsModel.get(dest));
                    ProfilingConfigurable.this.myConfigurationsModel.set(dest, temp);
                    ProfilingConfigurable.this.myConfigurations.setSelectedIndex(dest);
                }
            }

            private boolean validSelectionExists() {
                if (ProfilingConfigurable.this.myConfigurations.getSelectedIndex() < 0) {
                    return false;
                }
                if (ProfilingConfigurable.this.myConfigurations.getSelectedIndex() >= ProfilingConfigurable.this.getCustomConfigurationCount()) {
                    return false;
                }
                return ProfilingConfigurable.this.myConfigurations.getSelectedIndex() + this.myMoveDownCount >= 0 && ProfilingConfigurable.this.myConfigurations.getSelectedIndex() + this.myMoveDownCount < ProfilingConfigurable.this.getCustomConfigurationCount();
            }
        }

        private class MyRemoveAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            public MyRemoveAction() {
                super("Remove Configuration", "Remove the selected configuration", IconUtil.getRemoveIcon());
            }

            public void actionPerformed(AnActionEvent e) {
                this.removeSelectedConfiguration();
            }

            public void run(AnActionButton button) {
                this.removeSelectedConfiguration();
            }

            public boolean isEnabled(AnActionEvent e) {
                return this.nonDefaultSelectionExists();
            }

            private boolean nonDefaultSelectionExists() {
                int index = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                return ProfilingConfigurable.this.myConfigurations.getSelectedIndex() >= 0 && index < ProfilingConfigurable.this.getCustomConfigurationCount();
            }

            private void removeSelectedConfiguration() {
                if (this.nonDefaultSelectionExists()) {
                    int removedIndex = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                    ProfilingConfigurable.this.myConfigurationsModel.remove(removedIndex);
                    ProfilingConfigurable.this.myConfigurations.setSelectedIndex(removedIndex);
                }
            }
        }

        private class MyAddAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            public MyAddAction() {
                super("Add Configuration", "Add a new configuration", IconUtil.getAddIcon());
            }

            public void actionPerformed(AnActionEvent e) {
                this.addConfiguration();
            }

            public void run(AnActionButton button) {
                this.addConfiguration();
            }

            public boolean isEnabled(AnActionEvent e) {
                return true;
            }

            private void addConfiguration() {
                ProfilingConfiguration configuration = new ProfilingConfiguration(this.getUniqueName("Unnamed"), CpuProfiler.CpuProfilerType.ART, CpuProfiler.CpuProfilingAppStartRequest.Mode.SAMPLED);
                int lastConfigurationIndex = ProfilingConfigurable.this.getCustomConfigurationCount();
                ProfilingConfigurable.this.myConfigurationsModel.insertElementAt(configuration, lastConfigurationIndex);
                ProfilingConfigurable.this.myConfigurations.setSelectedIndex(lastConfigurationIndex);
                ProfilingConfigurable.this.myFeatureTracker.trackCreateCustomProfilingConfig();
                ProfilingConfigurable.this.myProfilersPanel.getPreferredFocusComponent().requestFocusInWindow();
            }

            @NotNull
            private String getUniqueName(@NotNull String name) {
                if (name == null) {
                    MyAddAction.$$$reportNull$$$0(0);
                }
                HashSet<String> names = new HashSet<String>();
                Enumeration configurations = ProfilingConfigurable.this.myConfigurationsModel.elements();
                while (configurations.hasMoreElements()) {
                    names.add(((ProfilingConfiguration)configurations.nextElement()).getName());
                }
                String uniqueName = name;
                int i = 1;
                while (names.contains(uniqueName)) {
                    uniqueName = String.format("%s (%d)", name, i++);
                }
                String string = uniqueName;
                if (string == null) {
                    MyAddAction.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/profilers/profilingconfig/CpuProfilingConfigurationsDialog$ProfilingConfigurable$MyAddAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/profilers/profilingconfig/CpuProfilingConfigurationsDialog$ProfilingConfigurable$MyAddAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUniqueName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getUniqueName";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class ProfilingConfigurationsListCellRenderer
        implements ListCellRenderer<ProfilingConfiguration> {
            private JLabel myLabel = new JLabel();

            public ProfilingConfigurationsListCellRenderer() {
                EmptyBorder marginLeft = new EmptyBorder(0, 10, 0, 0);
                this.myLabel.setBorder(marginLeft);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.setPreferredSize(new Dimension(panel.getPreferredSize().width, 25));
                panel.setBackground(list.getBackground());
                String cellText = value.getName();
                if (index >= ProfilingConfigurable.this.getCustomConfigurationCount()) {
                    cellText = cellText + " - Default";
                }
                this.myLabel.setText(cellText);
                this.myLabel.setForeground((Color)(isSelected ? Gray._255 : JBColor.BLACK));
                if (isSelected) {
                    panel.setBackground(ProfilerColors.CPU_PROFILING_CONFIGURATIONS_SELECTED);
                }
                panel.add((Component)this.myLabel, "Center");
                return panel;
            }
        }
    }
}

