/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Reader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;

@XmlRootElement(name="servicebundle")
public class ServiceBundle {
    @XmlAttribute(name="name")
    private String myName;
    @XmlElements(value={@XmlElement(name="service", type=Service.class)})
    private List<Service> myServices = Lists.newArrayList();

    public static ServiceBundle parse(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            ServiceBundle.$$$reportNull$$$0(0);
        }
        return ServiceBundle.unmarshal(xmlReader);
    }

    private static ServiceBundle unmarshal(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            ServiceBundle.$$$reportNull$$$0(1);
        }
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{ServiceBundle.class}).createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getLinkedException());
            }
        });
        return (ServiceBundle)unmarshaller.unmarshal(xmlReader);
    }

    public List<Service> getServices() {
        return ImmutableList.copyOf(this.myServices);
    }

    public String toString() {
        return "ServiceBundle{myName='" + this.myName + '\'' + ", myServices=" + this.myServices + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "xmlReader";
        objectArray2[1] = "com/android/tools/idea/structure/services/ServiceBundle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unmarshal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Service {
        @XmlAttribute(name="name")
        @NotNull
        private String myName;
        @XmlAttribute(name="resourceRoot")
        @NotNull
        private String myResourceRoot;
        @XmlElements(value={@XmlElement(name="resource", type=String.class)})
        private List<String> myResources = Lists.newArrayList();

        public List<String> getResources() {
            return ImmutableList.copyOf(this.myResources);
        }

        public String getResourceRoot() {
            return this.myResourceRoot;
        }

        public String toString() {
            return "Service{myName='" + this.myName + '\'' + ", myResourceRoot='" + this.myResourceRoot + '\'' + ", myResources=" + this.myResources + '}';
        }
    }
}

