/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.actions.MockupDeleteAction;
import com.android.tools.idea.actions.MockupEditAction;
import com.android.tools.idea.actions.SaveScreenshotAction;
import com.android.tools.idea.common.actions.DeselectAllAction;
import com.android.tools.idea.common.actions.GotoComponentAction;
import com.android.tools.idea.common.actions.SelectAllAction;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.InteractionManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.actions.ConvertToConstraintLayoutAction;
import com.android.tools.idea.uibuilder.actions.MorphComponentAction;
import com.android.tools.idea.uibuilder.actions.SelectParentAction;
import com.android.tools.idea.uibuilder.actions.SelectSameTypeAction;
import com.android.tools.idea.uibuilder.actions.SelectSiblingsAction;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewActionGroup;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.IncorrectOperationException;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlActionManager
extends ActionManager<NlDesignSurface> {
    private AnAction mySelectAllAction;
    private AnAction mySelectParent;
    private GotoComponentAction myGotoComponentAction;

    public NlActionManager(@NotNull NlDesignSurface surface) {
        if (surface == null) {
            NlActionManager.$$$reportNull$$$0(0);
        }
        super(surface);
    }

    @Override
    public void registerActions(@NotNull JComponent component2) {
        if (component2 == null) {
            NlActionManager.$$$reportNull$$$0(1);
        }
        assert (this.mySelectAllAction == null);
        this.mySelectAllAction = new SelectAllAction(this.mySurface);
        NlActionManager.registerAction(this.mySelectAllAction, "$SelectAll", component2);
        this.myGotoComponentAction = new GotoComponentAction(this.mySurface);
        NlActionManager.registerAction(this.myGotoComponentAction, "GotoDeclaration", component2);
        this.mySelectParent = new SelectParentAction((NlDesignSurface)this.mySurface);
        this.mySelectParent.registerCustomShortcutSet(27, 0, component2);
    }

    @NotNull
    private static ActionGroup createRefactoringMenu() {
        DefaultActionGroup group = new DefaultActionGroup("_Refactor", true);
        com.intellij.openapi.actionSystem.ActionManager manager = com.intellij.openapi.actionSystem.ActionManager.getInstance();
        AnAction action = manager.getAction("AndroidExtractStyleAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("_Extract Style...", action));
        action = manager.getAction("AndroidInlineStyleReferenceAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("_Inline Style...", action));
        action = manager.getAction("AndroidExtractAsIncludeAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("E_xtract Layout...", action));
        action = manager.getAction("AndroidInlineIncludeAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("I_nline Layout...", action));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            NlActionManager.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupMenu(@NotNull com.intellij.openapi.actionSystem.ActionManager actionManager, @Nullable NlComponent leafComponent) {
        if (actionManager == null) {
            NlActionManager.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        ScreenView screenView = ((NlDesignSurface)this.mySurface).getCurrentSceneView();
        if (screenView != null) {
            if (leafComponent != null) {
                this.addViewHandlerActions(group, leafComponent, (List<NlComponent>)screenView.getSelectionModel().getSelection());
            }
            group.add((AnAction)this.createSelectActionGroup(screenView.getSelectionModel()));
            group.addSeparator();
        }
        if (leafComponent != null && StudioFlags.NELE_CONVERT_VIEW.get().booleanValue()) {
            group.add((AnAction)new MorphComponentAction(leafComponent, this.mySurface));
        }
        group.add((AnAction)new MockupEditAction((NlDesignSurface)this.mySurface));
        if (leafComponent != null && Mockup.hasMockupAttribute(leafComponent)) {
            group.add((AnAction)new MockupDeleteAction(leafComponent));
        }
        group.addSeparator();
        group.add(actionManager.getAction("$Cut"));
        group.add(actionManager.getAction("$Copy"));
        group.add(actionManager.getAction("$Paste"));
        group.addSeparator();
        group.add(actionManager.getAction("$Delete"));
        group.addSeparator();
        group.add((AnAction)this.myGotoComponentAction);
        group.add((AnAction)NlActionManager.createRefactoringMenu());
        group.add((AnAction)new SaveScreenshotAction((NlDesignSurface)this.mySurface));
        group.addSeparator();
        group.add((AnAction)new ConvertToConstraintLayoutAction((NlDesignSurface)this.mySurface));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            NlActionManager.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    private void addViewHandlerActions(@NotNull DefaultActionGroup group, @NotNull NlComponent component2, @NotNull List<NlComponent> selection) {
        if (group == null) {
            NlActionManager.$$$reportNull$$$0(5);
        }
        if (component2 == null) {
            NlActionManager.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            NlActionManager.$$$reportNull$$$0(7);
        }
        int prevCount = group.getChildrenCount();
        NlComponent parent = !component2.isRoot() ? component2.getParent() : null;
        this.addActions(group, component2, parent, selection, false);
        if (group.getChildrenCount() > prevCount) {
            group.addSeparator();
        }
    }

    @NotNull
    private ActionGroup createSelectActionGroup(@NotNull SelectionModel model) {
        if (model == null) {
            NlActionManager.$$$reportNull$$$0(8);
        }
        DefaultActionGroup group = new DefaultActionGroup("_Select", true);
        SelectSiblingsAction selectSiblings = new SelectSiblingsAction(model);
        SelectSameTypeAction selectSameType = new SelectSameTypeAction(model);
        DeselectAllAction deselectAllAction = new DeselectAllAction(model);
        group.add(this.mySelectParent);
        group.add((AnAction)selectSiblings);
        group.add((AnAction)selectSameType);
        group.addSeparator();
        group.add(this.mySelectAllAction);
        group.add((AnAction)deselectAllAction);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            NlActionManager.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    @Override
    public void addActions(@NotNull DefaultActionGroup group, @Nullable NlComponent component2, @Nullable NlComponent parent, @NotNull List<NlComponent> newSelection, boolean toolbar) {
        ViewHandler handler;
        ScreenView screenView;
        if (group == null) {
            NlActionManager.$$$reportNull$$$0(10);
        }
        if (newSelection == null) {
            NlActionManager.$$$reportNull$$$0(11);
        }
        if ((screenView = ((NlDesignSurface)this.mySurface).getCurrentSceneView()) == null || parent == null && component2 == null) {
            return;
        }
        ViewEditorImpl editor = new ViewEditorImpl(screenView);
        if (component2 != null) {
            handler = ViewHandlerManager.get(((NlDesignSurface)this.mySurface).getProject()).getHandler(component2);
            this.addViewActionsForHandler(group, component2, newSelection, editor, handler, toolbar);
        }
        if (parent != null) {
            handler = ViewHandlerManager.get(((NlDesignSurface)this.mySurface).getProject()).getHandler(parent);
            ArrayList selectedChildren = Lists.newArrayListWithCapacity((int)newSelection.size());
            for (NlComponent selected : newSelection) {
                if (selected.getParent() != parent) continue;
                selectedChildren.add(selected);
            }
            this.addViewActionsForHandler(group, parent, selectedChildren, editor, handler, toolbar);
        }
    }

    private void addViewActionsForHandler(@NotNull DefaultActionGroup group, @NotNull NlComponent component2, @NotNull List<NlComponent> newSelection, @NotNull ViewEditor editor, @Nullable ViewHandler handler, boolean toolbar) {
        if (group == null) {
            NlActionManager.$$$reportNull$$$0(12);
        }
        if (component2 == null) {
            NlActionManager.$$$reportNull$$$0(13);
        }
        if (newSelection == null) {
            NlActionManager.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            NlActionManager.$$$reportNull$$$0(15);
        }
        if (handler == null) {
            return;
        }
        List<ViewAction> viewActions = NlActionManager.createViewActionList();
        if (toolbar) {
            viewActions.addAll(ViewHandlerManager.get(((NlDesignSurface)this.mySurface).getProject()).getToolbarActions(handler));
        } else {
            viewActions.addAll(ViewHandlerManager.get(((NlDesignSurface)this.mySurface).getProject()).getPopupMenuActions(handler));
        }
        Collections.sort(viewActions);
        group.removeAll();
        ArrayList target = Lists.newArrayList();
        for (ViewAction viewAction : viewActions) {
            this.addActions(target, toolbar, viewAction, ((NlDesignSurface)this.mySurface).getProject(), editor, handler, component2, newSelection);
        }
        boolean lastWasSeparator = false;
        for (AnAction action : target) {
            boolean isSeparator = action instanceof Separator;
            if (isSeparator && lastWasSeparator) continue;
            group.add(action);
            lastWasSeparator = isSeparator;
        }
    }

    @NotNull
    private static List<ViewAction> createViewActionList() {
        ArrayList<ViewAction> arrayList = new ArrayList<ViewAction>(){

            @Override
            public boolean add(ViewAction viewAction) {
                if (!this.isEmpty()) {
                    ViewAction prev = (ViewAction)this.get(this.size() - 1);
                    if (viewAction.getRank() == prev.getRank() || viewAction.getRank() == -1) {
                        viewAction.setRank(prev.getRank() + 5);
                    }
                } else if (viewAction.getRank() == -1) {
                    viewAction.setRank(0);
                }
                return super.add(viewAction);
            }
        };
        if (arrayList == null) {
            NlActionManager.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    void addActions(@NotNull List<AnAction> target, boolean toolbar, @NotNull ViewAction viewAction, @NotNull Project project, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> newSelection) {
        if (target == null) {
            NlActionManager.$$$reportNull$$$0(17);
        }
        if (viewAction == null) {
            NlActionManager.$$$reportNull$$$0(18);
        }
        if (project == null) {
            NlActionManager.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            NlActionManager.$$$reportNull$$$0(20);
        }
        if (handler == null) {
            NlActionManager.$$$reportNull$$$0(21);
        }
        if (parent == null) {
            NlActionManager.$$$reportNull$$$0(22);
        }
        if (newSelection == null) {
            NlActionManager.$$$reportNull$$$0(23);
        }
        if (viewAction instanceof DirectViewAction) {
            target.add(new DirectViewActionWrapper(project, (DirectViewAction)viewAction, editor, handler, parent, newSelection));
        } else if (viewAction instanceof ViewActionSeparator) {
            target.add((AnAction)Separator.getInstance());
        } else if (viewAction instanceof ToggleViewAction) {
            target.add((AnAction)new ToggleViewActionWrapper(project, (ToggleViewAction)viewAction, editor, handler, parent, newSelection));
        } else if (viewAction instanceof ToggleViewActionGroup) {
            ArrayList actions = Lists.newArrayList();
            for (ToggleViewAction action : ((ToggleViewActionGroup)viewAction).getActions()) {
                actions.add(new ToggleViewActionWrapper(project, action, editor, handler, parent, newSelection));
            }
            if (!actions.isEmpty()) {
                ToggleViewActionWrapper prev = null;
                for (ToggleViewActionWrapper action : actions) {
                    target.add((AnAction)action);
                    if (prev != null) {
                        prev.myGroupSibling = action;
                    }
                    prev = action;
                }
                if (prev != null) {
                    prev.myGroupSibling = (ToggleViewActionWrapper)actions.get(0);
                }
            }
        } else if (viewAction instanceof ViewActionMenu) {
            target.add((AnAction)new ViewActionMenuWrapper((ViewActionMenu)viewAction, editor, handler, parent, newSelection));
        } else if (viewAction instanceof NestedViewActionMenu) {
            if (toolbar) {
                target.add((AnAction)new ViewActionToolbarMenuWrapper((NestedViewActionMenu)viewAction, editor, handler, parent, newSelection));
            }
        } else {
            throw new UnsupportedOperationException(viewAction.getClass().getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlActionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewAction";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefactoringMenu";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenu";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectActionGroup";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewActionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerActions";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPopupMenu";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addViewHandlerActions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSelectActionGroup";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addViewActionsForHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ViewActionToolbarMenuWrapper
    extends DropDownAction
    implements ViewActionPresentation {
        private final NestedViewActionMenu myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        public ViewActionToolbarMenuWrapper(@NotNull NestedViewActionMenu action, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, List<NlComponent> selectedChildren) {
            if (action == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(1);
            }
            if (handler == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(2);
            }
            if (component2 == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(3);
            }
            if (selectedChildren == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(4);
            }
            super("", action.getLabel(), action.getDefaultIcon());
            this.myAction = action;
            this.myEditor = editor;
            this.myHandler = handler;
            this.myComponent = component2;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action.getDefaultIcon());
            presentation.setDescription(action.getLabel());
        }

        public void update(AnActionEvent e) {
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        protected boolean updateActions() {
            this.removeAll();
            List<List<ViewAction>> rows = this.myAction.getActions();
            if (rows.size() == 1) {
                ArrayList actions = Lists.newArrayList();
                for (ViewAction viewAction : rows.get(0)) {
                    NlActionManager.this.addActions(actions, false, viewAction, ((NlDesignSurface)NlActionManager.this.mySurface).getProject(), this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                }
                this.addAll(actions);
            }
            return true;
        }

        protected JPanel createCustomComponentPopup() {
            List<List<ViewAction>> rows = this.myAction.getActions();
            if (rows.size() == 1) {
                return null;
            }
            com.intellij.openapi.actionSystem.ActionManager actionManager = com.intellij.openapi.actionSystem.ActionManager.getInstance();
            JPanel panel = new JPanel((LayoutManager)new VerticalLayout(0));
            for (List<ViewAction> row : rows) {
                if (row.size() == 1 && row.get(0) instanceof ViewActionSeparator) {
                    panel.add(new JSeparator());
                    continue;
                }
                ArrayList actions = Lists.newArrayList();
                for (ViewAction viewAction : row) {
                    NlActionManager.this.addActions(actions, false, viewAction, ((NlDesignSurface)NlActionManager.this.mySurface).getProject(), this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                }
                DefaultActionGroup group = new DefaultActionGroup((List)actions);
                ActionToolbar toolbar = actionManager.createActionToolbar("DynamicToolbar", (ActionGroup)group, true);
                panel.add(toolbar.getComponent());
            }
            return panel;
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                ViewActionToolbarMenuWrapper.$$$reportNull$$$0(5);
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon) {
            this.myCurrentPresentation.setIcon(icon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ViewActionMenuWrapper
    extends ActionGroup
    implements ViewActionPresentation {
        private final ViewActionMenu myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        public ViewActionMenuWrapper(@NotNull ViewActionMenu action, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, List<NlComponent> selectedChildren) {
            if (action == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(1);
            }
            if (handler == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(2);
            }
            if (component2 == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(3);
            }
            if (selectedChildren == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(4);
            }
            super(action.getLabel(), true);
            this.myAction = action;
            this.myEditor = editor;
            this.myHandler = handler;
            this.myComponent = component2;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action.getDefaultIcon());
            presentation.setText(action.getLabel());
        }

        public void update(AnActionEvent e) {
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(5);
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon) {
            this.myCurrentPresentation.setIcon(icon);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList actions = Lists.newArrayList();
            for (ViewAction viewAction : this.myAction.getActions()) {
                NlActionManager.this.addActions(actions, false, viewAction, ((NlDesignSurface)NlActionManager.this.mySurface).getProject(), this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
            }
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ViewActionMenuWrapper.$$$reportNull$$$0(6);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setLabel";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ToggleViewActionWrapper
    extends ToggleAction
    implements ViewActionPresentation {
        private final Project myProject;
        private final ToggleViewAction myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;
        private ToggleViewActionWrapper myGroupSibling;

        public ToggleViewActionWrapper(@NotNull Project project, @NotNull ToggleViewAction action, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, List<NlComponent> selectedChildren) {
            if (project == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(0);
            }
            if (action == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(2);
            }
            if (handler == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(3);
            }
            if (component2 == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(4);
            }
            if (selectedChildren == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(5);
            }
            this.myProject = project;
            this.myAction = action;
            this.myEditor = editor;
            this.myHandler = handler;
            this.myComponent = component2;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(action.getUnselectedLabel());
            presentation.setIcon(action.getUnselectedIcon());
            presentation.setSelectedIcon(action.getSelectedIcon());
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myAction.isSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (this.myAction.affectsUndo()) {
                NlWriteCommandAction.run(this.myComponent, Strings.nullToEmpty((String)e.getPresentation().getText()), () -> this.applySelection(state));
            } else {
                try {
                    this.applySelection(state);
                }
                catch (Throwable t) {
                    throw new IncorrectOperationException("View Action required write lock: should not specify affectsUndo=false");
                }
            }
        }

        private void applySelection(boolean state) {
            this.myAction.setSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, state);
            if (state) {
                ToggleViewActionWrapper groupSibling = this.myGroupSibling;
                while (groupSibling != null && groupSibling != this) {
                    groupSibling.myAction.setSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, false);
                    groupSibling = groupSibling.myGroupSibling;
                }
            }
            ((NlDesignSurface)NlActionManager.this.mySurface).repaint();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(6);
            }
            this.myCurrentPresentation = e.getPresentation();
            try {
                boolean selected = this.myAction.isSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                if (this.myAction.getSelectedLabel() != null) {
                    this.myCurrentPresentation.setText(selected ? this.myAction.getSelectedLabel() : this.myAction.getUnselectedLabel());
                }
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers(), selected);
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                ToggleViewActionWrapper.$$$reportNull$$$0(7);
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon) {
            this.myCurrentPresentation.setIcon(icon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DirectViewActionWrapper
    extends AnAction
    implements ViewActionPresentation {
        private final Project myProject;
        private final DirectViewAction myAction;
        private final ViewHandler myHandler;
        private final ViewEditor myEditor;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        public DirectViewActionWrapper(@NotNull Project project, @NotNull DirectViewAction action, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, List<NlComponent> selectedChildren) {
            if (project == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(0);
            }
            if (action == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(2);
            }
            if (handler == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(3);
            }
            if (component2 == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(4);
            }
            if (selectedChildren == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(5);
            }
            this.myProject = project;
            this.myAction = action;
            this.myEditor = editor;
            this.myHandler = handler;
            this.myComponent = component2;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action.getDefaultIcon());
            presentation.setText(action.getLabel());
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myAction.affectsUndo()) {
                NlWriteCommandAction.run(this.myComponent, Strings.nullToEmpty((String)e.getPresentation().getText()), () -> this.myAction.perform(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers()));
            } else {
                try {
                    this.myAction.perform(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
                }
                catch (Throwable t) {
                    throw new IncorrectOperationException("View Action required write lock: should not specify affectsUndo=false");
                }
            }
            ((NlDesignSurface)NlActionManager.this.mySurface).repaint();
        }

        public void update(AnActionEvent e) {
            int modifiers = InteractionManager.getLastModifiers();
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, modifiers);
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                DirectViewActionWrapper.$$$reportNull$$$0(6);
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon) {
            this.myCurrentPresentation.setIcon(icon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AndroidRefactoringActionWrapper
    extends AnAction {
        private final AnAction myRefactoringAction;

        public AndroidRefactoringActionWrapper(@NotNull String text, @NotNull AnAction refactoringAction) {
            if (text == null) {
                AndroidRefactoringActionWrapper.$$$reportNull$$$0(0);
            }
            if (refactoringAction == null) {
                AndroidRefactoringActionWrapper.$$$reportNull$$$0(1);
            }
            super(text, null, null);
            this.myRefactoringAction = refactoringAction;
            this.getTemplatePresentation().setDescription(refactoringAction.getTemplatePresentation().getDescription());
        }

        public void actionPerformed(AnActionEvent e) {
            this.myRefactoringAction.actionPerformed(e);
        }

        public void update(AnActionEvent e) {
            this.myRefactoringAction.update(e);
            Presentation p = e.getPresentation();
            if (!p.isVisible()) {
                p.setEnabled(false);
                p.setVisible(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refactoringAction";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/editor/NlActionManager$AndroidRefactoringActionWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

