/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.ActionMenuViewHandler;
import com.android.tools.idea.uibuilder.handlers.AdapterViewHandler;
import com.android.tools.idea.uibuilder.handlers.AppBarLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.AutoCompleteTextViewHandler;
import com.android.tools.idea.uibuilder.handlers.ButtonHandler;
import com.android.tools.idea.uibuilder.handlers.CardViewHandler;
import com.android.tools.idea.uibuilder.handlers.CheckBoxHandler;
import com.android.tools.idea.uibuilder.handlers.CheckedTextViewHandler;
import com.android.tools.idea.uibuilder.handlers.ChronometerHandler;
import com.android.tools.idea.uibuilder.handlers.CollapsingToolbarLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.DrawerLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.EditTextHandler;
import com.android.tools.idea.uibuilder.handlers.FloatingActionButtonHandler;
import com.android.tools.idea.uibuilder.handlers.FragmentHandler;
import com.android.tools.idea.uibuilder.handlers.FrameLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.HorizontalScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.ImageButtonHandler;
import com.android.tools.idea.uibuilder.handlers.ImageSwitcherHandler;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.handlers.IncludeHandler;
import com.android.tools.idea.uibuilder.handlers.ListViewHandler;
import com.android.tools.idea.uibuilder.handlers.MergeHandler;
import com.android.tools.idea.uibuilder.handlers.NavigationViewHandler;
import com.android.tools.idea.uibuilder.handlers.NestedScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.NoPreviewHandler;
import com.android.tools.idea.uibuilder.handlers.ProgressBarHandler;
import com.android.tools.idea.uibuilder.handlers.RatingBarHandler;
import com.android.tools.idea.uibuilder.handlers.RecyclerViewHandler;
import com.android.tools.idea.uibuilder.handlers.RequestFocusHandler;
import com.android.tools.idea.uibuilder.handlers.ScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.SeekBarHandler;
import com.android.tools.idea.uibuilder.handlers.SpaceHandler;
import com.android.tools.idea.uibuilder.handlers.SpinnerHandler;
import com.android.tools.idea.uibuilder.handlers.SwitchHandler;
import com.android.tools.idea.uibuilder.handlers.TabHostHandler;
import com.android.tools.idea.uibuilder.handlers.TabItemHandler;
import com.android.tools.idea.uibuilder.handlers.TabLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TableLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TableRowHandler;
import com.android.tools.idea.uibuilder.handlers.TextInputLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.TextViewHandler;
import com.android.tools.idea.uibuilder.handlers.ToggleButtonHandler;
import com.android.tools.idea.uibuilder.handlers.ToolbarHandler;
import com.android.tools.idea.uibuilder.handlers.ViewPagerHandler;
import com.android.tools.idea.uibuilder.handlers.ViewStubHandler;
import com.android.tools.idea.uibuilder.handlers.ViewTagHandler;
import com.android.tools.idea.uibuilder.handlers.ZoomButtonHandler;
import com.android.tools.idea.uibuilder.handlers.absolute.AbsoluteLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutBarrierHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutChainHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutLayerHandler;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.google.AdViewHandler;
import com.android.tools.idea.uibuilder.handlers.google.MapViewHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridLayoutV7Handler;
import com.android.tools.idea.uibuilder.handlers.leanback.BrowseFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.DetailsFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.PlaybackOverlayFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.leanback.SearchFragmentHandler;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.preference.CheckBoxPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.EditTextPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.ListPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.MultiSelectListPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceScreenHandler;
import com.android.tools.idea.uibuilder.handlers.preference.RingtonePreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.preference.SwitchPreferenceHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeLayoutHandlerKt;
import com.android.tools.idea.uibuilder.menu.GroupHandler;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.uibuilder.menu.MenuViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.statelist.ItemHandler;
import com.android.tools.idea.uibuilder.statelist.SelectorHandler;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewHandlerManager
implements ProjectComponent {
    private static final String HANDLER_CLASS_SUFFIX = "Handler";
    private static final Set<String> NO_PREFIX_PACKAGES = ImmutableSet.of((Object)"android.widget.", (Object)"android.view.", (Object)"android.webkit.", (Object)"android.app.");
    private final Project myProject;
    private final Map<String, ViewHandler> myHandlers;
    public static final ViewHandler NONE = new ViewHandler();
    private static final ViewHandler STANDARD_HANDLER = new ViewHandler();
    private static final ViewHandler TEXT_HANDLER = new TextViewHandler();
    private static final ViewHandler NO_PREVIEW_HANDLER = new NoPreviewHandler();
    private final Map<ViewHandler, List<ViewAction>> myToolbarActions;
    private final Map<ViewHandler, List<ViewAction>> myMenuActions;

    @NotNull
    public static ViewHandlerManager get(@NotNull Project project) {
        if (project == null) {
            ViewHandlerManager.$$$reportNull$$$0(0);
        }
        ViewHandlerManager manager = (ViewHandlerManager)project.getComponent(ViewHandlerManager.class);
        assert (manager != null);
        ViewHandlerManager viewHandlerManager = manager;
        if (viewHandlerManager == null) {
            ViewHandlerManager.$$$reportNull$$$0(1);
        }
        return viewHandlerManager;
    }

    @NotNull
    public static ViewHandlerManager get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ViewHandlerManager.$$$reportNull$$$0(2);
        }
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(facet.getModule().getProject());
        if (viewHandlerManager == null) {
            ViewHandlerManager.$$$reportNull$$$0(3);
        }
        return viewHandlerManager;
    }

    public ViewHandlerManager(@NotNull Project project) {
        if (project == null) {
            ViewHandlerManager.$$$reportNull$$$0(4);
        }
        this.myHandlers = Maps.newHashMap();
        this.myToolbarActions = Maps.newHashMap();
        this.myMenuActions = Maps.newHashMap();
        this.myProject = project;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull NlComponent component2) {
        String tag;
        if (component2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(5);
        }
        switch (tag = component2.getTagName()) {
            case "item": {
                ViewHandler handler = MenuViewHandlerManager.getHandler(component2);
                if (handler != null) {
                    return handler;
                }
                return new ItemHandler();
            }
            case "merge": {
                String parentTag = component2.getAttribute("http://schemas.android.com/tools", "parentTag");
                return this.getHandler(parentTag == null ? tag : parentTag);
            }
        }
        return this.getHandler(tag);
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull NlComponent component2) {
        ViewHandler handler;
        if (component2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(6);
        }
        ViewHandler viewHandler = (handler = this.getHandler(component2)) != null ? handler : NONE;
        if (viewHandler == null) {
            ViewHandlerManager.$$$reportNull$$$0(7);
        }
        return viewHandler;
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull String viewTag) {
        ViewHandler handler;
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(8);
        }
        ViewHandler viewHandler = (handler = this.getHandler(viewTag)) != null ? handler : NONE;
        if (viewHandler == null) {
            ViewHandlerManager.$$$reportNull$$$0(9);
        }
        return viewHandler;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull String viewTag) {
        ViewHandler handler;
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(10);
        }
        if ((handler = this.myHandlers.get(viewTag)) == null) {
            String tag;
            if (viewTag.indexOf(46) != -1 && !(tag = NlComponentHelper.INSTANCE.viewClassToTag(viewTag)).equals(viewTag) && (handler = this.getHandler(tag)) != null) {
                this.myHandlers.put(viewTag, handler);
                return handler;
            }
            handler = this.createHandler(viewTag);
            this.myHandlers.put(viewTag, handler);
        }
        return handler != NONE ? handler : null;
    }

    public void registerHandler(@NotNull String viewTag, @NotNull ViewHandler handler) {
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            ViewHandlerManager.$$$reportNull$$$0(12);
        }
        this.myHandlers.put(viewTag, handler);
    }

    @Nullable
    public ViewGroupHandler findLayoutHandler(@NotNull NlComponent component2, boolean strict) {
        if (component2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(13);
        }
        NlComponent curr = component2;
        if (strict) {
            curr = curr.getParent();
        }
        while (curr != null) {
            ViewHandler handler = this.getHandler(curr);
            if (handler instanceof ViewGroupHandler) {
                return (ViewGroupHandler)handler;
            }
            curr = curr.getParent();
        }
        return null;
    }

    private ViewHandler createHandler(@NotNull String viewTag) {
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(14);
        }
        switch (viewTag) {
            case "AbsoluteLayout": 
            case "WebView": {
                return new AbsoluteLayoutHandler();
            }
            case "AbsListView": 
            case "AdapterViewAnimator": 
            case "AdapterViewFlipper": 
            case "GridView": 
            case "ViewGroup": {
                return new ViewGroupHandler();
            }
            case "android.support.v7.widget.ActionMenuView": {
                return new ActionMenuViewHandler();
            }
            case "AdapterView": 
            case "StackView": {
                return new AdapterViewHandler();
            }
            case "com.google.android.gms.ads.AdView": {
                return new AdViewHandler();
            }
            case "android.support.design.widget.AppBarLayout": {
                return new AppBarLayoutHandler();
            }
            case "AutoCompleteTextView": {
                return new AutoCompleteTextViewHandler();
            }
            case "android.support.v17.leanback.app.BrowseFragment": {
                return new BrowseFragmentHandler();
            }
            case "Button": {
                return new ButtonHandler();
            }
            case "android.support.v7.widget.CardView": {
                return new CardViewHandler();
            }
            case "CheckedTextView": {
                return new CheckedTextViewHandler();
            }
            case "CheckBox": 
            case "RadioButton": {
                return new CheckBoxHandler();
            }
            case "Chronometer": {
                return new ChronometerHandler();
            }
            case "android.support.constraint.Barrier": {
                return new ConstraintLayoutBarrierHandler();
            }
            case "android.support.constraint.Chain": {
                return new ConstraintLayoutChainHandler();
            }
            case "android.support.constraint.ConstraintHelper": {
                return new ConstraintHelperHandler();
            }
            case "android.support.constraint.Layer": {
                return new ConstraintLayoutLayerHandler();
            }
            case "android.support.design.widget.CollapsingToolbarLayout": {
                return new CollapsingToolbarLayoutHandler();
            }
            case "android.support.constraint.ConstraintLayout": {
                return new ConstraintLayoutHandler();
            }
            case "android.support.design.widget.CoordinatorLayout": {
                return new CoordinatorLayoutHandler();
            }
            case "android.support.v17.leanback.app.DetailsFragment": {
                return new DetailsFragmentHandler();
            }
            case "DialerFilter": 
            case "android.widget.RelativeLayout": 
            case "RelativeLayout": {
                return StudioFlags.NELE_TARGET_RELATIVE.get() != false ? new RelativeLayoutHandlerKt() : new RelativeLayoutHandler();
            }
            case "android.support.v4.widget.DrawerLayout": {
                return new DrawerLayoutHandler();
            }
            case "EditText": {
                return new EditTextHandler();
            }
            case "ExpandableListView": {
                return new ListViewHandler();
            }
            case "com.google.android.flexbox.FlexboxLayout": {
                return NONE;
            }
            case "android.support.design.widget.FloatingActionButton": {
                return new FloatingActionButtonHandler();
            }
            case "android.widget.LinearLayout": 
            case "LinearLayout": 
            case "SearchView": {
                return new LinearLayoutHandler();
            }
            case "FrameLayout": 
            case "GestureOverlayView": 
            case "TextSwitcher": 
            case "ViewAnimator": 
            case "ViewFlipper": 
            case "ViewSwitcher": {
                return new FrameLayoutHandler();
            }
            case "GridLayout": {
                return new GridLayoutHandler();
            }
            case "android.support.v7.widget.GridLayout": {
                return new GridLayoutV7Handler();
            }
            case "HorizontalScrollView": {
                return new HorizontalScrollViewHandler();
            }
            case "ImageButton": {
                return new ImageButtonHandler();
            }
            case "ImageSwitcher": {
                return new ImageSwitcherHandler();
            }
            case "ImageView": 
            case "QuickContactBadge": {
                return new ImageViewHandler();
            }
            case "com.google.android.gms.maps.MapView": {
                return new MapViewHandler();
            }
            case "MultiAutoCompleteTextView": 
            case "TextView": {
                return TEXT_HANDLER;
            }
            case "android.support.design.widget.NavigationView": {
                return new NavigationViewHandler();
            }
            case "android.support.v4.widget.NestedScrollView": {
                return new NestedScrollViewHandler();
            }
            case "android.support.v17.leanback.app.PlaybackOverlayFragment": {
                return new PlaybackOverlayFragmentHandler();
            }
            case "ProgressBar": {
                return new ProgressBarHandler();
            }
            case "CheckBoxPreference": {
                return new CheckBoxPreferenceHandler();
            }
            case "EditTextPreference": {
                return new EditTextPreferenceHandler();
            }
            case "ListPreference": {
                return new ListPreferenceHandler();
            }
            case "MultiSelectListPreference": {
                return new MultiSelectListPreferenceHandler();
            }
            case "PreferenceCategory": {
                return new PreferenceCategoryHandler();
            }
            case "PreferenceScreen": {
                return new PreferenceScreenHandler();
            }
            case "RingtonePreference": {
                return new RingtonePreferenceHandler();
            }
            case "SwitchPreference": {
                return new SwitchPreferenceHandler();
            }
            case "RatingBar": {
                return new RatingBarHandler();
            }
            case "android.support.v7.widget.RecyclerView": {
                return new RecyclerViewHandler();
            }
            case "requestFocus": {
                return new RequestFocusHandler();
            }
            case "ScrollView": {
                return new ScrollViewHandler();
            }
            case "android.support.v17.leanback.app.SearchFragment": {
                return new SearchFragmentHandler();
            }
            case "SeekBar": {
                return new SeekBarHandler();
            }
            case "android.support.design.widget.Snackbar": {
                return STANDARD_HANDLER;
            }
            case "Space": {
                return new SpaceHandler();
            }
            case "Spinner": {
                return new SpinnerHandler();
            }
            case "SurfaceView": 
            case "TextureView": 
            case "VideoView": {
                return NO_PREVIEW_HANDLER;
            }
            case "Switch": {
                return new SwitchHandler();
            }
            case "android.support.constraint.TableConstraintLayout": {
                return new ConstraintLayoutHandler();
            }
            case "TableLayout": {
                return new TableLayoutHandler();
            }
            case "TableRow": {
                return new TableRowHandler();
            }
            case "TabHost": {
                return new TabHostHandler();
            }
            case "android.support.design.widget.TabItem": {
                return new TabItemHandler();
            }
            case "android.support.design.widget.TabLayout": {
                return new TabLayoutHandler();
            }
            case "group": {
                return new GroupHandler();
            }
            case "menu": {
                return new MenuHandler();
            }
            case "selector": {
                return new SelectorHandler();
            }
            case "TextClock": {
                return STANDARD_HANDLER;
            }
            case "android.support.design.widget.TextInputLayout": {
                return new TextInputLayoutHandler();
            }
            case "ToggleButton": {
                return new ToggleButtonHandler();
            }
            case "android.support.v7.widget.Toolbar": {
                return new ToolbarHandler();
            }
            case "View": {
                return STANDARD_HANDLER;
            }
            case "fragment": {
                return new FragmentHandler();
            }
            case "include": {
                return new IncludeHandler();
            }
            case "merge": {
                return new MergeHandler();
            }
            case "android.support.v4.view.ViewPager": {
                return new ViewPagerHandler();
            }
            case "ViewStub": {
                return new ViewStubHandler();
            }
            case "view": {
                return new ViewTagHandler();
            }
            case "ZoomButton": {
                return new ZoomButtonHandler();
            }
        }
        try {
            String defaultHandlerPkgPrefix = "com.android.tools.idea.uibuilder.handlers.";
            String handlerClass = defaultHandlerPkgPrefix + viewTag + HANDLER_CLASS_SUFFIX;
            Class<?> cls = Class.forName(handlerClass);
            return (ViewHandler)cls.newInstance();
        }
        catch (Exception exception) {
            return (ViewHandler)ApplicationManager.getApplication().runReadAction(() -> {
                if (viewTag == null) {
                    ViewHandlerManager.$$$reportNull$$$0(19);
                }
                try {
                    String qualifiedClassName = this.getFullyQualifiedClassName(viewTag);
                    if (qualifiedClassName != null) {
                        String handlerName = viewTag + HANDLER_CLASS_SUFFIX;
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
                        PsiClass[] classes = facade.findClasses(handlerName, GlobalSearchScope.allScope((Project)this.myProject));
                        if (classes.length == 0) {
                            for (PsiClass cls : classes = facade.findClasses(qualifiedClassName, GlobalSearchScope.allScope((Project)this.myProject))) {
                                String fqn;
                                PsiClass superClass = cls.getSuperClass();
                                if (superClass == null || (fqn = superClass.getQualifiedName()) == null) continue;
                                return this.getHandler(NlComponentHelper.INSTANCE.viewClassToTag(fqn));
                            }
                        } else {
                            for (PsiClass cls : classes) {
                                System.out.println("Find view handler " + cls.getQualifiedName() + " of type " + cls.getClass().getName());
                            }
                        }
                    }
                }
                catch (IndexNotReadyException ignore) {
                    return NONE;
                }
                return NONE;
            });
        }
    }

    @Nullable
    private String getFullyQualifiedClassName(@NotNull String viewTag) {
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(15);
        }
        if (viewTag.indexOf(46) > 0) {
            return viewTag;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        for (String packageName : NO_PREFIX_PACKAGES) {
            PsiClass[] classes = facade.findClasses(packageName + viewTag, GlobalSearchScope.allScope((Project)this.myProject));
            if (classes.length <= 0) continue;
            return packageName + viewTag;
        }
        return null;
    }

    public List<ViewAction> getToolbarActions(@NotNull ViewHandler handler) {
        ArrayList actions;
        if (handler == null) {
            ViewHandlerManager.$$$reportNull$$$0(16);
        }
        if ((actions = this.myToolbarActions.get(handler)) == null) {
            actions = Lists.newArrayList();
            handler.addToolbarActions(actions);
            this.myToolbarActions.put(handler, actions);
        }
        return actions;
    }

    public List<ViewAction> getPopupMenuActions(@NotNull ViewHandler handler) {
        ArrayList actions;
        if (handler == null) {
            ViewHandlerManager.$$$reportNull$$$0(17);
        }
        if ((actions = this.myMenuActions.get(handler)) == null) {
            actions = Lists.newArrayList();
            handler.addPopupMenuActions(actions);
            this.myMenuActions.put(handler, actions);
        }
        return actions;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        this.myHandlers.clear();
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myHandlers.clear();
    }

    @NotNull
    public String getComponentName() {
        if ("ViewHandlerManager" == null) {
            ViewHandlerManager.$$$reportNull$$$0(18);
        }
        return "ViewHandlerManager";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewHandlerManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewTag";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewHandlerManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlerOrDefault";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerOrDefault";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findLayoutHandler";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFullyQualifiedClassName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getToolbarActions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPopupMenuActions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createHandler$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

