/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.analytics.NlUsageTracker;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.ActionTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.graphics.NlIcon;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintDragHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintReferenceManagement;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginPopup;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutComponentNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.AnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ClearConstraintsTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintResizeTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.drawing.WidgetDraw;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutHandler
extends ViewGroupHandler
implements ComponentProvider {
    private static final String PREFERENCE_KEY_PREFIX = "ConstraintLayoutPreference";
    public static final String AUTO_CONNECT_PREF_KEY = "ConstraintLayoutPreferenceAutoConnect";
    public static final String SHOW_CONSTRAINTS_PREF_KEY = "ConstraintLayoutPreferenceShowAllConstraints";
    public static final String SHOW_MARGINS_PREF_KEY = "ConstraintLayoutPreferenceShowMargins";
    public static final String FADE_UNSELECTED_VIEWS = "ConstraintLayoutPreferenceFadeUnselected";
    private static final NlIcon BASELINE_ICON = new NlIcon(AndroidIcons.SherpaIcons.BaselineColor, AndroidIcons.SherpaIcons.BaselineBlue);
    private static boolean ourAutoConnect;
    private static final String ADD_VERTICAL_BARRIER = "Add Vertical barrier";
    private static final String ADD_HORIZONTAL_BARRIER = "Add Horizontal Barrier";
    private static final String ADD_TO_BARRIER = "Add to Barrier";
    private static final String ADD_LAYER = "Add Layer";
    private static final String ADD_GROUP = "Add Group";
    private static final String ADD_CONSTRAINTS_SET = "Add set of Constraints";
    public static final String EDIT_BASELINE_ACTION_TOOLTIP = "Edit Baseline";
    private static HashMap<String, Boolean> ourVisibilityFlags;
    static HashSet<String> ourHorizontalBarriers;
    private ArrayList<ViewAction> myActions = new ArrayList();

    static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = UIUtil.createImage((int)w, (int)h, (int)6);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public ConstraintLayoutHandler() {
        ConstraintLayoutHandler.loadWidgetDecoratorImages();
    }

    private static void loadWidgetDecoratorImages() {
        if (WidgetDecorator.sLockImageIcon == null) {
            WidgetDecorator.sLockImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.LockConstraints);
        }
        if (WidgetDecorator.sUnlockImageIcon == null) {
            WidgetDecorator.sUnlockImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.UnlockConstraints);
        }
        if (WidgetDecorator.sDeleteConnectionsImageIcon == null) {
            WidgetDecorator.sDeleteConnectionsImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.DeleteConstraintB);
        }
        if (WidgetDecorator.sPackChainImageIcon == null) {
            WidgetDecorator.sPackChainImageIcon = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ChainStyle);
        }
        if (WidgetDraw.sGuidelineArrowLeft == null) {
            WidgetDraw.sGuidelineArrowLeft = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowLeft);
        }
        if (WidgetDraw.sGuidelineArrowRight == null) {
            WidgetDraw.sGuidelineArrowRight = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowRight);
        }
        if (WidgetDraw.sGuidelineArrowUp == null) {
            WidgetDraw.sGuidelineArrowUp = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowUp);
        }
        if (WidgetDraw.sGuidelineArrowDown == null) {
            WidgetDraw.sGuidelineArrowDown = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.ArrowDown);
        }
        if (WidgetDraw.sGuidelinePercent == null) {
            WidgetDraw.sGuidelinePercent = ConstraintLayoutHandler.iconToImage(AndroidIcons.SherpaIcons.Percent);
        }
    }

    @Override
    @NotNull
    public String getGradleCoordinateId(@NotNull String tagName) {
        if (tagName == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(0);
        }
        if ("com.android.support.constraint:constraint-layout" == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(1);
        }
        return "com.android.support.constraint:constraint-layout";
    }

    @Override
    @NotNull
    public Map<String, Map<String, String>> getEnumPropertyValues(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(2);
        }
        ImmutableMap values = ImmutableMap.of((Object)"0dp", (Object)"match_constraint", (Object)"wrap_content", (Object)"wrap_content");
        ImmutableMap immutableMap = ImmutableMap.of((Object)"layout_width", (Object)values, (Object)"layout_height", (Object)values);
        if (immutableMap == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(3);
        }
        return immutableMap;
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions) {
        if (actions == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(4);
        }
        this.myActions.clear();
        actions.add(new NestedViewActionMenu("Show", StudioIcons.Common.VISIBILITY_INLINE, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new ToggleVisibilityAction(SHOW_CONSTRAINTS_PREF_KEY, "Show Constraints", true), new ToggleVisibilityAction(SHOW_MARGINS_PREF_KEY, "Show Margins", true), new ToggleVisibilityAction(FADE_UNSELECTED_VIEWS, "Fade Unselected views ", false)})})));
        actions.add(new ToggleAutoConnectAction());
        actions.add(new ViewActionSeparator());
        actions.add(new ClearConstraintsAction());
        actions.add(new InferAction());
        actions.add(new ViewActionSeparator());
        actions.add(new MarginSelector());
        actions.add(new NestedViewActionMenu("Pack", StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.HorizontalPack, StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, "Pack Horizontally"), new AlignAction(Scout.Arrange.VerticalPack, StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, "Pack Vertically"), new AlignAction(Scout.Arrange.ExpandHorizontally, StudioIcons.LayoutEditor.Toolbar.EXPAND_HORIZONTAL, "Expand Horizontally"), new AlignAction(Scout.Arrange.ExpandVertically, StudioIcons.LayoutEditor.Toolbar.EXPAND_VERTICAL, "Expand Vertically")}), Lists.newArrayList((Object[])new ViewAction[]{new ViewActionSeparator()}), Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.DistributeHorizontally, AndroidIcons.SherpaIcons.HorizontalDistribute, AndroidIcons.SherpaIcons.HorizontalDistributeB, "Distribute Horizontally"), new AlignAction(Scout.Arrange.DistributeVertically, AndroidIcons.SherpaIcons.verticallyDistribute, AndroidIcons.SherpaIcons.verticallyDistribute, "Distribute Vertically")})})));
        actions.add(new NestedViewActionMenu("Align", AndroidIcons.SherpaIcons.LeftAlignedB, Lists.newArrayList((Object[])new List[]{ConstraintViewActions.ALIGN_HORIZONTALLY_ACTIONS, ConstraintViewActions.ALIGN_VERTICALLY_ACTIONS, Lists.newArrayList((Object[])new ViewAction[]{new ViewActionSeparator()}), ConstraintViewActions.CENTER_ACTIONS})));
        actions.add(new NestedViewActionMenu("Guidelines", StudioIcons.LayoutEditor.Toolbar.VERTICAL_GUIDE, Lists.newArrayList((Object[])new List[]{ConstraintViewActions.HELPER_ACTIONS})));
    }

    @Override
    public void addPopupMenuActions(@NotNull List<ViewAction> actions) {
        if (actions == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(5);
        }
        actions.add(new ViewActionMenu("Organize", StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, (List<ViewAction>)ConstraintViewActions.ORGANIZE_ACTIONS));
        actions.add(new ViewActionMenu("Align", StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, (List<ViewAction>)ConstraintViewActions.ALIGN_ACTIONS));
        actions.add(new ViewActionMenu("Chain", AndroidIcons.SherpaIcons.CreateHorizontalChain, (List<ViewAction>)ConstraintViewActions.CHAIN_ACTIONS));
        actions.add(new ViewActionMenu("Center", StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL, (List<ViewAction>)ConstraintViewActions.CENTER_ACTIONS));
        actions.add(new ViewActionMenu("Helpers", StudioIcons.LayoutEditor.Toolbar.VERTICAL_GUIDE, (List<ViewAction>)ConstraintViewActions.HELPER_ACTIONS));
    }

    public void updateActions(List<NlComponent> selection) {
        Enableable e;
        if (this.myActions == null) {
            return;
        }
        for (ViewAction action : this.myActions) {
            if (!(action instanceof Enableable)) continue;
            e = (Enableable)((Object)action);
            e.enable(selection);
        }
        for (ViewAction action : ConstraintViewActions.ALL_POPUP_ACTIONS) {
            if (!(action instanceof Enableable)) continue;
            e = (Enableable)((Object)action);
            e.enable(selection);
        }
    }

    @Override
    public Interaction createInteraction(@NotNull ScreenView screenView, @NotNull NlComponent component2) {
        if (screenView == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(6);
        }
        if (component2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(7);
        }
        return new ConstraintSceneInteraction(screenView, component2);
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent component2, boolean isParent) {
        if (component2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(8);
        }
        ArrayList<Target> result = new ArrayList<Target>();
        boolean showAnchors = !isParent;
        NlComponent nlComponent = component2.getAuthoritativeNlComponent();
        ViewInfo vi = NlComponentHelperKt.getViewInfo(nlComponent);
        if (vi != null) {
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, "android.support.constraint.Guideline")) {
                String orientation = nlComponent.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
                boolean isHorizontal = true;
                if (orientation != null && orientation.equalsIgnoreCase("vertical")) {
                    isHorizontal = false;
                }
                result.add(new GuidelineTarget(isHorizontal));
                if (isHorizontal) {
                    result.add(new GuidelineAnchorTarget(AnchorTarget.Type.TOP, true));
                } else {
                    result.add(new GuidelineAnchorTarget(AnchorTarget.Type.LEFT, false));
                }
                result.add(new GuidelineCycleTarget(isHorizontal));
                ArrayList<Target> arrayList = result;
                if (arrayList == null) {
                    ConstraintLayoutHandler.$$$reportNull$$$0(9);
                }
                return arrayList;
            }
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, "android.support.constraint.Barrier")) {
                String side = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection");
                boolean isHorizontal = side == null || ourHorizontalBarriers.contains(side.toLowerCase());
                result.add(new BarrierAnchorTarget(isHorizontal ? AnchorTarget.Type.TOP : AnchorTarget.Type.RIGHT, BarrierTarget.parseDirection(side)));
                result.add(new BarrierTarget(BarrierTarget.parseDirection(side)));
                ArrayList<Target> arrayList = result;
                if (arrayList == null) {
                    ConstraintLayoutHandler.$$$reportNull$$$0(10);
                }
                return arrayList;
            }
        }
        if (!isParent) {
            component2.setComponentProvider(this);
        }
        if (showAnchors) {
            ConstraintDragTarget dragTarget = new ConstraintDragTarget();
            result.add(dragTarget);
            result.add(new ConstraintResizeTarget(ResizeBaseTarget.Type.LEFT));
            result.add(new ConstraintResizeTarget(ResizeBaseTarget.Type.RIGHT));
            result.add(new ConstraintResizeTarget(ResizeBaseTarget.Type.TOP));
            result.add(new ConstraintResizeTarget(ResizeBaseTarget.Type.BOTTOM));
            result.add(new ConstraintResizeTarget(ResizeBaseTarget.Type.LEFT_TOP));
            result.add(new ConstraintResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM));
            result.add(new ConstraintResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP));
            result.add(new ConstraintResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM));
            component2.setNotchProvider(new ConstraintLayoutComponentNotchProvider());
        } else {
            result.add(new LassoTarget());
            component2.setNotchProvider(new ConstraintLayoutNotchProvider());
        }
        result.add(new AnchorTarget(AnchorTarget.Type.LEFT, showAnchors));
        result.add(new AnchorTarget(AnchorTarget.Type.TOP, showAnchors));
        result.add(new AnchorTarget(AnchorTarget.Type.RIGHT, showAnchors));
        result.add(new AnchorTarget(AnchorTarget.Type.BOTTOM, showAnchors));
        if (showAnchors) {
            ActionTarget previousAction = new ClearConstraintsTarget(null);
            result.add(previousAction);
            int baseline = NlComponentHelperKt.getBaseline(component2.getNlComponent());
            ViewInfo info = NlComponentHelperKt.getViewInfo(component2.getNlComponent());
            if (baseline <= 0 && info != null) {
                baseline = info.getBaseLine();
            }
            if (baseline > 0) {
                result.add(new AnchorTarget(AnchorTarget.Type.BASELINE, true));
                ActionTarget baselineActionTarget = new ActionTarget(previousAction, BASELINE_ICON, c -> c.setShowBaseline(!c.canShowBaseline())){

                    @Override
                    @NotNull
                    public String getToolTipText() {
                        if (ConstraintLayoutHandler.EDIT_BASELINE_ACTION_TOOLTIP == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return ConstraintLayoutHandler.EDIT_BASELINE_ACTION_TOOLTIP;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$1", "getToolTipText"));
                    }
                };
                result.add(baselineActionTarget);
                previousAction = baselineActionTarget;
            }
            ChainCycleTarget chainCycleTarget = new ChainCycleTarget(previousAction, null);
            result.add(chainCycleTarget);
        }
        ArrayList<Target> arrayList = result;
        if (arrayList == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    public void cleanUpAttributes(@NotNull ViewEditor editor, @NotNull NlComponent child) {
        SceneComponent childSceneComponent;
        if (editor == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(12);
        }
        if (child == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(13);
        }
        if ((childSceneComponent = ((ViewEditorImpl)editor).getSceneView().getScene().getSceneComponent(child)) == null) {
            return;
        }
        AttributesTransaction transaction = child.startAttributeTransaction();
        ConstraintComponentUtilities.cleanup(transaction, childSceneComponent);
        transaction.commit();
    }

    @Override
    public void clearAttributes(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(14);
        }
        ConstraintComponentUtilities.clearAttributes(component2);
    }

    @Override
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(15);
        }
        if (layout == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(16);
        }
        if (components == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(17);
        }
        if (type == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(18);
        }
        return new ConstraintDragHandler(editor, this, layout, components, type);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    public boolean drawGroup(@NotNull Graphics2D gc, @NotNull ScreenView screenView, @NotNull NlComponent component2) {
        if (gc == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(19);
        }
        if (screenView == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(20);
        }
        if (component2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(21);
        }
        this.updateActions((List<NlComponent>)component2.getModel().getSelectionModel().getSelection());
        return false;
    }

    private static void ensureLayersAreShown(@NotNull ViewEditor editor, int duration) {
        if (editor == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(22);
        }
        NlDesignSurface designSurface = (NlDesignSurface)((ViewEditorImpl)editor).getSceneView().getSurface();
        designSurface.forceLayersPaint(true);
        designSurface.repaint();
        Timer timer = new Timer(duration, actionEvent -> designSurface.forceLayersPaint(false));
        timer.setRepeats(false);
        timer.start();
    }

    public static boolean getVisualProperty(String prop) {
        if (ourVisibilityFlags.containsKey(prop)) {
            return ourVisibilityFlags.get(prop);
        }
        boolean selected = PropertiesComponent.getInstance().getBoolean(prop);
        ourVisibilityFlags.put(prop, selected);
        return selected;
    }

    public static void forceDefaultVisualProperties() {
        ourVisibilityFlags.put(SHOW_CONSTRAINTS_PREF_KEY, true);
        ourVisibilityFlags.put(SHOW_MARGINS_PREF_KEY, true);
        ourVisibilityFlags.put(FADE_UNSELECTED_VIEWS, false);
    }

    @Override
    public boolean deleteChildren(@NotNull NlComponent parent, @NotNull Collection<NlComponent> deleted) {
        if (parent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(23);
        }
        if (deleted == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(24);
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            NlComponent component2 = parent.getChild(i);
            if (deleted.contains(component2)) continue;
            ConstraintLayoutHandler.willDelete(component2, deleted);
        }
        return false;
    }

    private static void willDelete(NlComponent component2, @NotNull Collection<NlComponent> deleted) {
        if (deleted == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(25);
        }
        for (NlComponent deletedComponent : deleted) {
            String id = deletedComponent.getId();
            ConstraintComponentUtilities.updateOnDelete(component2, id);
            NlComponent parent = deletedComponent.getParent();
            if (parent == null || id == null) continue;
            ConstraintHelperHandler.willDelete(parent, id);
        }
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"minWidth", (Object)"maxWidth", (Object)"minHeight", (Object)"maxHeight");
        if (immutableList == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(26);
        }
        return immutableList;
    }

    @Override
    public ComponentProvider getComponentProvider(@NotNull SceneComponent component2) {
        String attribute;
        SceneComponent parent;
        if (component2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(27);
        }
        if ((parent = component2.getParent()) == null) {
            return null;
        }
        NlComponent nlComponent = parent.getNlComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, "android.support.constraint.ConstraintLayout") && (attribute = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraints")) != null) {
            return this;
        }
        return null;
    }

    @Override
    public NlComponent getComponent(@NotNull SceneComponent component2) {
        SceneComponent parent;
        if (component2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(28);
        }
        if ((parent = component2.getParent()) == null) {
            return component2.getNlComponent();
        }
        NlComponent nlComponent = parent.getNlComponent();
        String attribute = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraintSet");
        if ((attribute = NlComponent.extractId(attribute)) == null) {
            return component2.getNlComponent();
        }
        NlComponent constraints = null;
        for (SceneComponent sceneComponent : parent.getChildren()) {
            String childId = sceneComponent.getNlComponent().getId();
            if (!Objects.equals(attribute, childId)) continue;
            constraints = sceneComponent.getNlComponent();
            break;
        }
        if (constraints == null) {
            return component2.getNlComponent();
        }
        for (NlComponent nlComponent2 : constraints.getChildren()) {
            String reference = nlComponent2.getLiveAttribute("http://schemas.android.com/apk/res/android", "id");
            if ((reference = NlComponent.extractId(reference)) == null || !reference.equals(component2.getNlComponent().getId())) continue;
            return nlComponent2;
        }
        return component2.getNlComponent();
    }

    static {
        ourVisibilityFlags = new HashMap();
        ourAutoConnect = PropertiesComponent.getInstance().getBoolean(AUTO_CONNECT_PREF_KEY, false);
        ourHorizontalBarriers = new HashSet<String>(Arrays.asList("top", "bottom"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 14: 
            case 21: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 12: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleCoordinateId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumPropertyValues";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargets";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGradleCoordinateId";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEnumPropertyValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPopupMenuActions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInteraction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTargets";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpAttributes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearAttributes";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDragHandler";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "drawGroup";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ensureLayersAreShown";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildren";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "willDelete";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getComponentProvider";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstraintViewActions {
        private static final ImmutableList<ViewAction> ALIGN_HORIZONTALLY_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.AlignHorizontallyLeft, StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, AndroidIcons.SherpaIcons.LeftAlignedB, "Align Left Edges"), (Object)new AlignAction(Scout.Arrange.AlignHorizontallyCenter, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_CENTER_ALIGNED, AndroidIcons.SherpaIcons.CenterAlignedB, "Align Horizontal Centers"), (Object)new AlignAction(Scout.Arrange.AlignHorizontallyRight, StudioIcons.LayoutEditor.Toolbar.RIGHT_ALIGNED, AndroidIcons.SherpaIcons.RightAlignedB, "Align Right Edges"));
        private static final ImmutableList<ViewAction> ALIGN_VERTICALLY_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.AlignVerticallyTop, StudioIcons.LayoutEditor.Toolbar.TOP_ALIGNED, AndroidIcons.SherpaIcons.TopAlignB, "Align Top Edges"), (Object)new AlignAction(Scout.Arrange.AlignVerticallyMiddle, StudioIcons.LayoutEditor.Toolbar.VERTICAL_CENTER_ALIGNED, AndroidIcons.SherpaIcons.MiddleAlignB, "Align Vertical Centers"), (Object)new AlignAction(Scout.Arrange.AlignVerticallyBottom, StudioIcons.LayoutEditor.Toolbar.BOTTOM_ALIGNED, AndroidIcons.SherpaIcons.BottomAlignB, "Align Bottom Edges"), (Object)new AlignAction(Scout.Arrange.AlignBaseline, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED, AndroidIcons.SherpaIcons.BaselineAlignB, "Align Baselines"));
        private static final ImmutableList<ViewAction> ALIGN_ACTIONS = ImmutableList.builder().addAll(ALIGN_HORIZONTALLY_ACTIONS).addAll(ALIGN_VERTICALLY_ACTIONS).build();
        private static final ImmutableList<ViewAction> CHAIN_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.CreateHorizontalChain, AndroidIcons.SherpaIcons.CreateHorizontalChain, AndroidIcons.SherpaIcons.CreateHorizontalChain, "Create Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, "Create Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainInsertHorizontal, AndroidIcons.SherpaIcons.CreateHorizontalChain, AndroidIcons.SherpaIcons.CreateHorizontalChain, "Insert in Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainInsertVertical, AndroidIcons.SherpaIcons.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, "Insert in  Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalRemove, AndroidIcons.SherpaIcons.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, "remove from Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalRemove, AndroidIcons.SherpaIcons.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, "remove from Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalMoveUp, AndroidIcons.SherpaIcons.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, "move up Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalMoveDown, AndroidIcons.SherpaIcons.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, "move down Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalMoveLeft, AndroidIcons.SherpaIcons.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, "move left Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalMoveRight, AndroidIcons.SherpaIcons.CreateVerticalChain, AndroidIcons.SherpaIcons.CreateVerticalChain, "move right Horizontal Chain"));
        private static final ImmutableList<ViewAction> CENTER_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.CenterHorizontally, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL, AndroidIcons.SherpaIcons.HorizontalCenterB, "Center Horizontally"), (Object)new AlignAction(Scout.Arrange.CenterVertically, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL, AndroidIcons.SherpaIcons.VerticalCenterB, "Center Vertically"), (Object)new AlignAction(Scout.Arrange.CenterHorizontallyInParent, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_PARENT, AndroidIcons.SherpaIcons.HorizontalCenterParentB, "Center Horizontally in Parent"), (Object)new AlignAction(Scout.Arrange.CenterVerticallyInParent, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_PARENT, AndroidIcons.SherpaIcons.VerticalCenterParentB, "Center Vertically in Parent"));
        private static final ImmutableList<ViewAction> ORGANIZE_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.HorizontalPack, StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, "Pack Horizontally"), (Object)new AlignAction(Scout.Arrange.VerticalPack, StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, "Pack Vertically"), (Object)new AlignAction(Scout.Arrange.ExpandHorizontally, StudioIcons.LayoutEditor.Toolbar.EXPAND_HORIZONTAL, "Expand Horizontally"), (Object)new AlignAction(Scout.Arrange.ExpandVertically, StudioIcons.LayoutEditor.Toolbar.EXPAND_VERTICAL, "Expand Vertically"));
        private static final ImmutableList<ViewAction> HELPER_ACTIONS = ImmutableList.of((Object)new AddElementAction(1, StudioIcons.LayoutEditor.Toolbar.VERTICAL_GUIDE, "Add Vertical Guideline"), (Object)new AddElementAction(0, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_GUIDE, "Add Horizontal Guideline"), (Object)new AddElementAction(3, AndroidIcons.SherpaIcons.BarrierVertical, "Add Vertical barrier"), (Object)new AddElementAction(2, AndroidIcons.SherpaIcons.BarrierHorizontal, "Add Horizontal Barrier"), (Object)new AddElementAction(4, AndroidIcons.SherpaIcons.Layer, "Add Group"), (Object)new AddElementAction(5, AndroidIcons.SherpaIcons.Layer, "Add set of Constraints"), (Object)new AddElementAction(6, AndroidIcons.SherpaIcons.Layer, "Add Layer"));
        private static final ImmutableList<ViewAction> ALL_POPUP_ACTIONS = ImmutableList.builder().addAll(ALIGN_HORIZONTALLY_ACTIONS).addAll(ALIGN_VERTICALLY_ACTIONS).addAll(ORGANIZE_ACTIONS).addAll(CENTER_ACTIONS).addAll(HELPER_ACTIONS).build();

        private ConstraintViewActions() {
        }
    }

    private static class MarginSelector
    extends DirectViewAction {
        MarginPopup myMarginPopup = new MarginPopup();
        private int myMarginIconValue;
        private Icon myMarginIcon;

        public MarginSelector() {
            this.setLabel("Default Margins");
            this.myMarginPopup.setActionListener(e -> this.setMargin());
        }

        public void setMargin() {
            Scout.setMargin(this.myMarginPopup.getValue());
        }

        private void updateIcon() {
            final int margin = this.myMarginPopup.getValue();
            if (this.myMarginIconValue != margin) {
                this.myMarginIconValue = margin;
                this.myMarginIcon = new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.setColor(JBColor.foreground());
                        g.setFont(g.getFont().deriveFont(1, 12.0f));
                        String m = Integer.toString(margin);
                        FontMetrics metrics = g.getFontMetrics();
                        int strWidth = metrics.stringWidth(m);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        int stringY = (this.getIconHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                        g.drawString(m, x + (this.getIconWidth() - strWidth) / 2, y + stringY);
                    }

                    @Override
                    public int getIconWidth() {
                        return 16;
                    }

                    @Override
                    public int getIconHeight() {
                        return 16;
                    }
                };
            }
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                MarginSelector.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                MarginSelector.$$$reportNull$$$0(1);
            }
            if (component2 == null) {
                MarginSelector.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                MarginSelector.$$$reportNull$$$0(3);
            }
            DesignSurface surface = ((ViewEditorImpl)editor).getSceneView().getSurface();
            NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.DEFAULT_MARGINS);
            RelativePoint relativePoint = new RelativePoint((Component)surface, new Point(0, 0));
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myMarginPopup, this.myMarginPopup.getTextField()).setRequestFocus(true).createPopup().show(relativePoint);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                MarginSelector.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                MarginSelector.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                MarginSelector.$$$reportNull$$$0(6);
            }
            if (component2 == null) {
                MarginSelector.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                MarginSelector.$$$reportNull$$$0(8);
            }
            this.updateIcon();
            if (this.myMarginIcon instanceof ControlIcon) {
                ((ControlIcon)this.myMarginIcon).setHighlight(ourAutoConnect || (2 & modifiers) == 0);
            }
            presentation.setIcon(this.myMarginIcon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$MarginSelector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AlignAction
    extends DirectViewAction {
        private final Scout.Arrange myActionType;
        private final Icon myAlignIcon;
        private final Icon myConstrainIcon;
        private final String myToolTip;

        AlignAction(Scout.Arrange actionType, Icon alignIcon, String toolTip) {
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = null;
            this.myToolTip = toolTip;
        }

        AlignAction(Scout.Arrange actionType, Icon alignIcon, Icon constrainIcon, String toolTip) {
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = constrainIcon;
            this.myToolTip = toolTip;
        }

        private boolean isEnabled(List<NlComponent> selected) {
            int count = selected.size();
            switch (this.myActionType) {
                case AlignVerticallyTop: 
                case AlignVerticallyMiddle: 
                case AlignVerticallyBottom: 
                case AlignHorizontallyLeft: 
                case AlignHorizontallyCenter: 
                case AlignHorizontallyRight: 
                case DistributeVertically: 
                case DistributeHorizontally: 
                case VerticalPack: 
                case HorizontalPack: 
                case AlignBaseline: {
                    return count > 1;
                }
                case CreateHorizontalChain: {
                    return count > 1 && !Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain);
                }
                case CreateVerticalChain: {
                    return count > 1 && !Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain);
                }
                case ExpandVertically: 
                case ExpandHorizontally: 
                case CenterHorizontallyInParent: 
                case CenterVerticallyInParent: 
                case CenterVertically: 
                case CenterHorizontally: {
                    return count >= 1;
                }
                case ChainHorizontalMoveLeft: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsTopOfChain);
                }
                case ChainVerticalMoveDown: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsBottomOfChain);
                }
                case ChainVerticalMoveUp: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsTopOfChain);
                }
                case ChainHorizontalMoveRight: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsBottomOfChain);
                }
                case ChainHorizontalRemove: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain);
                }
                case ChainVerticalRemove: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain);
                }
                case ChainInsertHorizontal: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.IsNearHorizontalChain);
                }
                case ChainInsertVertical: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.IsNearVerticalChain);
                }
            }
            return false;
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                AlignAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                AlignAction.$$$reportNull$$$0(1);
            }
            if (component2 == null) {
                AlignAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                AlignAction.$$$reportNull$$$0(3);
            }
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getSceneView().getSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.ALIGN);
            Scout.arrangeWidgets(this.myActionType, selectedChildren, (modifiers &= 2) == 0 || ourAutoConnect);
            ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                AlignAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                AlignAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                AlignAction.$$$reportNull$$$0(6);
            }
            if (component2 == null) {
                AlignAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                AlignAction.$$$reportNull$$$0(8);
            }
            Icon icon = this.myAlignIcon;
            if (this.myConstrainIcon != null && (ourAutoConnect || (2 & modifiers) == 0)) {
                icon = this.myConstrainIcon;
            }
            presentation.setVisible(this.isEnabled(selectedChildren));
            presentation.setEnabled(this.isEnabled(selectedChildren));
            presentation.setIcon(icon);
            presentation.setLabel(this.myToolTip);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$AlignAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddElementAction
    extends DirectViewAction {
        public static final int HORIZONTAL_GUIDELINE = 0;
        public static final int VERTICAL_GUIDELINE = 1;
        public static final int HORIZONTAL_BARRIER = 2;
        public static final int VERTICAL_BARRIER = 3;
        public static final int GROUP = 4;
        public static final int CONSTRAINT_SET = 5;
        public static final int LAYER = 6;
        final int myType;

        public AddElementAction(int type, Icon icon, String text) {
            super(icon, text);
            this.myType = type;
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            NlComponent parent;
            if (editor == null) {
                AddElementAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                AddElementAction.$$$reportNull$$$0(1);
            }
            if (component2 == null) {
                AddElementAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                AddElementAction.$$$reportNull$$$0(3);
            }
            for (parent = component2; parent != null && !NlComponentHelperKt.isOrHasSuperclass(parent, "android.support.constraint.ConstraintLayout"); parent = parent.getParent()) {
            }
            if (parent != null) {
                ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
                switch (this.myType) {
                    case 0: {
                        NlComponent guideline = NlComponentHelperKt.createChild(parent, editor, "android.support.constraint.Guideline", null, InsertType.CREATE);
                        assert (guideline != null);
                        NlComponentHelperKt.ensureId(guideline);
                        guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                        NlUsageTracker tracker = NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getSceneView().getSurface());
                        tracker.logAction(LayoutEditorEvent.LayoutEditorEventType.ADD_HORIZONTAL_GUIDELINE);
                        guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "horizontal");
                        break;
                    }
                    case 1: {
                        NlComponent guideline = NlComponentHelperKt.createChild(parent, editor, "android.support.constraint.Guideline", null, InsertType.CREATE);
                        assert (guideline != null);
                        NlComponentHelperKt.ensureId(guideline);
                        guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                        NlUsageTracker tracker = NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getSceneView().getSurface());
                        tracker.logAction(LayoutEditorEvent.LayoutEditorEventType.ADD_VERTICAL_GUIDELINE);
                        guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
                        break;
                    }
                    case 4: {
                        NlComponent group = NlComponentHelperKt.createChild(parent, editor, "android.support.constraint.Group", null, InsertType.CREATE);
                        assert (group != null);
                        NlComponentHelperKt.ensureId(group);
                        break;
                    }
                    case 5: {
                        NlComponent constraints = NlComponentHelperKt.createChild(parent, editor, "android.support.constraint.Constraints", null, InsertType.CREATE);
                        assert (constraints != null);
                        NlComponentHelperKt.ensureId(constraints);
                        ConstraintReferenceManagement.populateConstraints(constraints);
                        break;
                    }
                    case 6: {
                        NlComponent layer = NlComponentHelperKt.createChild(parent, editor, "android.support.constraint.Layer", null, InsertType.CREATE);
                        assert (layer != null);
                        NlComponentHelperKt.ensureId(layer);
                        break;
                    }
                    case 2: {
                        NlComponent barrier;
                        int barriers = 0;
                        int other = 0;
                        for (NlComponent nlComponent : selectedChildren) {
                            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, "android.support.constraint.Barrier")) {
                                ++barriers;
                            }
                            if (ConstraintComponentUtilities.isLine(nlComponent)) continue;
                            ++other;
                        }
                        if (barriers == 1 && other > 0) {
                            barrier = null;
                            for (NlComponent child : selectedChildren) {
                                if (NlComponentHelperKt.isOrHasSuperclass(child, "android.support.constraint.Barrier")) break;
                            }
                            return;
                        }
                        barrier = NlComponentHelperKt.createChild(parent, editor, "android.support.constraint.Barrier", null, InsertType.CREATE);
                        assert (barrier != null);
                        NlComponentHelperKt.ensureId(barrier);
                        barrier.setAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection", "top");
                        break;
                    }
                    case 3: {
                        Object barrier;
                        int barriers = 0;
                        int other = 0;
                        for (NlComponent nlComponent : selectedChildren) {
                            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, "android.support.constraint.Barrier")) {
                                ++barriers;
                            }
                            if (ConstraintComponentUtilities.isLine(nlComponent)) continue;
                            ++other;
                        }
                        if (barriers == 1 && other > 0) {
                            barrier = null;
                            for (NlComponent child : selectedChildren) {
                                if (NlComponentHelperKt.isOrHasSuperclass(child, "android.support.constraint.Barrier")) break;
                            }
                            return;
                        }
                        barrier = NlComponentHelperKt.createChild(parent, editor, "android.support.constraint.Barrier", null, InsertType.CREATE);
                        assert (barrier != null);
                        NlComponentHelperKt.ensureId((NlComponent)barrier);
                        ((NlComponent)barrier).setAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection", "left");
                    }
                }
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                AddElementAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                AddElementAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                AddElementAction.$$$reportNull$$$0(6);
            }
            if (component2 == null) {
                AddElementAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                AddElementAction.$$$reportNull$$$0(8);
            }
            boolean show = true;
            if ((this.myType == 3 || this.myType == 2) && (show = ConstraintComponentUtilities.isConstraintModelGreaterThan(component2.getModel(), 1, 0))) {
                int barriers = 0;
                int other = 0;
                for (NlComponent child : selectedChildren) {
                    if (NlComponentHelperKt.isOrHasSuperclass(child, "android.support.constraint.Barrier")) {
                        ++barriers;
                    }
                    if (ConstraintComponentUtilities.isLine(child)) continue;
                    ++other;
                }
                if (barriers == 1 && other > 0) {
                    presentation.setLabel(ConstraintLayoutHandler.ADD_TO_BARRIER);
                } else {
                    presentation.setLabel(this.myType == 3 ? ConstraintLayoutHandler.ADD_VERTICAL_BARRIER : ConstraintLayoutHandler.ADD_HORIZONTAL_BARRIER);
                }
            }
            if (this.myType == 4) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(component2.getModel(), 1, 0);
            }
            if (this.myType == 5) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(component2.getModel(), 1, 9);
            }
            if (this.myType == 6) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(component2.getModel(), 1, 9);
            }
            presentation.setVisible(show);
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$AddElementAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ControlIcon
    implements Icon {
        public static final Color HIGHLIGHT_COLOR = new Color(240116);
        Icon myIcon;
        boolean myHighlight;

        ControlIcon(Icon icon) {
            this.myIcon = icon;
        }

        public void setHighlight(boolean mHighlight) {
            this.myHighlight = mHighlight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myIcon.paintIcon(c, g, x, y);
            if (this.myHighlight) {
                g.setColor(HIGHLIGHT_COLOR);
                g.fillRect(x, y + this.getIconHeight() - 2, this.getIconWidth(), 2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }

    private static class ToggleVisibilityAction
    extends ToggleViewAction {
        String mType;

        public ToggleVisibilityAction(String type, String text, boolean defaultValue) {
            super(AndroidIcons.SherpaIcons.Unchecked, AndroidIcons.SherpaIcons.Checked, text, text);
            this.mType = type;
            ourVisibilityFlags.put(this.mType, PropertiesComponent.getInstance().getBoolean(type, defaultValue));
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            if (editor == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(3);
            }
            return (Boolean)ourVisibilityFlags.get(this.mType);
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            if (editor == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(4);
            }
            if (handler == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(5);
            }
            if (parent == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(6);
            }
            if (selectedChildren == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(7);
            }
            ourVisibilityFlags.put(this.mType, selected);
            PropertiesComponent.getInstance().setValue(this.mType, selected);
            ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ToggleVisibilityAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InferAction
    extends DirectViewAction {
        private InferAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                InferAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                InferAction.$$$reportNull$$$0(1);
            }
            if (component2 == null) {
                InferAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                InferAction.$$$reportNull$$$0(3);
            }
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getSceneView().getSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.INFER_CONSTRAINS);
            try {
                Scout.inferConstraintsAndCommit(component2);
                ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
            }
            catch (Exception e) {
                Logger.getInstance(ConstraintLayoutHandler.class).warn("Error in inferring constraints", (Throwable)e);
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                InferAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                InferAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                InferAction.$$$reportNull$$$0(6);
            }
            if (component2 == null) {
                InferAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                InferAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.INFER_CONSTRAINTS);
            presentation.setLabel("Infer Constraints");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$InferAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClearConstraintsAction
    extends DirectViewAction {
        private ClearConstraintsAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                ClearConstraintsAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ClearConstraintsAction.$$$reportNull$$$0(1);
            }
            if (component2 == null) {
                ClearConstraintsAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ClearConstraintsAction.$$$reportNull$$$0(3);
            }
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getSceneView().getSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.CLEAR_ALL_CONSTRAINTS);
            ViewEditorImpl viewEditor = (ViewEditorImpl)editor;
            Scene scene = viewEditor.getSceneView().getScene();
            scene.clearAttributes();
            ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                ClearConstraintsAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                ClearConstraintsAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                ClearConstraintsAction.$$$reportNull$$$0(6);
            }
            if (component2 == null) {
                ClearConstraintsAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                ClearConstraintsAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.CLEAR_CONSTRAINTS);
            presentation.setLabel("Clear All Constraints");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ClearConstraintsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToggleAutoConnectAction
    extends ToggleViewAction
    implements Enableable {
        public ToggleAutoConnectAction() {
            super(StudioIcons.LayoutEditor.Toolbar.AUTO_CORRECT_OFF, StudioIcons.LayoutEditor.Toolbar.AUTO_CONNECT, "Turn On Autoconnect", "Turn Off Autoconnect");
        }

        @Override
        public void enable(List<NlComponent> selection) {
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            if (editor == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(3);
            }
            return PropertiesComponent.getInstance().getBoolean(ConstraintLayoutHandler.AUTO_CONNECT_PREF_KEY, false);
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            if (editor == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(4);
            }
            if (handler == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(5);
            }
            if (parent == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(6);
            }
            if (selectedChildren == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(7);
            }
            NlUsageTrackerManager.getInstance(((ViewEditorImpl)editor).getSceneView().getSurface()).logAction(selected ? LayoutEditorEvent.LayoutEditorEventType.TURN_ON_AUTOCONNECT : LayoutEditorEvent.LayoutEditorEventType.TURN_OFF_AUTOCONNECT);
            PropertiesComponent.getInstance().setValue(ConstraintLayoutHandler.AUTO_CONNECT_PREF_KEY, selected, false);
        }

        @Override
        public boolean affectsUndo() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ToggleAutoConnectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Enableable {
        public void enable(List<NlComponent> var1);
    }
}

