/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class AnimatedComponentSplitter
extends ThreeComponentsSplitter {
    private static final int DEFAULT_ANIMATION_DURATION = 150;
    private boolean myIsFirstShowing;
    private boolean myIsLastShowing;
    private int myFirstClosedSize = 0;
    private int myLastClosedSize = 0;
    private int myAnimationDuration = 150;

    public AnimatedComponentSplitter() {
    }

    public AnimatedComponentSplitter(boolean vertical) {
        super(vertical);
    }

    public AnimatedComponentSplitter(boolean vertical, boolean onePixelDividers) {
        super(vertical, onePixelDividers);
    }

    public boolean isFirstShowing() {
        return this.myIsFirstShowing;
    }

    public boolean isLastShowing() {
        return this.myIsLastShowing;
    }

    public void showAnimateFirst(boolean show) {
        int targetSize = show ? this.getFirstOpenSize() : this.myLastClosedSize;
        int startSize = this.getFirstSize();
        if (show && startSize > this.getFirstOpenSize() || !show && startSize < this.myFirstClosedSize) {
            return;
        }
        this.showAnimate((Consumer<Integer>)((Consumer)this::setFirstSize), targetSize, startSize);
    }

    public void showAnimateLast(boolean show) {
        int targetSize = show ? this.getLastOpenSize() : this.myLastClosedSize;
        int startSize = this.getLastSize();
        if (show && startSize > this.getLastOpenSize() || !show && startSize < this.myLastClosedSize) {
            return;
        }
        this.showAnimate((Consumer<Integer>)((Consumer)this::setLastSize), targetSize, startSize);
    }

    private void showAnimate(@NotNull Consumer<Integer> setSizeMethod, int targetSize, int startSize) {
        if (setSizeMethod == null) {
            AnimatedComponentSplitter.$$$reportNull$$$0(0);
        }
        long startTime = System.currentTimeMillis();
        Timer timer = new Timer(20, actionEvent -> {
            float t;
            if (setSizeMethod == null) {
                AnimatedComponentSplitter.$$$reportNull$$$0(2);
            }
            if ((t = (float)(System.currentTimeMillis() - startTime) / (float)this.myAnimationDuration) >= 1.0f) {
                void e;
                t = 1.0f;
                ((Timer)e.getSource()).stop();
            }
            int delta = targetSize - startSize;
            int size = Math.round((float)startSize + (float)delta * t);
            setSizeMethod.consume((Object)size);
        });
        timer.setRepeats(true);
        timer.start();
    }

    public void showAnimateChild(@NotNull JComponent child, boolean show) {
        if (child == null) {
            AnimatedComponentSplitter.$$$reportNull$$$0(1);
        }
        if (this.getFirstComponent() == child) {
            this.showAnimateFirst(show);
        } else if (this.getLastComponent() == child) {
            this.showAnimateLast(show);
        }
    }

    public void setFirstSize(int size) {
        this.myIsFirstShowing = size > 1;
        super.setFirstSize(size);
    }

    public void setLastSize(int size) {
        this.myIsLastShowing = size > 1;
        super.setLastSize(size);
    }

    protected int getFirstOpenSize() {
        return Math.round((float)this.getWidth() / 3.0f);
    }

    protected int getLastOpenSize() {
        return this.getFirstOpenSize();
    }

    public void setFirstClosedSize(int firstClosedSize) {
        this.myFirstClosedSize = firstClosedSize;
    }

    public void setLastClosedSize(int lastClosedSize) {
        this.myLastClosedSize = lastClosedSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setSizeMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/AnimatedComponentSplitter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showAnimate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showAnimateChild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showAnimate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

