/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.google.common.util.concurrent.Futures;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconPreviewFactory
implements Disposable {
    private static final Logger LOG = Logger.getInstance(IconPreviewFactory.class);
    private static final int SHADOW_SIZE = 6;
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String CONTAINER_ID = "TopLevelContainer";
    private static final String LINEAR_LAYOUT = "<LinearLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:id=\"@+id/%1$s\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:orientation=\"vertical\">\n  %2$s\n</LinearLayout>\n";
    private RenderTask myRenderTask;
    public long myRenderTimeoutSeconds = 1L;

    @Nullable
    private RenderTask getRenderTask(Configuration configuration) {
        if (this.myRenderTask == null || this.myRenderTask.getModule() != configuration.getModule()) {
            AndroidFacet facet;
            if (this.myRenderTask != null) {
                this.myRenderTask.dispose();
            }
            if ((facet = AndroidFacet.getInstance(configuration.getModule())) == null) {
                return null;
            }
            RenderService renderService = RenderService.getInstance(facet);
            RenderLogger logger = renderService.createLogger();
            this.myRenderTask = renderService.createTask(null, configuration, logger, null);
        }
        return this.myRenderTask;
    }

    @Nullable
    public BufferedImage renderDragImage(@NotNull Palette.Item item, @NotNull SceneView sceneView) {
        XmlTag tag;
        if (item == null) {
            IconPreviewFactory.$$$reportNull$$$0(0);
        }
        if (sceneView == null) {
            IconPreviewFactory.$$$reportNull$$$0(1);
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)sceneView.getModel().getProject());
        String xml = item.getDragPreviewXml();
        if (xml.equals("")) {
            return null;
        }
        try {
            tag = elementFactory.createTagFromText((CharSequence)xml);
        }
        catch (IncorrectOperationException exception) {
            return null;
        }
        NlModel model = sceneView.getModel();
        NlComponent component2 = (NlComponent)ApplicationManager.getApplication().runWriteAction(() -> {
            if (sceneView == null) {
                IconPreviewFactory.$$$reportNull$$$0(3);
            }
            return NlModelHelperKt.createComponent(model, sceneView, tag, null, null, InsertType.CREATE_PREVIEW);
        });
        if (component2 == null) {
            return null;
        }
        xml = String.format(LINEAR_LAYOUT, CONTAINER_ID, component2.getTag().getText());
        RenderResult result = IconPreviewFactory.renderImage(this.myRenderTimeoutSeconds, this.getRenderTask(model.getConfiguration()), xml);
        if (result == null || !result.hasImage()) {
            return null;
        }
        ImagePool.Image image = result.getRenderedImage();
        List infos = result.getRootViews();
        if (infos.isEmpty()) {
            return null;
        }
        if ((infos = infos.get(0).getChildren()) == null || infos.isEmpty()) {
            return null;
        }
        ViewInfo view = (ViewInfo)infos.get(0);
        if (image.getHeight() < view.getBottom() || image.getWidth() < view.getRight() || view.getBottom() <= view.getTop() || view.getRight() <= view.getLeft()) {
            return null;
        }
        int shadowIncrement = 1 + Coordinates.getSwingDimension(sceneView, 6);
        BufferedImage imageCopy = image.getCopy();
        if (imageCopy == null) {
            return null;
        }
        try {
            return imageCopy.getSubimage(view.getLeft(), view.getTop(), Math.min(view.getRight() + shadowIncrement, image.getWidth()), Math.min(view.getBottom() + shadowIncrement, image.getHeight()));
        }
        catch (RasterFormatException rasterFormatException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static RenderResult renderImage(long renderTimeoutSeconds, @Nullable RenderTask renderTask, @NotNull String string) {
        void xml;
        if (string == null) {
            IconPreviewFactory.$$$reportNull$$$0(2);
        }
        if (renderTask == null) {
            return null;
        }
        PsiFile file = PsiFileFactory.getInstance((Project)renderTask.getModule().getProject()).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml);
        renderTask.setPsiFile(file);
        renderTask.setOverrideBgColor(UIUtil.TRANSPARENT_COLOR.getRGB());
        renderTask.setDecorations(false);
        renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
        renderTask.setFolderType(ResourceFolderType.LAYOUT);
        renderTask.inflate();
        try {
            return (RenderResult)renderTask.render().get(renderTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    public void dispose() {
        if (this.myRenderTask != null) {
            Futures.getUnchecked(this.myRenderTask.dispose());
            this.myRenderTask = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/palette/IconPreviewFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "renderDragImage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "renderImage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$renderDragImage$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

