/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlProperties {
    public static final String STARRED_PROP = "ANDROID.STARRED_PROPERTIES";
    private static NlProperties ourInstance = null;
    private final AndroidDomElementDescriptorProvider myDescriptorProvider = new AndroidDomElementDescriptorProvider();

    public static synchronized NlProperties getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlProperties();
        }
        return ourInstance;
    }

    @NotNull
    public Table<String, String, NlPropertyItem> getProperties(@NotNull NlPropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        AndroidFacet facet;
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(0);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(1);
        }
        if ((facet = NlProperties.getFacet(components)) == null) {
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                NlProperties.$$$reportNull$$$0(2);
            }
            return immutableTable;
        }
        Table<String, String, NlPropertyItem> table = this.getProperties(facet, propertiesManager, components);
        if (table == null) {
            NlProperties.$$$reportNull$$$0(3);
        }
        return table;
    }

    Table<String, String, NlPropertyItem> getProperties(@NotNull AndroidFacet facet, @NotNull NlPropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(4);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(5);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(6);
        }
        return (Table)ApplicationManager.getApplication().runReadAction(() -> {
            if (facet == null) {
                NlProperties.$$$reportNull$$$0(40);
            }
            if (propertiesManager == null) {
                NlProperties.$$$reportNull$$$0(41);
            }
            if (components == null) {
                NlProperties.$$$reportNull$$$0(42);
            }
            return this.getPropertiesWithReadLock(facet, propertiesManager, components);
        });
    }

    @NotNull
    private Table<String, String, NlPropertyItem> getPropertiesWithReadLock(@NotNull AndroidFacet facet, @NotNull NlPropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(7);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(8);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(9);
        }
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        SystemResourceManager systemResourceManager = resourceManagers.getSystemResourceManager();
        if (systemResourceManager == null) {
            Logger.getInstance(NlProperties.class).error("No system resource manager for module: " + facet.getModule().getName());
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                NlProperties.$$$reportNull$$$0(10);
            }
            return immutableTable;
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)systemResourceManager).getAttributeDefinitions();
        Table<String, String, NlPropertyItem> combinedProperties = null;
        for (NlComponent component2 : components) {
            XmlTag tag = component2.getTag();
            if (!tag.isValid()) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    NlProperties.$$$reportNull$$$0(11);
                }
                return immutableTable;
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    NlProperties.$$$reportNull$$$0(12);
                }
                return immutableTable;
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor desc : descriptors) {
                XmlName name = NlProperties.getXmlName(desc, tag);
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android".equals(name.getNamespaceKey()) ? systemAttrDefs : localAttrDefs;
                AttributeDefinition attrDef = attrDefs == null ? null : attrDefs.getAttrDefByName(name.getLocalName());
                NlPropertyItem property = NlPropertyItem.create(name, attrDef, components, propertiesManager);
                properties.put((Object)StringUtil.notNullize((String)name.getNamespaceKey()), (Object)property.getName(), (Object)property);
            }
            switch (tag.getName()) {
                case "AutoCompleteTextView": {
                    properties.put((Object)"http://schemas.android.com/apk/res/android", (Object)"popupBackground", (Object)NlPropertyItem.create(new XmlName("popupBackground", "http://schemas.android.com/apk/res/android"), systemAttrDefs != null ? systemAttrDefs.getAttrDefByName("popupBackground") : null, components, propertiesManager));
                }
            }
            combinedProperties = NlProperties.combine((Table<String, String, NlPropertyItem>)properties, combinedProperties);
        }
        assert (combinedProperties != null);
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingStart");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingEnd");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"theme");
        NlProperties.setUpDesignProperties(combinedProperties);
        NlProperties.setUpSrcCompat(combinedProperties, facet, components, propertiesManager);
        NlProperties.initStarState(combinedProperties);
        Table<String, String, NlPropertyItem> table = combinedProperties;
        if (table == null) {
            NlProperties.$$$reportNull$$$0(13);
        }
        return table;
    }

    @Nullable
    private static AndroidFacet getFacet(@NotNull List<NlComponent> components) {
        if (components == null) {
            NlProperties.$$$reportNull$$$0(14);
        }
        if (components.isEmpty()) {
            return null;
        }
        return components.get(0).getModel().getFacet();
    }

    private static void initStarState(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(15);
        }
        for (String starredProperty : NlProperties.getStarredProperties()) {
            Pair<String, String> property = NlProperties.split(starredProperty);
            NlPropertyItem item = (NlPropertyItem)properties.get(property.getFirst(), property.getSecond());
            if (item == null) continue;
            item.setInitialStarred();
        }
    }

    public static void saveStarState(@Nullable String propertyNamespace, @NotNull String propertyName, boolean starred, @NotNull NlPropertiesManager propertiesManager) {
        if (propertyName == null) {
            NlProperties.$$$reportNull$$$0(16);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(17);
        }
        String propertyNameWithPrefix = NlProperties.getPropertyNameWithPrefix(propertyNamespace, propertyName);
        ArrayList<String> favorites = new ArrayList<String>();
        for (String starredProperty : NlProperties.getStarredProperties()) {
            if (starredProperty.equals(propertyNameWithPrefix)) continue;
            favorites.add(starredProperty);
        }
        if (starred) {
            favorites.add(propertyNameWithPrefix);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(STARRED_PROP, Joiner.on((char)';').join(favorites));
        String added = starred ? propertyNameWithPrefix : "";
        String removed = !starred ? propertyNameWithPrefix : "";
        propertiesManager.logFavoritesChange(added, removed, favorites);
    }

    public static String getStarredPropertiesAsString() {
        String starredProperties = PropertiesComponent.getInstance().getValue(STARRED_PROP);
        if (starredProperties == null) {
            starredProperties = "visibility";
        }
        return starredProperties;
    }

    public static Iterable<String> getStarredProperties() {
        return Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)NlProperties.getStarredPropertiesAsString());
    }

    @NotNull
    private static String getPropertyNameWithPrefix(@Nullable String namespace, @NotNull String propertyName) {
        if (propertyName == null) {
            NlProperties.$$$reportNull$$$0(18);
        }
        if (namespace == null) {
            String string = propertyName;
            if (string == null) {
                NlProperties.$$$reportNull$$$0(19);
            }
            return string;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                String string = "tools:" + propertyName;
                if (string == null) {
                    NlProperties.$$$reportNull$$$0(20);
                }
                return string;
            }
            case "http://schemas.android.com/apk/res/android": {
                String string = propertyName;
                if (string == null) {
                    NlProperties.$$$reportNull$$$0(21);
                }
                return string;
            }
        }
        String string = "app:" + propertyName;
        if (string == null) {
            NlProperties.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> split(@NotNull String propertyNameWithPrefix) {
        if (propertyNameWithPrefix == null) {
            NlProperties.$$$reportNull$$$0(23);
        }
        if (propertyNameWithPrefix.startsWith("tools:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/tools", (Object)propertyNameWithPrefix.substring("tools:".length()));
            if (pair == null) {
                NlProperties.$$$reportNull$$$0(24);
            }
            return pair;
        }
        if (propertyNameWithPrefix.startsWith("app:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyNameWithPrefix.substring("app:".length()));
            if (pair == null) {
                NlProperties.$$$reportNull$$$0(25);
            }
            return pair;
        }
        Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)propertyNameWithPrefix);
        if (pair == null) {
            NlProperties.$$$reportNull$$$0(26);
        }
        return pair;
    }

    @NotNull
    private static XmlName getXmlName(@NotNull XmlAttributeDescriptor descriptor, @NotNull XmlTag context) {
        if (descriptor == null) {
            NlProperties.$$$reportNull$$$0(27);
        }
        if (context == null) {
            NlProperties.$$$reportNull$$$0(28);
        }
        String namespace = null;
        if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(context);
        }
        XmlName xmlName = new XmlName(descriptor.getName(), namespace);
        if (xmlName == null) {
            NlProperties.$$$reportNull$$$0(29);
        }
        return xmlName;
    }

    private static Table<String, String, NlPropertyItem> combine(@NotNull Table<String, String, NlPropertyItem> properties, @Nullable Table<String, String, NlPropertyItem> combinedProperties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(30);
        }
        if (combinedProperties == null) {
            return properties;
        }
        ArrayList namespaces = new ArrayList(combinedProperties.rowKeySet());
        ArrayList propertiesToRemove = new ArrayList();
        for (String namespace : namespaces) {
            propertiesToRemove.clear();
            for (Map.Entry entry : combinedProperties.row((Object)namespace).entrySet()) {
                NlPropertyItem other = (NlPropertyItem)properties.get((Object)namespace, entry.getKey());
                if (((NlPropertyItem)entry.getValue()).sameDefinition(other)) continue;
                propertiesToRemove.add(entry.getKey());
            }
            for (String propertyName : propertiesToRemove) {
                combinedProperties.remove((Object)namespace, (Object)propertyName);
            }
        }
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res/android", (Object)"id");
        return combinedProperties;
    }

    private static void setUpDesignProperties(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(31);
        }
        ArrayList designProperties = new ArrayList(properties.row((Object)"http://schemas.android.com/tools").keySet());
        for (String propertyName : designProperties) {
            NlPropertyItem item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (item == null) {
                item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            if (item == null) continue;
            NlPropertyItem designItem = item.getDesignTimeProperty();
            properties.put((Object)"http://schemas.android.com/tools", (Object)propertyName, (Object)designItem);
        }
    }

    private static void setUpSrcCompat(@NotNull Table<String, String, NlPropertyItem> properties, @NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull NlPropertiesManager propertiesManager) {
        NlPropertyItem srcProperty;
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(32);
        }
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(33);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(34);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(35);
        }
        if ((srcProperty = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)"src")) != null && NlProperties.shouldAddSrcCompat(facet, components)) {
            AttributeDefinition srcDefinition = srcProperty.getDefinition();
            assert (srcDefinition != null);
            AttributeDefinition srcCompatDefinition = new AttributeDefinition("srcCompat", "com.android.support:support-v4", null, srcDefinition.getFormats());
            srcCompatDefinition.getParentStyleables().addAll(srcDefinition.getParentStyleables());
            NlPropertyItem srcCompatProperty = NlPropertyItem.create(new XmlName("srcCompat", "http://schemas.android.com/apk/res-auto"), srcCompatDefinition, components, propertiesManager);
            properties.put((Object)"http://schemas.android.com/apk/res-auto", (Object)"srcCompat", (Object)srcCompatProperty);
        }
    }

    private static boolean shouldAddSrcCompat(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(36);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(37);
        }
        return !components.isEmpty() && NlProperties.allComponentsNeedSrcCompat(facet, components);
    }

    private static boolean allComponentsNeedSrcCompat(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(38);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(39);
        }
        NlModel model = components.get(0).getModel();
        ViewHandlerManager manager = ViewHandlerManager.get(facet);
        HashSet<String> knownTagNames = new HashSet<String>();
        for (NlComponent component2 : components) {
            String tagName = component2.getTagName();
            if (!knownTagNames.add(tagName)) continue;
            ViewHandler handler = manager.getHandler(component2.getTagName());
            if (!(handler instanceof ImageViewHandler)) {
                return false;
            }
            ImageViewHandler imageViewHandler = (ImageViewHandler)handler;
            if (imageViewHandler.shouldUseSrcCompat(model)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 14: 
            case 34: 
            case 37: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlProperties";
                break;
            }
            case 4: 
            case 7: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 15: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNameWithPrefix";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesWithReadLock";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameWithPrefix";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesWithReadLock";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFacet";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initStarState";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveStarState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameWithPrefix";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getXmlName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setUpDesignProperties";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setUpSrcCompat";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddSrcCompat";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "allComponentsNeedSrcCompat";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProperties$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

