/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenView
extends SceneView {
    private ScreenViewType myType;

    public ScreenView(@NotNull NlDesignSurface surface, @NotNull ScreenViewType type, @NotNull NlModel model) {
        if (surface == null) {
            ScreenView.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ScreenView.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ScreenView.$$$reportNull$$$0(2);
        }
        super(surface, model);
        this.myType = type;
    }

    @NotNull
    public ScreenViewType getScreenViewType() {
        ScreenViewType screenViewType = this.myType;
        if (screenViewType == null) {
            ScreenView.$$$reportNull$$$0(3);
        }
        return screenViewType;
    }

    public void setType(ScreenViewType type) {
        this.myType = type;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        Configuration configuration = this.getConfiguration();
        Device device = configuration.getDevice();
        State state = configuration.getDeviceState();
        if (device != null && state != null) {
            HardwareConfig config = new HardwareConfigHelper(device).setOrientation(state.getOrientation()).getConfig();
            dimension.setSize(config.getScreenWidth(), config.getScreenHeight());
        }
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            ScreenView.$$$reportNull$$$0(4);
        }
        return dimension2;
    }

    @Override
    public void updateCursor(int x, int y) {
        Rectangle resizeZone;
        if (this.getScreenViewType() == ScreenViewType.NORMAL && (resizeZone = new Rectangle(this.getX() + this.getSize().width, this.getY() + this.getSize().height, 48, 48)).contains(x, y)) {
            this.mySurface.setCursor(Cursor.getPredefinedCursor(5));
            return;
        }
        super.updateCursor(x, y);
    }

    @Override
    public LayoutlibSceneManager getSceneManager() {
        return (LayoutlibSceneManager)super.getSceneManager();
    }

    @Override
    @NotNull
    public Color getBgColor() {
        Color color = this.getScreenViewType() == ScreenViewType.BLUEPRINT ? NlConstants.BLUEPRINT_BG_COLOR : Color.WHITE;
        if (color == null) {
            ScreenView.$$$reportNull$$$0(5);
        }
        return color;
    }

    @Nullable
    public RenderResult getResult() {
        return this.getSceneManager().getRenderResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/ScreenView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenViewType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBgColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BorderPainter {
        private static final int SHADOW_SIZE = JBUI.scale((int)6);
        private static final Color COLOR_OUTSIDE = UIUtil.TRANSPARENT_COLOR;
        private static final Color COLOR_INSIDE = new JBColor(new Color(70, 70, 70, 10), new Color(10, 10, 10, 20));
        private static final Paint GRAD_LEFT = new GradientPaint(0.0f, 0.0f, COLOR_OUTSIDE, SHADOW_SIZE, 0.0f, COLOR_INSIDE);
        private static final Paint GRAD_TOP = new GradientPaint(0.0f, 0.0f, COLOR_OUTSIDE, 0.0f, SHADOW_SIZE, COLOR_INSIDE);
        private static final Paint GRAD_RIGHT = new GradientPaint(0.0f, 0.0f, COLOR_INSIDE, SHADOW_SIZE, 0.0f, COLOR_OUTSIDE);
        private static final Paint GRAD_BOTTOM = new GradientPaint(0.0f, 0.0f, COLOR_INSIDE, 0.0f, SHADOW_SIZE, COLOR_OUTSIDE);
        private static final Paint GRAD_CORNER = new RadialGradientPaint(SHADOW_SIZE, (float)SHADOW_SIZE, SHADOW_SIZE, new float[]{0.0f, 1.0f}, new Color[]{COLOR_INSIDE, COLOR_OUTSIDE});

        public static void paint(Graphics2D g2d, ScreenView screenView) {
            Dimension size = screenView.getSize();
            int x = screenView.getX();
            int y = screenView.getY();
            RenderingHints hints = g2d.getRenderingHints();
            AffineTransform tx = g2d.getTransform();
            Paint paint = g2d.getPaint();
            g2d.translate(x - SHADOW_SIZE, y);
            g2d.scale(1.0, (double)size.height / (double)SHADOW_SIZE);
            g2d.setPaint(GRAD_LEFT);
            g2d.fillRect(0, 0, SHADOW_SIZE, SHADOW_SIZE);
            g2d.translate(size.width + SHADOW_SIZE, 0);
            g2d.setPaint(GRAD_RIGHT);
            g2d.fillRect(0, 0, SHADOW_SIZE, SHADOW_SIZE);
            g2d.translate(-size.width, 0);
            g2d.scale(1.0, (double)SHADOW_SIZE / (double)size.height);
            g2d.translate(0, -SHADOW_SIZE);
            g2d.scale((double)size.width / (double)SHADOW_SIZE, 1.0);
            g2d.setPaint(GRAD_TOP);
            g2d.fillRect(0, 0, SHADOW_SIZE, SHADOW_SIZE);
            g2d.translate(0, size.height + SHADOW_SIZE);
            g2d.setPaint(GRAD_BOTTOM);
            g2d.fillRect(0, 0, SHADOW_SIZE, SHADOW_SIZE);
            g2d.setTransform(tx);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setPaint(GRAD_CORNER);
            g2d.translate(x - SHADOW_SIZE, y - SHADOW_SIZE);
            g2d.fillArc(0, 0, SHADOW_SIZE * 2, SHADOW_SIZE * 2, 90, 90);
            g2d.translate(size.width, 0);
            g2d.fillArc(0, 0, SHADOW_SIZE * 2, SHADOW_SIZE * 2, 0, 90);
            g2d.translate(0, size.height);
            g2d.fillArc(0, 0, SHADOW_SIZE * 2, SHADOW_SIZE * 2, 270, 90);
            g2d.translate(-size.width, 0);
            g2d.fillArc(0, 0, SHADOW_SIZE * 2, SHADOW_SIZE * 2, 180, 90);
            g2d.setTransform(tx);
            g2d.setRenderingHints(hints);
            g2d.setPaint(paint);
        }
    }

    public static enum ScreenViewType {
        NORMAL,
        BLUEPRINT;

    }
}

