/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    public static final Map<RenderingHints.Key, Object> HQ_RENDERING_HITS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    public static final Map<RenderingHints.Key, Object> LQ_RENDERING_HITS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_OFF, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_SPEED);
    public static final int REQUEST_SCALE_DEBOUNCE_TIME_IN_MS = 300;
    private final ScreenView myScreenView;
    @Nullable
    private ImagePool.Image myImage;
    @Nullable
    private BufferedImage myScaledDownImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private double myCachedScale;
    private final ScheduledExecutorService myScheduledExecutorService;
    private final RescaleRunnable myRescaleRunnable;
    @Nullable
    private ScheduledFuture<?> myScheduledFuture;
    private Rectangle mySizeRectangle;
    private Dimension myScreenViewSize;
    private boolean myIsRescaling;

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(0);
        }
        this(screenView, null);
    }

    ScreenViewLayer(@NotNull ScreenView screenView, @Nullable ScheduledExecutorService executor) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(1);
        }
        this.myRescaleRunnable = new RescaleRunnable();
        this.mySizeRectangle = new Rectangle();
        this.myScreenViewSize = new Dimension();
        this.myScreenView = screenView;
        this.myScheduledExecutorService = executor != null ? executor : Executors.newScheduledThreadPool(1);
        Disposer.register((Disposable)screenView.getSurface(), (Disposable)this);
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        double scale;
        if (g == null) {
            ScreenViewLayer.$$$reportNull$$$0(2);
        }
        this.myScreenViewSize = this.myScreenView.getSize(this.myScreenViewSize);
        this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.mySizeRectangle, g.getClipBounds(), this.mySizeRectangle);
        if (this.mySizeRectangle.isEmpty()) {
            return;
        }
        RenderResult renderResult = this.myScreenView.getResult();
        if (this.renderResultHasChanged(renderResult)) {
            this.myLastRenderResult = renderResult;
            this.myImage = renderResult.getRenderedImage();
            this.myCachedScale = -1.0;
        }
        if (this.myImage == null) {
            return;
        }
        Shape prevClip = null;
        Shape screenShape = this.myScreenView.getScreenShape();
        if (screenShape != null) {
            prevClip = g.getClip();
            g.clip(screenShape);
        }
        if ((scale = this.myScreenView.getScale()) != this.myCachedScale) {
            this.myCachedScale = scale;
            this.myScaledDownImage = null;
            if (this.myCachedScale < 1.0) {
                this.requestHighQualityScaledImage();
            }
        }
        this.drawImage(g);
        if (prevClip != null) {
            g.setClip(prevClip);
        }
    }

    private void drawImage(@NotNull Graphics2D g) {
        if (g == null) {
            ScreenViewLayer.$$$reportNull$$$0(3);
        }
        assert (this.myImage != null) : "RenderResult Image is null and this should not happen at this point";
        RenderingHints hints = g.getRenderingHints();
        if (this.myScaledDownImage != null && this.myCachedScale < 1.0) {
            g.setRenderingHints(HQ_RENDERING_HITS);
            UIUtil.drawImage((Graphics)g, (Image)this.myScaledDownImage, (int)this.myScreenView.getX(), (int)this.myScreenView.getY(), null);
        } else {
            g.setRenderingHints(this.myIsRescaling ? LQ_RENDERING_HITS : HQ_RENDERING_HITS);
            this.myImage.drawImageTo(g, this.myScreenView.getX(), this.myScreenView.getY(), (int)Math.round((double)this.myImage.getWidth() * this.myCachedScale), (int)Math.round((double)this.myImage.getHeight() * this.myCachedScale));
            g.setRenderingHints(hints);
        }
        g.setRenderingHints(hints);
    }

    private boolean renderResultHasChanged(@Nullable RenderResult renderResult) {
        return renderResult != null && renderResult.hasImage() && renderResult != this.myLastRenderResult;
    }

    private void requestHighQualityScaledImage() {
        this.myIsRescaling = true;
        if (this.myScheduledFuture != null && !this.myScheduledFuture.isDone()) {
            this.myScheduledFuture.cancel(false);
        }
        this.myScheduledFuture = this.myScheduledExecutorService.schedule(this.myRescaleRunnable, 300L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myScheduledExecutorService.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static BufferedImage getRetinaScaledImage(@NotNull ImagePool.Image pooledImage, double scale, boolean bl) {
        if (pooledImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(4);
        }
        if (scale > 1.01) {
            return null;
        }
        BufferedImage original = pooledImage.getCopy();
        if (original == null) {
            return null;
        }
        if (Math.abs(scale - 0.5) > 0.001) {
            void fastScaling;
            double retinaScale = 2.0 * scale;
            original = fastScaling != false ? ImageUtils.lowQualityFastScale((BufferedImage)original, (double)retinaScale, (double)retinaScale) : ImageUtils.scale((BufferedImage)original, (double)retinaScale, (double)retinaScale);
        }
        return ImageUtils.convertToRetina((BufferedImage)original);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pooledImage";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "drawImage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRetinaScaledImage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class RescaleRunnable
    implements Runnable {
        private RescaleRunnable() {
        }

        @Override
        public void run() {
            this.scaleOriginalImage();
        }

        private void scaleOriginalImage() {
            ScreenViewLayer.this.myScaledDownImage = null;
            ImagePool.Image image = ScreenViewLayer.this.myImage;
            if (image == null) {
                return;
            }
            if (UIUtil.isRetina() && ImageUtils.supportsRetina()) {
                ScreenViewLayer.this.myScaledDownImage = ScreenViewLayer.getRetinaScaledImage(image, ScreenViewLayer.this.myCachedScale, false);
            }
            if (ScreenViewLayer.this.myScaledDownImage == null) {
                BufferedImage imageCopy = image.getCopy();
                ScreenViewLayer.this.myScaledDownImage = ImageUtils.scale((BufferedImage)imageCopy, (double)ScreenViewLayer.this.myCachedScale);
            }
            ScreenViewLayer.this.myIsRescaling = false;
            UIUtil.invokeLaterIfNeeded(() -> ScreenViewLayer.this.myScreenView.getSurface().repaint());
        }
    }
}

