/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Enumeration;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParentTreeNode
extends UpdaterTreeNode {
    private final AndroidVersion myVersion;
    private final String myTitle;
    private PackageNodeModel.SelectedState myInitialState;

    public ParentTreeNode(@NotNull AndroidVersion version) {
        if (version == null) {
            ParentTreeNode.$$$reportNull$$$0(0);
        }
        this.myVersion = version;
        this.myTitle = null;
    }

    public ParentTreeNode(@NotNull String title) {
        if (title == null) {
            ParentTreeNode.$$$reportNull$$$0(1);
        }
        this.myTitle = title;
        this.myVersion = null;
    }

    @NotNull
    private PackageNodeModel.SelectedState getState(@NotNull Function<UpdaterTreeNode, PackageNodeModel.SelectedState> childStateGetter) {
        if (childStateGetter == null) {
            ParentTreeNode.$$$reportNull$$$0(2);
        }
        boolean foundInstalled = false;
        boolean foundNotInstalled = false;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            PackageNodeModel.SelectedState childState = childStateGetter.apply(child);
            if (childState != PackageNodeModel.SelectedState.INSTALLED) {
                foundNotInstalled = true;
            }
            if (childState == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            foundInstalled = true;
        }
        if (foundInstalled && foundNotInstalled) {
            PackageNodeModel.SelectedState selectedState = PackageNodeModel.SelectedState.MIXED;
            if (selectedState == null) {
                ParentTreeNode.$$$reportNull$$$0(3);
            }
            return selectedState;
        }
        if (foundInstalled) {
            PackageNodeModel.SelectedState selectedState = PackageNodeModel.SelectedState.INSTALLED;
            if (selectedState == null) {
                ParentTreeNode.$$$reportNull$$$0(4);
            }
            return selectedState;
        }
        PackageNodeModel.SelectedState selectedState = PackageNodeModel.SelectedState.NOT_INSTALLED;
        if (selectedState == null) {
            ParentTreeNode.$$$reportNull$$$0(5);
        }
        return selectedState;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getInitialState() {
        if (this.myInitialState == null) {
            this.myInitialState = this.getState(UpdaterTreeNode::getInitialState);
        }
        PackageNodeModel.SelectedState selectedState = this.myInitialState;
        if (selectedState == null) {
            ParentTreeNode.$$$reportNull$$$0(6);
        }
        return selectedState;
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.getInitialState() == PackageNodeModel.SelectedState.MIXED;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getCurrentState() {
        PackageNodeModel.SelectedState selectedState = this.getState(UpdaterTreeNode::getCurrentState);
        if (selectedState == null) {
            ParentTreeNode.$$$reportNull$$$0(7);
        }
        return selectedState;
    }

    @Override
    public int compareTo(@NotNull UpdaterTreeNode other) {
        if (other == null) {
            ParentTreeNode.$$$reportNull$$$0(8);
        }
        if (!(other instanceof ParentTreeNode)) {
            return super.compareTo(other);
        }
        if (this.myVersion == null) {
            return ((ParentTreeNode)other).myVersion == null ? 0 : -1;
        }
        if (((ParentTreeNode)other).myVersion == null) {
            return 1;
        }
        return this.myVersion.compareTo(((ParentTreeNode)other).myVersion);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ParentTreeNode)) {
            return false;
        }
        if (this.myVersion != null) {
            return this.myVersion.equals((Object)((ParentTreeNode)obj).myVersion);
        }
        return this.getStatusString().equals(((ParentTreeNode)obj).getStatusString());
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String title = this.myTitle;
        if (title == null) {
            title = SdkVersionInfo.getVersionWithCodename((AndroidVersion)this.myVersion);
        }
        renderer.getTextRenderer().append(title, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state) {
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            child.setState(state == PackageNodeModel.SelectedState.MIXED ? child.getInitialState() : state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childStateGetter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/updater/configure/ParentTreeNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/updater/configure/ParentTreeNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

