/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ListenerCollection<T> {
    private final ReentrantReadWriteLock myLock;
    private final Executor myExecutor;
    private final Set<T> myListenersSet;
    private ImmutableSet<T> myListenerSetCopy;

    private ListenerCollection(@NotNull Executor executor) {
        if (executor == null) {
            ListenerCollection.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myListenersSet = new HashSet<T>();
        this.myExecutor = executor;
    }

    @NotNull
    public static <T> ListenerCollection<T> createWithDirectExecutor() {
        ListenerCollection<T> listenerCollection = ListenerCollection.createWithExecutor(MoreExecutors.directExecutor());
        if (listenerCollection == null) {
            ListenerCollection.$$$reportNull$$$0(1);
        }
        return listenerCollection;
    }

    @NotNull
    public static <T> ListenerCollection<T> createWithExecutor(@NotNull Executor executor) {
        if (executor == null) {
            ListenerCollection.$$$reportNull$$$0(2);
        }
        ListenerCollection<T> listenerCollection = new ListenerCollection<T>(executor);
        if (listenerCollection == null) {
            ListenerCollection.$$$reportNull$$$0(3);
        }
        return listenerCollection;
    }

    public boolean add(@NotNull T listener) {
        if (listener == null) {
            ListenerCollection.$$$reportNull$$$0(4);
        }
        this.myLock.writeLock().lock();
        try {
            this.myListenerSetCopy = null;
            boolean bl = this.myListenersSet.add(listener);
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public boolean remove(@NotNull T listener) {
        if (listener == null) {
            ListenerCollection.$$$reportNull$$$0(5);
        }
        this.myLock.writeLock().lock();
        try {
            this.myListenerSetCopy = null;
            boolean bl = this.myListenersSet.remove(listener);
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.myLock.writeLock().lock();
        try {
            this.myListenerSetCopy = ImmutableSet.of();
            this.myListenersSet.clear();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> forEach(@NotNull Consumer<T> runOnListener) {
        ImmutableSet listeners;
        if (runOnListener == null) {
            ListenerCollection.$$$reportNull$$$0(6);
        }
        SettableFuture future = SettableFuture.create();
        this.myLock.readLock().lock();
        if (this.myListenerSetCopy == null) {
            this.myLock.readLock().unlock();
            this.myLock.writeLock().lock();
            try {
                this.myListenerSetCopy = ImmutableSet.copyOf(this.myListenersSet);
                this.myLock.readLock().lock();
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }
        try {
            listeners = this.myListenerSetCopy;
        }
        finally {
            this.myLock.readLock().unlock();
        }
        if (listeners.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        this.myExecutor.execute(() -> {
            if (runOnListener == null) {
                ListenerCollection.$$$reportNull$$$0(7);
            }
            listeners.forEach(runOnListener);
            future.set(null);
        });
        return future;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/util/ListenerCollection";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runOnListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/util/ListenerCollection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createWithDirectExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createWithExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWithExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEach$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

