/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.apk.ApkFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleSourceAutogenerating
extends AndroidFacetScopedService {
    private static final Key<ModuleSourceAutogenerating> KEY = Key.create((String)ModuleSourceAutogenerating.class.getName());
    private final Set<AndroidAutogeneratorMode> myDirtyModes;
    @GuardedBy(value="myAutogeneratedFiles")
    private final Map<AndroidAutogeneratorMode, Set<String>> myAutogeneratedFiles;

    @Nullable
    public static ModuleSourceAutogenerating getInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(0);
        }
        return (ModuleSourceAutogenerating)facet.getUserData(KEY);
    }

    public static void initialize(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(1);
        }
        if (facet.requiresAndroidModel()) {
            return;
        }
        if (ApkFacet.getInstance(facet.getModule()) != null) {
            return;
        }
        ModuleSourceAutogenerating autogenerating = new ModuleSourceAutogenerating(facet);
        facet.putUserData(KEY, autogenerating);
        Module module = facet.getModule();
        Project project = module.getProject();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (facet == null) {
                ModuleSourceAutogenerating.$$$reportNull$$$0(12);
            }
            if (facet.isDisposed() || module.isDisposed() || project.isDisposed()) {
                return;
            }
            AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AAPT);
            AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AIDL);
            AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.RENDERSCRIPT);
            AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.BUILDCONFIG);
        });
    }

    private ModuleSourceAutogenerating(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(2);
        }
        super(facet);
        this.myDirtyModes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
        this.myAutogeneratedFiles = new HashMap<AndroidAutogeneratorMode, Set<String>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratedFileRemoved(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(3);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> filePaths = this.myAutogeneratedFiles.get((Object)mode);
            if (filePaths != null) {
                for (String path : filePaths) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(4);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set != null) {
                set.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAutogenerated(@NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile file) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(6);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set == null) {
                set = new HashSet<String>();
                this.myAutogeneratedFiles.put(mode, set);
            }
            set.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(7);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        // MONITORENTER : map
        Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
        HashSet<String> hashSet = set != null ? new HashSet<String>(set) : Collections.emptySet();
        // MONITOREXIT : map
        if (hashSet != null) return hashSet;
        ModuleSourceAutogenerating.$$$reportNull$$$0(8);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSourceRegenerating(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(9);
        }
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            this.myDirtyModes.add(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanRegeneratingState(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(10);
        }
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            return this.myDirtyModes.remove((Object)mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRegeneratingState() {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            Collections.addAll(this.myDirtyModes, AndroidAutogeneratorMode.values());
        }
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(11);
        }
        facet.putUserData(KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/ModuleSourceAutogenerating";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/ModuleSourceAutogenerating";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutogeneratedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedFileRemoved";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearAutogeneratedFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markFileAutogenerated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAutogeneratedFiles";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSourceRegenerating";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cleanRegeneratingState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onServiceDisposal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initialize$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

