/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.avdmanager.ModuleAvds;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceRepositories;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.TemplateManager;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.ClassMaps;
import org.jetbrains.android.compiler.ModuleSourceAutogenerating;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.AndroidResourceFilesListener;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.LegacySourceProvider;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacet
extends Facet<AndroidFacetConfiguration> {
    public static final FacetTypeId<AndroidFacet> ID = new FacetTypeId("android");
    public static final String NAME = "Android";
    private static boolean ourDynamicTemplateMenuCreated;
    private AndroidModel myAndroidModel;
    private final ResourceFolderManager myFolderManager;
    private SourceProvider myMainSourceSet;
    private IdeaSourceProvider myMainIdeaSourceSet;

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            AndroidFacet.$$$reportNull$$$0(1);
        }
        return (AndroidFacet)modelsProvider.getModifiableFacetModel(module).getFacetByType(ID);
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull ConvertContext context) {
        if (context == null) {
            AndroidFacet.$$$reportNull$$$0(2);
        }
        return AndroidFacet.findAndroidFacet(context.getModule());
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull PsiElement element) {
        if (element == null) {
            AndroidFacet.$$$reportNull$$$0(3);
        }
        return AndroidFacet.findAndroidFacet(AndroidPsiUtils.getModuleSafely(element));
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull DomElement element) {
        if (element == null) {
            AndroidFacet.$$$reportNull$$$0(4);
        }
        return AndroidFacet.findAndroidFacet(element.getModule());
    }

    @Nullable
    private static AndroidFacet findAndroidFacet(@Nullable Module module) {
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module) {
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(5);
        }
        return !module.isDisposed() ? (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(ID) : null;
    }

    public AndroidFacet(@NotNull Module module, @NotNull String name, @NotNull AndroidFacetConfiguration configuration) {
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(6);
        }
        if (name == null) {
            AndroidFacet.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            AndroidFacet.$$$reportNull$$$0(8);
        }
        super((FacetType)AndroidFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
        this.myFolderManager = new ResourceFolderManager(this);
        configuration.setFacet(this);
    }

    public boolean requiresAndroidModel() {
        return !this.getProperties().ALLOW_USER_CONFIGURATION && ApkFacet.getInstance(this.getModule()) == null;
    }

    @Nullable
    public AndroidModel getAndroidModel() {
        return this.myAndroidModel;
    }

    public void setAndroidModel(@Nullable AndroidModel androidModel) {
        this.myAndroidModel = androidModel;
        DataBindingUtil.refreshDataBindingStatus(this);
    }

    public boolean isAppProject() {
        int projectType = this.getProjectType();
        return projectType == 0 || projectType == 4;
    }

    public boolean canBeDependency() {
        int projectType = this.getProjectType();
        return projectType == 1 || projectType == 5;
    }

    public boolean isLibraryProject() {
        return this.getProjectType() == 1;
    }

    public int getProjectType() {
        return this.getProperties().PROJECT_TYPE;
    }

    public void setProjectType(int type) {
        this.getProperties().PROJECT_TYPE = type;
    }

    public static boolean hasAndroid(@NotNull Project project) {
        if (project == null) {
            AndroidFacet.$$$reportNull$$$0(9);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project == null) {
                AndroidFacet.$$$reportNull$$$0(20);
            }
            return !project.isDisposed() && ProjectFacetManager.getInstance((Project)project).hasFacets(ID);
        });
    }

    @NotNull
    public SourceProvider getMainSourceProvider() {
        if (this.myAndroidModel != null) {
            SourceProvider sourceProvider = this.myAndroidModel.getDefaultSourceProvider();
            if (sourceProvider == null) {
                AndroidFacet.$$$reportNull$$$0(10);
            }
            return sourceProvider;
        }
        if (this.myMainSourceSet == null) {
            this.myMainSourceSet = new LegacySourceProvider(this);
        }
        SourceProvider sourceProvider = this.myMainSourceSet;
        if (sourceProvider == null) {
            AndroidFacet.$$$reportNull$$$0(11);
        }
        return sourceProvider;
    }

    @NotNull
    public IdeaSourceProvider getMainIdeaSourceProvider() {
        if (!this.requiresAndroidModel()) {
            if (this.myMainIdeaSourceSet == null) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(this);
            }
        } else {
            SourceProvider mainSourceSet = this.getMainSourceProvider();
            if (this.myMainIdeaSourceSet == null || mainSourceSet != this.myMainSourceSet) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(mainSourceSet);
            }
        }
        IdeaSourceProvider ideaSourceProvider = this.myMainIdeaSourceSet;
        if (ideaSourceProvider == null) {
            AndroidFacet.$$$reportNull$$$0(12);
        }
        return ideaSourceProvider;
    }

    @NotNull
    public ResourceFolderManager getResourceFolderManager() {
        ResourceFolderManager resourceFolderManager = this.myFolderManager;
        if (resourceFolderManager == null) {
            AndroidFacet.$$$reportNull$$$0(13);
        }
        return resourceFolderManager;
    }

    @NotNull
    public List<VirtualFile> getAllResourceDirectories() {
        List<VirtualFile> list = this.myFolderManager.getFolders();
        if (list == null) {
            AndroidFacet.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Deprecated
    @Nullable
    public VirtualFile getPrimaryResourceDir() {
        List<VirtualFile> dirs = this.getAllResourceDirectories();
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        return null;
    }

    void androidPlatformChanged() {
        ModuleAvds.disposeInstance(this);
        ModuleResourceManagers.getInstance(this).clear();
        ClassMaps.getInstance(this).clear();
    }

    private static void createDynamicTemplateMenu() {
        if (ourDynamicTemplateMenuCreated) {
            return;
        }
        ourDynamicTemplateMenuCreated = true;
        DefaultActionGroup newGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("NewGroup");
        newGroup.addSeparator();
        ActionGroup menu = TemplateManager.getInstance().getTemplateCreationMenu(null);
        if (menu != null) {
            newGroup.add((AnAction)menu, new Constraints(Anchor.AFTER, "NewFromTemplate"));
        }
    }

    public void initFacet() {
        ResourceRepositories.getOrCreateInstance(this);
        StartupManager.getInstance((Project)this.getProject()).runWhenProjectIsInitialized(() -> {
            AndroidResourceFilesListener.notifyFacetInitialized(this);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.addResourceFolderToSdkRootsIfNecessary();
            ModuleSourceAutogenerating.initialize(this);
        });
        this.getModule().getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private Sdk myPrevSdk;

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (AndroidFacet.this.isDisposed()) {
                        return;
                    }
                    ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)AndroidFacet.this.getModule());
                    Sdk newSdk = rootManager.getSdk();
                    if (newSdk != null && newSdk.getSdkType() instanceof AndroidSdkType && !newSdk.equals(this.myPrevSdk)) {
                        AndroidFacet.this.androidPlatformChanged();
                        ModuleSourceAutogenerating autogenerating = ModuleSourceAutogenerating.getInstance(AndroidFacet.this);
                        if (autogenerating != null) {
                            autogenerating.resetRegeneratingState();
                        }
                    } else {
                        ClassMaps.getInstance(AndroidFacet.this).clear();
                    }
                    this.myPrevSdk = newSdk;
                    ModuleResourceManagers.getInstance(AndroidFacet.this).getLocalResourceManager().invalidateAttributeDefinitions();
                });
            }
        });
        AndroidFacet.createDynamicTemplateMenu();
    }

    private void addResourceFolderToSdkRootsIfNecessary() {
        Module module = this.getModule();
        if (module.isDisposed()) {
            return;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null || !AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform == null) {
            return;
        }
        String resFolderPath = platform.getTarget().getPath(11);
        if (resFolderPath == null) {
            return;
        }
        ArrayList<VirtualFile> filesToAdd = new ArrayList<VirtualFile>();
        VirtualFile resFolder = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)resFolderPath));
        if (resFolder != null) {
            filesToAdd.add(resFolder);
        }
        if (platform.needToAddAnnotationsJarToClasspath()) {
            String sdkHomePath = FileUtil.toSystemIndependentName((String)platform.getSdkData().getLocation().getPath());
            VirtualFile annotationsJar = JarFileSystem.getInstance().findFileByPath(sdkHomePath + "/tools/support/annotations.jar" + "!/");
            if (annotationsJar != null) {
                filesToAdd.add(annotationsJar);
            }
        }
        AndroidFacet.addFilesToSdkIfNecessary(sdk, filesToAdd);
    }

    private static void addFilesToSdkIfNecessary(@NotNull Sdk sdk, @NotNull Collection<VirtualFile> files) {
        if (sdk == null) {
            AndroidFacet.$$$reportNull$$$0(15);
        }
        if (files == null) {
            AndroidFacet.$$$reportNull$$$0(16);
        }
        ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>(files);
        newFiles.removeAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
        if (!newFiles.isEmpty()) {
            SdkModificator modificator = sdk.getSdkModificator();
            for (VirtualFile file : newFiles) {
                modificator.addRoot(file, OrderRootType.CLASSES);
            }
            modificator.commitChanges();
        }
    }

    public void disposeFacet() {
        this.myAndroidModel = null;
    }

    @Nullable
    public Manifest getManifest() {
        VirtualFile manifestFile = this.getMainIdeaSourceProvider().getManifestFile();
        return manifestFile != null ? AndroidUtils.loadDomElement(this.getModule(), manifestFile, Manifest.class) : null;
    }

    @NotNull
    public static AndroidFacetType getFacetType() {
        AndroidFacetType androidFacetType = (AndroidFacetType)FacetTypeRegistry.getInstance().findFacetType(ID);
        if (androidFacetType == null) {
            AndroidFacet.$$$reportNull$$$0(17);
        }
        return androidFacetType;
    }

    public void refreshResources() {
        ResourceRepositories.getOrCreateInstance(this).refreshResources();
        ConfigurationManager.getOrCreateInstance(this.getModule()).getResolverCache().reset();
        ResourceFolderRegistry.reset();
        FileResourceRepository.reset();
    }

    @NotNull
    public JpsAndroidModuleProperties getProperties() {
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)this.getConfiguration()).getState();
        assert (state != null);
        JpsAndroidModuleProperties jpsAndroidModuleProperties = state;
        if (jpsAndroidModuleProperties == null) {
            AndroidFacet.$$$reportNull$$$0(18);
        }
        return jpsAndroidModuleProperties;
    }

    @NotNull
    private Project getProject() {
        Project project = this.getModule().getProject();
        if (project == null) {
            AndroidFacet.$$$reportNull$$$0(19);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidFacet";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidFacet";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainSourceProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainIdeaSourceProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceFolderManager";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirectories";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasAndroid";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToSdkIfNecessary";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasAndroid$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

