/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.project.AndroidRunConfigurations;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFrameworkDetector
extends FacetBasedFrameworkDetector<AndroidFacet, AndroidFacetConfiguration> {
    private static final NotificationGroup ANDROID_MODULE_IMPORTING_NOTIFICATION = NotificationGroup.balloonGroup((String)"Android Module Importing");

    public AndroidFrameworkDetector() {
        super("android");
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        GradleProjectInfo gradleProjectInfo;
        Project project;
        if (newFiles == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(1);
        }
        if ((project = context.getProject()) != null && ((gradleProjectInfo = GradleProjectInfo.getInstance(project)).isBuildWithGradle() || gradleProjectInfo.hasTopLevelGradleBuildFile())) {
            return Collections.emptyList();
        }
        return super.detect(newFiles, context);
    }

    public void setupFacet(@NotNull AndroidFacet facet, ModifiableRootModel model) {
        if (facet == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(2);
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        VirtualFile[] contentRoots = model.getContentRoots();
        if (contentRoots.length == 1) {
            ((AndroidFacetConfiguration)facet.getConfiguration()).init(module, contentRoots[0]);
        }
        ImportDependenciesUtil.importDependencies(module, true);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (facet == null) {
                AndroidFrameworkDetector.$$$reportNull$$$0(11);
            }
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                if (facet == null) {
                    AndroidFrameworkDetector.$$$reportNull$$$0(12);
                }
                AndroidFrameworkDetector.doImportSdkAndFacetConfiguration(facet, model);
                ApplicationManager.getApplication().saveAll();
            });
        });
    }

    public static void doImportSdkAndFacetConfiguration(@NotNull AndroidFacet facet, @Nullable ModifiableRootModel model) {
        Pair<String, VirtualFile> androidProjectTypeProperty;
        Pair<String, VirtualFile> androidLibraryProperty;
        Pair<String, VirtualFile> dexDisableMergerProperty;
        Pair<String, VirtualFile> manifestMergerProperty;
        if (facet == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(3);
        }
        Module module = facet.getModule();
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(module, true);
        if (model != null && !model.isDisposed() && model.isWritable()) {
            model.setSdk(ModuleRootManager.getInstance((Module)module).getSdk());
        }
        if ((manifestMergerProperty = AndroidRootUtil.getProjectPropertyValue(module, "manifestmerger.enabled")) != null) {
            facet.getProperties().ENABLE_MANIFEST_MERGING = AndroidFrameworkDetector.getFirstAsBoolean(manifestMergerProperty);
        }
        if ((dexDisableMergerProperty = AndroidRootUtil.getProjectPropertyValue(module, "dex.disable.merger")) != null) {
            boolean bl = facet.getProperties().ENABLE_PRE_DEXING = !AndroidFrameworkDetector.getFirstAsBoolean(dexDisableMergerProperty);
        }
        if ((androidLibraryProperty = AndroidRootUtil.getProjectPropertyValue(module, "android.library")) != null && AndroidFrameworkDetector.getFirstAsBoolean(androidLibraryProperty)) {
            facet.setProjectType(1);
        }
        if ((androidProjectTypeProperty = AndroidRootUtil.getProjectPropertyValue(module, "project.type")) != null) {
            facet.setProjectType(Integer.parseInt((String)androidProjectTypeProperty.getFirst()));
        }
        if (facet.isAppProject()) {
            Manifest manifest;
            Pair<String, VirtualFile> dexForceJumboProperty = AndroidRootUtil.getProjectPropertyValue(module, "dex.force.jumbo");
            if (dexForceJumboProperty != null) {
                AndroidFrameworkDetector.showDexOptionNotification(module, "dex.force.jumbo");
            }
            if ((manifest = facet.getManifest()) != null && DefaultActivityLocator.getDefaultLauncherActivityName(module.getProject(), manifest) != null) {
                AndroidRunConfigurations.getInstance().addRunConfiguration(facet, null);
            }
        }
    }

    private static boolean getFirstAsBoolean(@NotNull Pair<String, VirtualFile> pair) {
        if (pair == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(4);
        }
        return Boolean.parseBoolean((String)pair.getFirst());
    }

    @NotNull
    public static Notification showDexOptionNotification(@NotNull Module module, @NotNull String propertyName) {
        if (module == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(5);
        }
        if (propertyName == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(6);
        }
        final Project project = module.getProject();
        Notification notification = ANDROID_MODULE_IMPORTING_NOTIFICATION.createNotification(AndroidBundle.message("android.facet.importing.title", module.getName()), "'" + propertyName + "' property is detected in " + "project.properties" + " file.<br>You may enable related option in <a href='configure'>Settings | Compiler | Android DX</a>", NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(project, AndroidBundle.message("android.dex.compiler.configurable.display.name", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/facet/AndroidFrameworkDetector$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(project);
        Notification notification2 = notification;
        if (notification2 == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(7);
        }
        return notification2;
    }

    @NotNull
    public FacetType<AndroidFacet, AndroidFacetConfiguration> getFacetType() {
        AndroidFacetType androidFacetType = AndroidFacet.getFacetType();
        if (androidFacetType == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(8);
        }
        return androidFacetType;
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(9);
        }
        return languageFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName("AndroidManifest.xml");
        if (fileContentPattern == null) {
            AndroidFrameworkDetector.$$$reportNull$$$0(10);
        }
        return fileContentPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidFrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidFrameworkDetector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "showDexOptionNotification";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitableFilePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupFacet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doImportSdkAndFacetConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAsBoolean";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showDexOptionNotification";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setupFacet$1";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

