/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AppResourceRepository;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private AttributeDefinitions myAttrDefs;
    protected final AndroidFacet myFacet;

    public LocalResourceManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            LocalResourceManager.$$$reportNull$$$0(0);
        }
        super(facet.getModule().getProject());
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    @NotNull
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        Multimap<String, VirtualFile> multimap = AppResourceRepository.getOrCreateInstance(this.myFacet).getAllResourceDirs();
        if (multimap == null) {
            LocalResourceManager.$$$reportNull$$$0(1);
        }
        return multimap;
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            LocalResourceManager.$$$reportNull$$$0(2);
        }
        for (VirtualFile resDir : this.getResourceDirs()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile dir1 : this.getResourceOverlayDirs()) {
            if (!dir.equals(dir1)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        List<VirtualFile> list = this.myFacet.getAllResourceDirectories();
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    public List<Pair<Resources, VirtualFile>> getResourceElements() {
        return this.getResourceElements(null);
    }

    @Override
    @NotNull
    public VirtualFile[] getResourceOverlayDirs() {
        VirtualFile[] virtualFileArray = AndroidRootUtil.getResourceOverlayDirs(this.getFacet());
        if (virtualFileArray == null) {
            LocalResourceManager.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @NotNull
    public List<ResourceElement> getValueResources(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            LocalResourceManager.$$$reportNull$$$0(5);
        }
        List<ResourceElement> list = this.getValueResources(resourceType, null);
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            LocalResourceManager.$$$reportNull$$$0(7);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element) {
        AndroidFacet facet;
        if (element == null) {
            LocalResourceManager.$$$reportNull$$$0(8);
        }
        return (facet = AndroidFacet.getInstance(element)) != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : null;
    }

    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        if (this.myAttrDefs == null) {
            SystemResourceManager systemResourceManager = ModuleResourceManagers.getInstance(this.myFacet).getSystemResourceManager();
            AttributeDefinitions systemAttributeDefinitions = systemResourceManager == null ? null : ((ResourceManager)systemResourceManager).getAttributeDefinitions();
            ApplicationManager.getApplication().runReadAction(() -> {
                this.myAttrDefs = new AttributeDefinitionsImpl(systemAttributeDefinitions, this.findResourceFilesByLibraryName(ResourceFolderType.VALUES, XmlFile.class));
            });
        }
        AttributeDefinitions attributeDefinitions = this.myAttrDefs;
        if (attributeDefinitions == null) {
            LocalResourceManager.$$$reportNull$$$0(9);
        }
        return attributeDefinitions;
    }

    public void invalidateAttributeDefinitions() {
        this.myAttrDefs = null;
    }

    @NotNull
    public List<Attr> findAttrs(@NotNull String name) {
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(10);
        }
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (Attr attr : res.getAttrs()) {
                if (!name.equals(attr.getName().getValue())) continue;
                list.add(attr);
            }
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                for (Attr attr : styleable.getAttrs()) {
                    if (!name.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        ArrayList<Attr> arrayList = list;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public List<DeclareStyleable> findStyleables(@NotNull String name) {
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(12);
        }
        ArrayList<DeclareStyleable> list = new ArrayList<DeclareStyleable>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!name.equals(styleable.getName().getValue())) continue;
                list.add(styleable);
            }
        }
        return list;
    }

    public List<Attr> findStyleableAttributesByFieldName(@NotNull String fieldName) {
        int prev;
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(13);
        }
        int index = fieldName.lastIndexOf(95);
        while (index != -1 && (prev = fieldName.lastIndexOf(95, index - 1)) != -1 && !Character.isUpperCase(fieldName.charAt(prev + 1))) {
            index = prev;
        }
        if (index == -1) {
            return Collections.emptyList();
        }
        String styleableName = fieldName.substring(0, index);
        String attrName = fieldName.substring(index + 1);
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!styleableName.equals(styleable.getName().getValue())) continue;
                for (Attr attr : styleable.getAttrs()) {
                    if (!attrName.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByField(@NotNull PsiField field) {
        String type;
        if (field == null) {
            LocalResourceManager.$$$reportNull$$$0(14);
        }
        if ((type = AndroidResourceUtil.getResourceClassName(field)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(15);
            }
            return list;
        }
        String fieldName = field.getName();
        if (fieldName == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<PsiElement> list = this.findResourcesByFieldName(type, fieldName);
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByFieldName(@NotNull String resClassName, @NotNull String fieldName) {
        ResourceFolderType folderType;
        if (resClassName == null) {
            LocalResourceManager.$$$reportNull$$$0(18);
        }
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(19);
        }
        ArrayList<PsiElement> targets = new ArrayList<PsiElement>();
        if (resClassName.equals(ResourceType.ID.getName())) {
            targets.addAll(this.findIdDeclarations(fieldName));
        }
        if ((folderType = ResourceFolderType.getTypeByName((String)resClassName)) != null) {
            for (PsiFile file : this.findResourceFiles(folderType, fieldName, false, new String[0])) {
                targets.add((PsiElement)file);
            }
        }
        for (ResourceElement element : this.findValueResources(resClassName, fieldName, false)) {
            targets.add((PsiElement)element.getName().getXmlAttributeValue());
        }
        if (resClassName.equals(ResourceType.ATTR.getName())) {
            for (Attr attr : this.findAttrs(fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        } else if (resClassName.equals(ResourceType.STYLEABLE.getName())) {
            for (DeclareStyleable styleable : this.findStyleables(fieldName)) {
                targets.add((PsiElement)styleable.getName().getXmlAttributeValue());
            }
            for (Attr attr : this.findStyleableAttributesByFieldName(fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        }
        ArrayList<PsiElement> arrayList = targets;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType resourceType, boolean publicOnly) {
        if (resourceType == null) {
            LocalResourceManager.$$$reportNull$$$0(21);
        }
        AppResourceRepository appResources = AppResourceRepository.getOrCreateInstance(this.myFacet);
        Collection<Object> resourceNames = resourceType == ResourceType.STYLEABLE ? appResources.getItemsOfType(ResourceType.DECLARE_STYLEABLE) : appResources.getItemsOfType(resourceType);
        if (publicOnly || resourceType == ResourceType.ATTR) {
            HashSet filtered = ContainerUtil.newHashSet((int)resourceNames.size());
            for (String name : resourceNames) {
                if (resourceType == ResourceType.ATTR && !name.startsWith("android:")) {
                    filtered.add(name);
                }
                if (!publicOnly || appResources.isPrivate(resourceType, name)) continue;
                filtered.add(name);
            }
            resourceNames = filtered;
        }
        HashSet hashSet = resourceNames;
        if (hashSet == null) {
            LocalResourceManager.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/LocalResourceManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/LocalResourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceOverlayDirs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResources";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDefinitions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttrs";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByField";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByFieldName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueResources";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAttrs";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findStyleables";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findStyleableAttributesByFieldName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByField";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByFieldName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResourceNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

