/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveTagIntentionFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;

public class JavaFxRedundantPropertyValueInspection
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance(JavaFxRedundantPropertyValueInspection.class);
    private static Reference<Map<String, Map<String, String>>> ourDefaultPropertyValues;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                super.visitXmlAttribute(attribute);
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                if (!(descriptor instanceof JavaFxPropertyAttributeDescriptor)) {
                    return;
                }
                String attributeName = attribute.getName();
                String attributeValue = attribute.getValue();
                if (attributeValue == null || attributeValue.startsWith("$") || attributeValue.startsWith("#") || attributeValue.startsWith("%") || "fx:id".equals(attributeName) || "fx:value".equals(attributeName) || "fx:constant".equals(attributeName) || "fx:controller".equals(attributeName)) {
                    return;
                }
                PsiClass tagClass = JavaFxPsiUtil.getTagClass(attribute.getParent());
                String defaultValue = JavaFxRedundantPropertyValueInspection.getDefaultValue(attributeName, tagClass);
                if (defaultValue == null) {
                    return;
                }
                if (JavaFxRedundantPropertyValueInspection.isEqualValue(tagClass, attributeValue, defaultValue, descriptor.getDeclaration())) {
                    holder.registerProblem((PsiElement)attribute, "Attribute is redundant because it contains default value", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAttributeIntentionFix(attributeName, attribute)});
                }
            }

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (!(descriptor instanceof JavaFxPropertyTagDescriptor)) {
                    return;
                }
                if (tag.getSubTags().length != 0) {
                    return;
                }
                String tagText = tag.getValue().getTrimmedText();
                if (tagText.startsWith("$") || tagText.startsWith("#") || tagText.startsWith("%")) {
                    return;
                }
                XmlTag parentTag = tag.getParentTag();
                if (parentTag == null) {
                    return;
                }
                PsiClass tagClass = JavaFxPsiUtil.getTagClass(parentTag);
                String defaultValue = JavaFxRedundantPropertyValueInspection.getDefaultValue(tag.getName(), tagClass);
                if (defaultValue == null) {
                    return;
                }
                if (JavaFxRedundantPropertyValueInspection.isEqualValue(tagClass, tagText, defaultValue, descriptor.getDeclaration())) {
                    holder.registerProblem((PsiElement)tag, "Tag is redundant because it contains default value", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveTagIntentionFix(tag.getName(), tag)});
                }
            }
        };
        if (xmlElementVisitor == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(3);
        }
        return xmlElementVisitor;
    }

    @Nullable
    private static String getDefaultValue(@NotNull String propertyName, @Nullable PsiClass containingClass) {
        String qualifiedName;
        if (propertyName == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(4);
        }
        for (PsiClass psiClass = containingClass; psiClass != null && !"java.lang.Object".equals(qualifiedName = psiClass.getQualifiedName()); psiClass = psiClass.getSuperClass()) {
            String defaultValue = JavaFxRedundantPropertyValueInspection.getDefaultPropertyValue(qualifiedName, propertyName);
            if (defaultValue == null) continue;
            return defaultValue;
        }
        return null;
    }

    private static boolean isEqualValue(@Nullable PsiClass containingClass, @NotNull String attributeValue, @NotNull String defaultValue, @Nullable PsiElement declaration) {
        if (attributeValue == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(5);
        }
        if (defaultValue == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(6);
        }
        if (!(declaration instanceof PsiMember)) {
            return false;
        }
        String boxedQName = JavaFxPsiUtil.getBoxedPropertyType(containingClass, (PsiMember)declaration);
        if (boxedQName == null) {
            return defaultValue.equals(attributeValue);
        }
        try {
            switch (boxedQName) {
                case "java.lang.Boolean": {
                    return Boolean.parseBoolean(defaultValue) == Boolean.parseBoolean(attributeValue);
                }
                case "java.lang.Double": {
                    return Double.compare(Double.parseDouble(defaultValue), Double.parseDouble(attributeValue)) == 0;
                }
                case "java.lang.Float": {
                    return Float.compare(Float.parseFloat(defaultValue), Float.parseFloat(attributeValue)) == 0;
                }
                case "java.lang.Integer": {
                    return Integer.parseInt(defaultValue) == Integer.parseInt(attributeValue);
                }
                case "java.lang.Long": {
                    return Long.parseLong(defaultValue) == Long.parseLong(attributeValue);
                }
                case "java.lang.Short": {
                    return Short.parseShort(defaultValue) == Short.parseShort(attributeValue);
                }
                case "java.lang.Byte": {
                    return Byte.parseByte(defaultValue) == Byte.parseByte(attributeValue);
                }
            }
            return defaultValue.equals(attributeValue);
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    @Nullable
    private static String getDefaultPropertyValue(String classQualifiedName, String propertyName) {
        Map<String, String> values = JavaFxRedundantPropertyValueInspection.getDefaultPropertyValues(classQualifiedName);
        return values != null ? values.get(propertyName) : null;
    }

    @Nullable
    private static Map<String, String> getDefaultPropertyValues(String classQualifiedName) {
        Map<String, Map<String, String>> values = (Map<String, Map<String, String>>)SoftReference.dereference(ourDefaultPropertyValues);
        if (values == null) {
            values = JavaFxRedundantPropertyValueInspection.loadDefaultPropertyValues(JavaFxRedundantPropertyValueInspection.class.getSimpleName() + "8.txt");
            ourDefaultPropertyValues = new SoftReference(values);
        }
        return (Map)values.get(classQualifiedName);
    }

    @NotNull
    private static Map<String, Map<String, String>> loadDefaultPropertyValues(@NotNull String resourceName) {
        URL resource;
        if (resourceName == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(7);
        }
        if ((resource = JavaFxRedundantPropertyValueInspection.class.getResource(resourceName)) == null) {
            LOG.warn("Resource not found: " + resourceName);
            Map<String, Map<String, String>> map = Collections.emptyMap();
            if (map == null) {
                JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(8);
            }
            return map;
        }
        THashMap result = new THashMap(200);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), CharsetToolkit.UTF8_CHARSET));){
            for (String line : FileUtil.loadLines((BufferedReader)reader)) {
                if (line.isEmpty() || line.startsWith("--")) continue;
                boolean lineParsed = false;
                int p1 = line.indexOf(35);
                if (p1 > 0 && p1 < line.length()) {
                    String className = line.substring(0, p1);
                    int p2 = line.indexOf(61, p1);
                    if (p2 > p1 && p2 < line.length()) {
                        String propertyName = line.substring(p1 + 1, p2);
                        String valueText = line.substring(p2 + 1);
                        lineParsed = true;
                        Map properties = result.computeIfAbsent(className, ignored -> new THashMap());
                        if (properties.put(propertyName, valueText) != null) {
                            LOG.warn("Duplicate default property value " + line);
                        }
                    }
                }
                if (lineParsed) continue;
                LOG.warn("Can't parse default property value " + line);
            }
        }
        catch (IOException e) {
            LOG.warn("Can't read resource: " + resourceName, (Throwable)e);
            Map<String, Map<String, String>> map = Collections.emptyMap();
            if (map == null) {
                JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(9);
            }
            return map;
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(10);
        }
        return tHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxRedundantPropertyValueInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxRedundantPropertyValueInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultPropertyValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEqualValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadDefaultPropertyValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

