/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.DescriptorBasedFunctionHandle;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001aH\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\b0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0002\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\t0\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a8\u0006\u0010"}, d2={"findImplementationFromInterface", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "findInterfaceImplementation", "firstSuperMethodFromKotlin", "implementation", "generateBridgesForFunctionDescriptor", "", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "signature", "Lkotlin/Function1;", "isBodyOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "backend-common"})
public final class ImplKt {
    @NotNull
    public static final <Signature> Set<Bridge<Signature>> generateBridgesForFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull Function1<? super FunctionDescriptor, ? extends Signature> signature, @NotNull Function1<? super DeclarationDescriptor, Boolean> isBodyOwner) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull(isBodyOwner, (String)"isBodyOwner");
        return BridgesKt.generateBridges((FunctionHandle)new DescriptorBasedFunctionHandle(descriptor2, isBodyOwner), (Function1)new Function1<DescriptorBasedFunctionHandle, Signature>(signature){
            final /* synthetic */ Function1 $signature;

            public final Signature invoke(@NotNull DescriptorBasedFunctionHandle it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Signature)this.$signature.invoke((Object)it.getDescriptor());
            }
            {
                this.$signature = function1;
                super(1);
            }
        });
    }

    @Nullable
    public static final CallableMemberDescriptor findInterfaceImplementation(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        CallableMemberDescriptor.Kind kind2 = descriptor2.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kind2), (String)"descriptor.kind");
        if (kind2.isReal()) {
            return null;
        }
        if (CallResolverUtilKt.isOrOverridesSynthesized(descriptor2)) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = ImplKt.findImplementationFromInterface(descriptor2);
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor implementation = callableMemberDescriptor;
        CallableMemberDescriptor callableMemberDescriptor2 = ImplKt.firstSuperMethodFromKotlin(descriptor2, implementation);
        if (callableMemberDescriptor2 == null) {
            return null;
        }
        CallableMemberDescriptor immediateConcreteSuper = callableMemberDescriptor2;
        if (!DescriptorUtils.isInterface(immediateConcreteSuper.getContainingDeclaration())) {
            return null;
        }
        return immediateConcreteSuper;
    }

    @Nullable
    public static final CallableMemberDescriptor findImplementationFromInterface(@NotNull CallableMemberDescriptor descriptor2) {
        Object v2;
        block3: {
            Set<CallableMemberDescriptor> filtered;
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Set<CallableMemberDescriptor> overridden = OverridingUtil.getOverriddenDeclarations(descriptor2);
            Set<CallableMemberDescriptor> set2 = filtered = OverridingUtil.filterOutOverridden(overridden);
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"filtered");
            Iterable $receiver$iv = set2;
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor it;
                CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"it");
                if (!(callableMemberDescriptor.getModality() != Modality.ABSTRACT)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = v2;
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor result2 = callableMemberDescriptor;
        if (DescriptorUtils.isClassOrEnumClass(result2.getContainingDeclaration())) {
            return null;
        }
        return result2;
    }

    @Nullable
    public static final CallableMemberDescriptor firstSuperMethodFromKotlin(@NotNull CallableMemberDescriptor descriptor2, @NotNull CallableMemberDescriptor implementation) {
        Object v2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)implementation, (String)"implementation");
            Collection<? extends CallableMemberDescriptor> collection = descriptor2.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"descriptor.overriddenDescriptors");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor overridden;
                CallableMemberDescriptor callableMemberDescriptor = overridden = (CallableMemberDescriptor)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"overridden");
                if (!(callableMemberDescriptor.getModality() != Modality.ABSTRACT && (Intrinsics.areEqual((Object)overridden, (Object)implementation) || OverridingUtil.overrides((CallableDescriptor)overridden, (CallableDescriptor)implementation)))) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }
}

