/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluationBuilder;", "Lcom/intellij/debugger/engine/evaluation/expression/EvaluatorBuilder;", "()V", "build", "Lcom/intellij/debugger/engine/evaluation/expression/ExpressionEvaluator;", "codeFragment", "Lcom/intellij/psi/PsiElement;", "position", "Lcom/intellij/debugger/SourcePosition;", "idea-jvm"})
public final class KotlinEvaluationBuilder
implements EvaluatorBuilder {
    public static final KotlinEvaluationBuilder INSTANCE;

    @NotNull
    public ExpressionEvaluator build(@NotNull PsiElement codeFragment, @Nullable SourcePosition position2) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        if (!(codeFragment instanceof KtCodeFragment) || position2 == null) {
            EvaluatorBuilder evaluatorBuilder = EvaluatorBuilderImpl.getInstance();
            if (evaluatorBuilder == null) {
                Intrinsics.throwNpe();
            }
            ExpressionEvaluator expressionEvaluator = evaluatorBuilder.build(codeFragment, position2);
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionEvaluator, (String)"EvaluatorBuilderImpl.get\u2026d(codeFragment, position)");
            return expressionEvaluator;
        }
        if (position2.getLine() < 0) {
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)("Couldn't evaluate kotlin expression at " + position2));
            Intrinsics.checkExpressionValueIsNotNull((Object)evaluateException, (String)"EvaluateExceptionUtil.cr\u2026expression at $position\")");
            throw (Throwable)evaluateException;
        }
        PsiFile file2 = position2.getFile();
        if (file2 instanceof KtFile && ((document = PsiDocumentManager.getInstance((Project)((KtFile)file2).getProject()).getDocument(file2)) == null || document.getLineCount() < position2.getLine())) {
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)"Couldn't evaluate kotlin expression: breakpoint is placed outside the file. It may happen when you've changed source file after starting a debug process.");
            Intrinsics.checkExpressionValueIsNotNull((Object)evaluateException, (String)"EvaluateExceptionUtil.cr\u2026arting a debug process.\")");
            throw (Throwable)evaluateException;
        }
        if (!(((KtCodeFragment)codeFragment).getContext() instanceof KtElement)) {
            Attachment[] attachments2 = new Attachment[]{AttachmentUtilsKt.attachmentByPsiFile(position2.getFile()), AttachmentUtilsKt.attachmentByPsiFile((PsiFile)codeFragment), new Attachment("breakpoint.info", "line: " + position2.getLine())};
            PsiElement psiElement2 = ((KtCodeFragment)codeFragment).getContext();
            KotlinEvaluationBuilderKt.getLOG().error("Trying to evaluate " + codeFragment.getClass() + " with context " + (psiElement2 != null ? psiElement2.getClass() : null), new Attachment[]{AttachmentUtilsKt.mergeAttachments(Arrays.copyOf(attachments2, attachments2.length))});
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)"Couldn't evaluate kotlin expression in this context");
            Intrinsics.checkExpressionValueIsNotNull((Object)evaluateException, (String)"EvaluateExceptionUtil.cr\u2026ression in this context\")");
            throw (Throwable)evaluateException;
        }
        return (ExpressionEvaluator)new ExpressionEvaluatorImpl((Evaluator)new KotlinEvaluator((KtCodeFragment)codeFragment, position2));
    }

    private KotlinEvaluationBuilder() {
    }

    static {
        KotlinEvaluationBuilder kotlinEvaluationBuilder;
        INSTANCE = kotlinEvaluationBuilder = new KotlinEvaluationBuilder();
    }
}

