/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.PathUtil;

public class JavaRuntimeDetectionUtil {
    public static String getJavaRuntimeVersion(@NotNull Library library2) {
        return JavaRuntimeDetectionUtil.getJavaRuntimeVersion(Arrays.asList(library2.getFiles(OrderRootType.CLASSES)));
    }

    public static String getJavaRuntimeVersion(@NotNull List<VirtualFile> classesRoots) {
        VirtualFile stdJar = JavaRuntimeDetectionUtil.getRuntimeJar(classesRoots);
        if (stdJar != null) {
            return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)stdJar), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        }
        return null;
    }

    @Nullable
    public static VirtualFile getRuntimeJar(@NotNull List<VirtualFile> classesRoots) {
        for (VirtualFile root : classesRoots) {
            if (!PathUtil.KOTLIN_RUNTIME_JAR_PATTERN.matcher(root.getName()).matches()) continue;
            return root;
        }
        return null;
    }
}

