/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.branchedTransformations;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedTransformationUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/branchedTransformations/IntroduceWhenSubjectInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionTarget", "inspectionText", "isApplicable", "", "idea"})
public final class IntroduceWhenSubjectInspection
extends AbstractApplicabilityBasedInspection<KtWhenExpression> {
    @NotNull
    private final String defaultFixText = "Introduce 'when' subject";

    @Override
    public boolean isApplicable(@NotNull KtWhenExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return BranchedTransformationUtilsKt.getSubjectToIntroduce(element3) != null;
    }

    @Override
    @NotNull
    public PsiElement inspectionTarget(@NotNull KtWhenExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3.getWhenKeyword();
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtWhenExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return "'when' with subject should be used";
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtWhenExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = BranchedTransformationUtilsKt.getSubjectToIntroduce(element3);
        if (ktExpression == null) {
            return "";
        }
        KtExpression subject = ktExpression;
        return "Introduce '" + subject.getText() + "' as subject of 'when'";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        block0: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            PsiElement psiElement2 = element3;
            boolean strict$iv = true;
            KtWhenExpression ktWhenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtWhenExpression.class, (boolean)strict$iv);
            if (ktWhenExpression == null) break block0;
            BranchedTransformationUtilsKt.introduceSubject(ktWhenExpression);
        }
    }

    public IntroduceWhenSubjectInspection() {
        super(KtWhenExpression.class);
    }
}

