/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.inspections.gradle.DeprecatedGradleDependencyInspectionKt;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspection;
import org.jetbrains.kotlin.idea.inspections.gradle.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.versions.DeprecatedLibInfo;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DeprecatedGradleDependencyInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "DependencyFinder", "idea-gradle"})
public final class DeprecatedGradleDependencyInspection
extends GradleBaseInspection {
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new DependencyFinder();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DeprecatedGradleDependencyInspection$DependencyFinder;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleInspectionVisitor;", "()V", "libraryVersionFromOrderEntry", "", "file", "Lcom/intellij/psi/PsiFile;", "libraryId", "reportOnElement", "Lcom/intellij/psi/PsiElement;", "classpathEntry", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "deprecatedInfo", "Lorg/jetbrains/kotlin/idea/versions/DeprecatedLibInfo;", "visitClosure", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "visitDependencyEntry", "dependencyStatement", "idea-gradle"})
    private static class DependencyFinder
    extends KotlinGradleInspectionVisitor {
        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $receiver$iv = (PsiElement)closure;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            GrExpression grExpression = dependenciesCall.getInvokedExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"dependenciesCall.invokedExpression");
            if (Intrinsics.areEqual((Object)grExpression.getText(), (Object)"dependencies") ^ true) {
                return;
            }
            List<GrCallExpression> dependencyEntries = GradleHeuristicHelper.INSTANCE.findStatementWithPrefix(closure, "compile");
            for (GrCallExpression dependencyStatement : dependencyEntries) {
                this.visitDependencyEntry(dependencyStatement);
            }
        }

        public void visitDependencyEntry(@NotNull GrCallExpression dependencyStatement) {
            Intrinsics.checkParameterIsNotNull((Object)dependencyStatement, (String)"dependencyStatement");
            for (DeprecatedLibInfo outdatedInfo : KotlinRuntimeLibraryUtilKt.getDEPRECATED_LIBRARIES_INFORMATION()) {
                String libVersion;
                String dependencyText = dependencyStatement.getText();
                String libMarker = DeprecatedGradleDependencyInspectionKt.access$getGradleMarker$p(outdatedInfo.getOld());
                String string = dependencyText;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependencyText");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)libMarker, (boolean)false, (int)2, null)) continue;
                PsiFile psiFile = dependencyStatement.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"dependencyStatement.containingFile");
                String string2 = DifferentStdlibGradleVersionInspection.Companion.getResolvedKotlinStdlibVersion(psiFile, CollectionsKt.listOf((Object)outdatedInfo.getOld().getName()));
                if (string2 == null) {
                    PsiFile psiFile2 = dependencyStatement.getContainingFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"dependencyStatement.containingFile");
                    string2 = this.libraryVersionFromOrderEntry(psiFile2, outdatedInfo.getOld().getName());
                }
                if ((libVersion = string2) == null || VersionComparatorUtil.COMPARATOR.compare(libVersion, outdatedInfo.getOutdatedAfterVersion()) < 0) continue;
                PsiElement reportOnElement = this.reportOnElement(dependencyStatement, outdatedInfo);
                this.registerError(reportOnElement, outdatedInfo.getMessage(), new ReplaceStringInDocumentFix[]{new ReplaceStringInDocumentFix(reportOnElement, outdatedInfo.getOld().getName(), outdatedInfo.getNew().getName())}, ProblemHighlightType.LIKE_DEPRECATED);
                break;
            }
        }

        private final PsiElement reportOnElement(GrCallExpression classpathEntry, DeprecatedLibInfo deprecatedInfo) {
            String string = classpathEntry.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classpathEntry.text");
            int indexOf = StringsKt.indexOf$default((CharSequence)string, (String)deprecatedInfo.getOld().getName(), (int)0, (boolean)false, (int)6, null);
            if (indexOf < 0) {
                return (PsiElement)classpathEntry;
            }
            PsiElement psiElement2 = classpathEntry.findElementAt(indexOf);
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)classpathEntry;
            }
            return psiElement2;
        }

        /*
         * WARNING - void declaration
         */
        private final String libraryVersionFromOrderEntry(PsiFile file2, String libraryId) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)file2.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(file.project)");
            Module module = projectRootManager.getFileIndex().getModuleForFile(file2.getVirtualFile());
            if (module == null) {
                return null;
            }
            Module module2 = module;
            String libMarker = ':' + libraryId + ':';
            Module module3 = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
            for (Module moduleInGroup : ModuleSourceRootMapKt.allModules(ModuleSourceRootMapKt.getWholeModuleGroup(module3))) {
                void libVersion;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                ModuleRootManager.getInstance((Module)moduleInGroup).orderEntries().forEachLibrary((Processor)new Processor<Library>(libMarker, (Ref.ObjectRef)libVersion){
                    final /* synthetic */ String $libMarker;
                    final /* synthetic */ Ref.ObjectRef $libVersion;

                    public final boolean process(Library library2) {
                        Library library3 = library2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
                        String string = library3.getName();
                        if (string != null) {
                            if (StringsKt.contains$default((CharSequence)string, (CharSequence)this.$libMarker, (boolean)false, (int)2, null)) {
                                String string2 = library2.getName();
                                this.$libVersion.element = string2 != null ? StringsKt.substringAfterLast$default((String)string2, (String)":", null, (int)2, null) : null;
                            }
                        }
                        return (String)this.$libVersion.element == null;
                    }
                    {
                        this.$libMarker = string;
                        this.$libVersion = objectRef;
                    }
                });
                if ((String)libVersion.element == null) continue;
                return (String)libVersion.element;
            }
            return null;
        }
    }
}

