/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0010*\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveBracesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "allowCaretInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleComments", "construct", "Lorg/jetbrains/kotlin/psi/KtExpression;", "block", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isApplicableTo", "caretOffset", "", "findChildBlock", "idea"})
public final class RemoveBracesIntention
extends SelfTargetingIntention<KtElement> {
    private final KtBlockExpression findChildBlock(@NotNull KtElement $receiver) {
        KtBlockExpression ktBlockExpression;
        KtElement ktElement = $receiver;
        if (ktElement instanceof KtBlockExpression) {
            ktBlockExpression = (KtBlockExpression)$receiver;
        } else if (ktElement instanceof KtLoopExpression) {
            KtExpression ktExpression = ((KtLoopExpression)$receiver).getBody();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            ktBlockExpression = (KtBlockExpression)ktExpression;
        } else if (ktElement instanceof KtWhenEntry) {
            KtExpression ktExpression = ((KtWhenEntry)$receiver).getExpression();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            ktBlockExpression = (KtBlockExpression)ktExpression;
        } else {
            ktBlockExpression = null;
        }
        return ktBlockExpression;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element3, int caretOffset) {
        PsiElement container2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element3);
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression block = ktBlockExpression;
        List<KtExpression> list2 = block.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"block.statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull(list2);
        if (ktExpression == null) {
            return false;
        }
        KtExpression singleStatement = ktExpression;
        PsiElement psiElement2 = container2 = block.getParent();
        if (psiElement2 instanceof KtContainerNode) {
            if (singleStatement instanceof KtIfExpression && ((KtContainerNode)container2).getParent() instanceof KtIfExpression) {
                return false;
            }
            String string = UtilsKt.description((KtContainerNode)container2);
            if (string == null) {
                return false;
            }
            String description2 = string;
            this.setText("Remove braces from '" + description2 + "' statement");
            return true;
        }
        if (psiElement2 instanceof KtWhenEntry) {
            this.setText("Remove braces from 'when' entry");
            return !(singleStatement instanceof KtNamedDeclaration);
        }
        return false;
    }

    @Override
    public void applyTo(@NotNull KtElement element3, @Nullable Editor editor) {
        PsiElement container2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element3);
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression block = ktBlockExpression;
        List<KtExpression> list2 = block.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"block.statements");
        KtExpression statement2 = (KtExpression)CollectionsKt.single(list2);
        PsiElement psiElement2 = container2 = block.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"container");
        PsiElement psiElement3 = psiElement2.getParent();
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression construct = (KtExpression)psiElement3;
        this.handleComments(construct, block);
        PsiElement psiElement4 = statement2.copy();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"statement.copy()");
        PsiElement newElement = block.replace(psiElement4);
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)block, false, 2, null);
        if (construct instanceof KtDoWhileExpression) {
            PsiElement psiElement5 = newElement.getParent();
            if (psiElement5 == null) {
                Intrinsics.throwNpe();
            }
            psiElement5.addAfter(factory2.createNewLine(), newElement);
        }
        if (construct instanceof KtIfExpression) {
            ASTNode aSTNode = container2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"container.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtNodeTypes.ELSE)) && ((KtIfExpression)construct).getParent() instanceof KtExpression && !(((KtIfExpression)construct).getParent() instanceof KtStatementExpression)) {
                ((KtIfExpression)construct).replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "($0)", new Object[]{construct}, false, 4, null));
            }
        }
    }

    private final void handleComments(KtExpression construct, KtBlockExpression block) {
        PsiElement sibling;
        PsiElement psiElement2 = block.getFirstChild();
        Object object = sibling = psiElement2 != null ? psiElement2.getNextSibling() : null;
        while (sibling != null) {
            if (sibling instanceof PsiComment) {
                KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)construct, false, 2, null);
                if (construct.getPrevSibling() instanceof PsiWhiteSpace) {
                    PsiElement psiElement3 = construct.getPrevSibling();
                    if (psiElement3 == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement3.replace(psiFactory.createNewLine());
                }
                PsiElement commentElement = construct.getParent().addBefore(sibling, construct.getPrevSibling());
                construct.getParent().addBefore(psiFactory.createNewLine(), commentElement);
            }
            sibling = sibling.getNextSibling();
        }
    }

    @Override
    protected boolean allowCaretInsideElement(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return !(element3 instanceof KtBlockExpression) || ((KtBlockExpression)element3).getParent() instanceof KtWhenEntry;
    }

    public RemoveBracesIntention() {
        super(KtElement.class, "Remove braces", null, 4, null);
    }
}

