/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.nodejs.mocha;

import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.nodejs.mocha.execution.MochaConfigurationType;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfigurationProducer;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.nodejs.NodeJsUtilKt;
import org.jetbrains.kotlin.idea.nodejs.TestElementInfo;
import org.jetbrains.kotlin.idea.nodejs.TestElementPath;
import org.jetbrains.kotlin.idea.nodejs.mocha.KotlinMochaRunConfigurationProducer$WhenMappings;
import org.jetbrains.kotlin.idea.run.RcUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J&\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/nodejs/mocha/KotlinMochaRunConfigurationProducer;", "Lcom/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer;", "()V", "collectMochaTestRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "createTestElementRunInfo", "Lorg/jetbrains/kotlin/idea/nodejs/TestElementInfo;", "Lcom/jetbrains/nodejs/mocha/execution/MochaRunSettings;", "Lorg/jetbrains/kotlin/idea/nodejs/mocha/MochaTestElementInfo;", "element", "Lcom/intellij/psi/PsiElement;", "originalSettings", "isActiveFor", "", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isConfigurationFromCompatibleContext", "configuration", "Lcom/jetbrains/nodejs/mocha/execution/MochaRunConfiguration;", "setupConfigurationFromCompatibleContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "ultimate"})
public final class KotlinMochaRunConfigurationProducer
extends MochaRunConfigurationProducer {
    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectMochaTestRoots(Project project) {
        void $receiver$iv$iv;
        RunManager runManager = RunManager.Companion.getInstance(project);
        MochaConfigurationType mochaConfigurationType = MochaConfigurationType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)mochaConfigurationType, (String)"MochaConfigurationType.getInstance()");
        Iterable $receiver$iv = runManager.getConfigurationsList((ConfigurationType)mochaConfigurationType);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof MochaRunConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Collection destination$iv = (Collection)new SmartList();
        Iterable $receiver$iv$iv2 = $receiver$iv;
        Iterator iterator2 = $receiver$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3;
            String string;
            MochaRunSettings settings2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            MochaRunConfiguration configuration2 = (MochaRunConfiguration)element$iv;
            MochaRunSettings mochaRunSettings = settings2 = configuration2.getRunSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)mochaRunSettings, (String)"settings");
            switch (KotlinMochaRunConfigurationProducer$WhenMappings.$EnumSwitchMapping$0[mochaRunSettings.getTestKind().ordinal()]) {
                case 1: {
                    string = settings2.getTestDirPath();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = settings2.getTestFilePath();
                    break;
                }
                default: {
                    string = null;
                }
            }
            String path = string;
            CharSequence charSequence = path;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                virtualFile3 = null;
            } else {
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                String string2 = path;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                virtualFile3 = localFileSystem.findFileByPath(string2);
            }
            if (virtualFile3 == null) continue;
            VirtualFile it$iv = virtualFile2 = virtualFile3;
            destination$iv.add(it$iv);
        }
        return (List)iterable;
    }

    private final boolean isActiveFor(PsiElement element3, ConfigurationContext context) {
        Module module = ProjectStructureUtilKt.getModule(element3);
        Module module2 = module;
        if (module2 == null || (module2 = JsUtilsKt.jsOrJsImpl(module2)) == null) {
            return false;
        }
        Module jsModule = module2;
        VirtualFile virtualFile2 = Intrinsics.areEqual((Object)jsModule, (Object)module) ^ true ? jsModule.getModuleFile() : PsiUtilCore.getVirtualFile((PsiElement)element3);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile file2 = virtualFile2;
        Project project = module.getProject();
        if (this.isTestRunnerPackageAvailableFor(project, file2)) {
            return true;
        }
        if (context.getOriginalConfiguration((ConfigurationType)MochaConfigurationType.getInstance()) instanceof MochaRunConfiguration) {
            return true;
        }
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        List<VirtualFile> roots = this.collectMochaTestRoots(project2);
        if (roots.isEmpty()) {
            return false;
        }
        SmartHashSet dirs = new SmartHashSet();
        for (VirtualFile root : roots) {
            if (root.isDirectory()) {
                dirs.add((Object)root);
                continue;
            }
            if (!Intrinsics.areEqual((Object)root, (Object)file2)) continue;
            return true;
        }
        return VfsUtilCore.isUnder((VirtualFile)file2, (Set)((Set)dirs));
    }

    /*
     * WARNING - void declaration
     */
    private final TestElementInfo<MochaRunSettings> createTestElementRunInfo(PsiElement element3, MochaRunSettings originalSettings) {
        MochaRunSettings mochaRunSettings;
        Module module = ProjectStructureUtilKt.getModule(element3);
        if (module == null || (module = JsUtilsKt.jsOrJsImpl(module)) == null) {
            return null;
        }
        Module module2 = module;
        Project project = module2.getProject();
        String string = JsUtilsKt.getJsTestOutputFilePath(module2);
        if (string == null) {
            return null;
        }
        String testFilePath = string;
        String string2 = originalSettings.getWorkingDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"originalSettings.workingDir");
        if (StringsKt.isBlank((CharSequence)string2)) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            VirtualFile virtualFile2 = project2.getBaseDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"project.baseDir");
            String workingDir = FileUtil.toSystemDependentName((String)virtualFile2.getPath());
            mochaRunSettings = originalSettings.builder().setWorkingDir(workingDir).build();
        } else {
            mochaRunSettings = originalSettings;
        }
        MochaRunSettings settings2 = mochaRunSettings;
        TestElementPath testElementPath = TestElementPath.Companion.forElement(element3, module2);
        if (testElementPath == null) {
            return null;
        }
        TestElementPath testElementPath2 = testElementPath;
        MochaRunSettings.Builder builder = settings2.builder();
        builder.setTestFilePath(testFilePath);
        MochaRunSettings mochaRunSettings2 = settings2;
        Intrinsics.checkExpressionValueIsNotNull((Object)mochaRunSettings2, (String)"settings");
        String string3 = mochaRunSettings2.getUi();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"settings.ui");
        Object object = string3;
        if (object.length() == 0) {
            builder.setUi("bdd");
        }
        if ((object = testElementPath2) instanceof TestElementPath.BySuite) {
            void suiteNames2;
            TestElementPath.BySuite bySuite = (TestElementPath.BySuite)testElementPath2;
            List<String> list2 = bySuite.component1();
            String testName = bySuite.component2();
            if (testName == null) {
                builder.setTestKind(MochaTestKind.SUITE);
                builder.setSuiteNames((List)suiteNames2);
            } else {
                builder.setTestKind(MochaTestKind.TEST);
                builder.setTestNames(CollectionsKt.plus((Collection)((Collection)suiteNames2), (Object)testName));
            }
        } else if (object instanceof TestElementPath.BySingleFile) {
            builder.setTestKind(MochaTestKind.TEST_FILE);
        }
        builder.setEnvData(NodeJsUtilKt.getNodeJsEnvironmentVars(module2));
        MochaRunSettings mochaRunSettings3 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)mochaRunSettings3, (String)"builder.build()");
        return new TestElementInfo<MochaRunSettings>(mochaRunSettings3, element3);
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration2, @NotNull ConfigurationContext context) {
        PsiElement element3;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement psiElement2 = context.getPsiLocation();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement psiElement3 = element3 = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
        MochaRunSettings mochaRunSettings = configuration2.getRunSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)mochaRunSettings, (String)"configuration.runSettings");
        TestElementInfo<MochaRunSettings> testElementInfo = this.createTestElementRunInfo(psiElement3, mochaRunSettings);
        if (testElementInfo == null) {
            return false;
        }
        TestElementInfo<MochaRunSettings> testElementInfo2 = testElementInfo;
        MochaRunSettings thisRunSettings = testElementInfo2.component1();
        MochaRunSettings thatRunSettings = configuration2.getRunSettings();
        MochaTestKind thisTestKind = thisRunSettings.getTestKind();
        MochaRunSettings mochaRunSettings2 = thatRunSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)mochaRunSettings2, (String)"thatRunSettings");
        if (thisTestKind != mochaRunSettings2.getTestKind()) {
            return false;
        }
        return thisTestKind == MochaTestKind.DIRECTORY ? Intrinsics.areEqual((Object)thisRunSettings.getTestDirPath(), (Object)thatRunSettings.getTestDirPath()) : (thisTestKind == MochaTestKind.PATTERN ? Intrinsics.areEqual((Object)thisRunSettings.getTestFilePattern(), (Object)thatRunSettings.getTestFilePattern()) : (thisTestKind == MochaTestKind.TEST_FILE ? Intrinsics.areEqual((Object)thisRunSettings.getTestFilePath(), (Object)thatRunSettings.getTestFilePath()) : (thisTestKind == MochaTestKind.SUITE ? Intrinsics.areEqual((Object)thisRunSettings.getTestFilePath(), (Object)thatRunSettings.getTestFilePath()) && Intrinsics.areEqual((Object)thisRunSettings.getSuiteNames(), (Object)thatRunSettings.getSuiteNames()) : (thisTestKind != MochaTestKind.TEST ? false : Intrinsics.areEqual((Object)thisRunSettings.getTestFilePath(), (Object)thatRunSettings.getTestFilePath()) && Intrinsics.areEqual((Object)thisRunSettings.getTestNames(), (Object)thatRunSettings.getTestNames())))));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setupConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        void runSettings;
        PsiElement element3;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        PsiElement psiElement2 = context.getPsiLocation();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement psiElement3 = element3 = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
        if (!this.isActiveFor(psiElement3, context)) {
            return false;
        }
        MochaRunSettings mochaRunSettings = configuration2.getRunSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)mochaRunSettings, (String)"configuration.runSettings");
        TestElementInfo<MochaRunSettings> testElementInfo = this.createTestElementRunInfo(element3, mochaRunSettings);
        if (testElementInfo == null) {
            return false;
        }
        TestElementInfo<MochaRunSettings> testElementInfo2 = testElementInfo;
        MochaRunSettings mochaRunSettings2 = testElementInfo2.component1();
        PsiElement enclosingTestElement = testElementInfo2.component2();
        if (runSettings.getTestKind() == MochaTestKind.DIRECTORY) {
            return false;
        }
        configuration2.setRunSettings((MochaRunSettings)runSettings);
        sourceElement.set((Object)enclosingTestElement);
        configuration2.setGeneratedName();
        RcUtilsKt.addBuildTask((RunConfiguration)configuration2);
        return true;
    }
}

