/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.ui;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ=\u0010\u000e\u001a*\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0018\u0001 \u0011*\u0014\u0012\u000e\b\u0001\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000f0\u000f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0007H\u0014J\b\u0010\u0015\u001a\u00020\u0007H\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallerChooser;", "Lcom/intellij/refactoring/changeSignature/CallerChooserBase;", "Lcom/intellij/psi/PsiElement;", "declaration", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "previousTree", "Lcom/intellij/ui/treeStructure/Tree;", "callback", "Lcom/intellij/util/Consumer;", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/ui/treeStructure/Tree;Lcom/intellij/util/Consumer;)V", "findDeepestSuperMethods", "", "Lcom/intellij/psi/PsiMethod;", "kotlin.jvm.PlatformType", "method", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiMethod;", "getEmptyCalleeText", "getEmptyCallerText", "idea"})
public final class KotlinCallerChooser
extends CallerChooserBase<PsiElement> {
    @Nullable
    protected PsiMethod[] findDeepestSuperMethods(@NotNull PsiElement method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiMethod psiMethod = (PsiMethod)CollectionsKt.singleOrNull(LightClassUtilsKt.toLightMethods(method));
        return psiMethod != null ? psiMethod.findDeepestSuperMethods() : null;
    }

    @NotNull
    protected String getEmptyCallerText() {
        return "Caller text \nwith highlighted callee call would be shown here";
    }

    @NotNull
    protected String getEmptyCalleeText() {
        return "Callee text would be shown here";
    }

    public KotlinCallerChooser(@NotNull PsiElement declaration2, @NotNull Project project, @NotNull String title, @Nullable Tree previousTree, @NotNull Consumer<Set<PsiElement>> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        super(declaration2, project, title, previousTree, "dummy.kt", callback2);
    }
}

