/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownContext;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownConflictsUtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.substitutions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.util.DescriptorUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a/\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u001aH\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002\u001a4\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001aR\u0010\u0019\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a:\u0010\u001d\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002\u001a4\u0010\u001e\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001f"}, d2={"analyzePushDownConflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "context", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownContext;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "(Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownContext;[Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/util/containers/MultiMap;", "checkConflicts", "", "conflicts", "targetClass", "membersToKeepAbstract", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "membersToPush", "Ljava/util/ArrayList;", "checkExternalUsages", "member", "targetClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "checkMemberClashing", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkSuperCalls", "checkVisibility", "idea"})
public final class PushDownConflictsUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MultiMap<PsiElement, String> analyzePushDownConflicts(@NotNull KotlinPushDownContext context, @NotNull UsageInfo[] usages2) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        Object[] objectArray = $receiver$iv = (Object[])usages2;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        int n = ((void)$receiver$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiElement psiElement2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $receiver$iv$iv$iv[i];
            UsageInfo it = (UsageInfo)element$iv$iv;
            PsiElement psiElement3 = it.getElement();
            Object object = psiElement3 != null ? LightClassUtilsKt.getUnwrapped(psiElement3) : null;
            if (object == null) continue;
            PsiElement it$iv$iv = psiElement2 = object;
            destination$iv$iv.add(it$iv$iv);
        }
        List targetClasses = (List)destination$iv$iv;
        MultiMap conflicts2 = new MultiMap();
        ArrayList<KtNamedDeclaration> membersToPush = new ArrayList<KtNamedDeclaration>();
        ArrayList membersToKeepAbstract = new ArrayList();
        for (KotlinMemberInfo info : context.getMembersToMove()) {
            KtNamedDeclaration member = (KtNamedDeclaration)info.getMember();
            if (!info.isChecked() || (member instanceof KtClassOrObject || member instanceof KtPsiClassWrapper) && info.getOverrides() != null) continue;
            Collection collection = membersToPush;
            collection.add(member);
            if (!(member instanceof KtNamedFunction) && !(member instanceof KtProperty) || !info.isToAbstract()) continue;
            DeclarationDescriptor declarationDescriptor = context.getMemberDescriptors().get(member);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
            }
            if (((CallableMemberDescriptor)declarationDescriptor).getModality() == Modality.ABSTRACT) continue;
            collection = membersToKeepAbstract;
            collection.add(member);
        }
        for (PsiElement targetClass : targetClasses) {
            PushDownConflictsUtilsKt.checkConflicts((MultiMap<PsiElement, String>)conflicts2, context, targetClass, membersToKeepAbstract, membersToPush);
        }
        return conflicts2;
    }

    private static final void checkConflicts(MultiMap<PsiElement, String> conflicts2, KotlinPushDownContext context, PsiElement targetClass, List<? extends KtNamedDeclaration> membersToKeepAbstract, ArrayList<KtNamedDeclaration> membersToPush) {
        TypeSubstitutor substitutor3;
        if (!(targetClass instanceof KtClassOrObject)) {
            conflicts2.putValue((Object)targetClass, (Object)("Non-Kotlin " + RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false) + " won't be affected by the refactoring"));
            return;
        }
        DeclarationDescriptor declarationDescriptor = ResolutionFacade.DefaultImpls.resolveToDescriptor$default(context.getResolutionFacade(), (KtDeclaration)targetClass, null, 2, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor targetClassDescriptor2 = (ClassDescriptor)declarationDescriptor;
        SimpleType simpleType2 = context.getSourceClassDescriptor().getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.sourceClassDescriptor.defaultType");
        KotlinType kotlinType = simpleType2;
        SimpleType simpleType3 = targetClassDescriptor2.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"targetClassDescriptor.defaultType");
        TypeSubstitutor typeSubstitutor2 = SubstitutionUtilsKt.getTypeSubstitutor(kotlinType, simpleType3);
        if (typeSubstitutor2 == null) {
            typeSubstitutor2 = substitutor3 = TypeSubstitutor.EMPTY;
        }
        if (!context.getSourceClass().isInterface() && targetClass instanceof KtClass && ((KtClass)targetClass).isInterface()) {
            String message2 = "" + PullUpConflictsUtilsKt.renderForConflicts(targetClassDescriptor2) + ' ' + "inherits from " + PullUpConflictsUtilsKt.renderForConflicts(context.getSourceClassDescriptor()) + ".\n" + "It won't be affected by the refactoring";
            conflicts2.putValue((Object)targetClass, (Object)StringsKt.capitalize((String)message2));
        }
        Iterator<KtNamedDeclaration> iterator2 = membersToPush.iterator();
        while (iterator2.hasNext()) {
            KtNamedDeclaration member;
            KtNamedDeclaration ktNamedDeclaration = member = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration, (String)"member");
            TypeSubstitutor typeSubstitutor3 = substitutor3;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor3, (String)"substitutor");
            PushDownConflictsUtilsKt.checkMemberClashing(conflicts2, context, ktNamedDeclaration, membersToKeepAbstract, typeSubstitutor3, (KtClassOrObject)targetClass, targetClassDescriptor2);
            PushDownConflictsUtilsKt.checkSuperCalls(conflicts2, context, member, membersToPush);
            PushDownConflictsUtilsKt.checkExternalUsages(conflicts2, member, targetClassDescriptor2, context.getResolutionFacade());
            PushDownConflictsUtilsKt.checkVisibility(conflicts2, context, member, targetClassDescriptor2);
        }
    }

    private static final void checkMemberClashing(MultiMap<PsiElement, String> conflicts2, KotlinPushDownContext context, KtNamedDeclaration member, List<? extends KtNamedDeclaration> membersToKeepAbstract, TypeSubstitutor substitutor3, KtClassOrObject targetClass, ClassDescriptor targetClassDescriptor2) {
        block11: {
            Object v4;
            block9: {
                Iterator $receiver$iv$iv;
                Iterable $receiver$iv;
                KtNamedDeclaration ktNamedDeclaration;
                block10: {
                    String message2;
                    PsiElement psiElement2;
                    ktNamedDeclaration = member;
                    if (!(ktNamedDeclaration instanceof KtNamedFunction) && !(ktNamedDeclaration instanceof KtProperty)) break block10;
                    DeclarationDescriptor declarationDescriptor = context.getMemberDescriptors().get(member);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                    }
                    CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                    Object t = memberDescriptor.substitute(substitutor3);
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                    }
                    CallableMemberDescriptor clashingDescriptor = DescriptorUtilsKt.findCallableMemberBySignature$default(targetClassDescriptor2, (CallableMemberDescriptor)t, false, 2, null);
                    Object object = clashingDescriptor;
                    if (!((object != null && (object = object.getSource()) != null ? KotlinSourceElementKt.getPsi((SourceElement)object) : (psiElement2 = null)) instanceof KtNamedDeclaration)) {
                        psiElement2 = null;
                    }
                    KtNamedDeclaration clashingDeclaration = (KtNamedDeclaration)psiElement2;
                    if (clashingDescriptor == null || clashingDeclaration == null) break block11;
                    if (memberDescriptor.getModality() != Modality.ABSTRACT && !membersToKeepAbstract.contains(member)) {
                        message2 = "" + PullUpConflictsUtilsKt.renderForConflicts(targetClassDescriptor2) + " already contains " + PullUpConflictsUtilsKt.renderForConflicts(clashingDescriptor);
                        conflicts2.putValue((Object)clashingDeclaration, (Object)CommonRefactoringUtil.capitalize((String)message2));
                    }
                    if (!clashingDeclaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                        message2 = "" + PullUpConflictsUtilsKt.renderForConflicts(clashingDescriptor) + " in " + PullUpConflictsUtilsKt.renderForConflicts(targetClassDescriptor2) + ' ' + "will override corresponding member of " + PullUpConflictsUtilsKt.renderForConflicts(context.getSourceClassDescriptor()) + ' ' + "after refactoring";
                        conflicts2.putValue((Object)clashingDeclaration, (Object)CommonRefactoringUtil.capitalize((String)message2));
                    }
                    break block11;
                }
                if (!(ktNamedDeclaration instanceof KtClassOrObject)) break block11;
                Iterable memberDescriptor = targetClass.getDeclarations();
                void clashingDescriptor = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                Iterator message3 = $receiver$iv$iv.iterator();
                while (message3.hasNext()) {
                    Object element$iv$iv = message3.next();
                    if (!(element$iv$iv instanceof KtClassOrObject)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    KtClassOrObject it = (KtClassOrObject)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)((KtClassOrObject)member).getName())) continue;
                    v4 = element$iv;
                    break block9;
                }
                v4 = null;
            }
            KtClassOrObject ktClassOrObject = v4;
            if (ktClassOrObject != null) {
                KtClassOrObject ktClassOrObject2;
                KtClassOrObject it = ktClassOrObject2 = ktClassOrObject;
                StringBuilder stringBuilder = new StringBuilder().append("").append(PullUpConflictsUtilsKt.renderForConflicts(targetClassDescriptor2)).append(' ').append("already contains nested class named ");
                String string = ((KtClassOrObject)member).getName();
                if (string == null) {
                    string = "";
                }
                String message4 = stringBuilder.append(CommonRefactoringUtil.htmlEmphasize((String)string)).toString();
                conflicts2.putValue((Object)it, (Object)StringsKt.capitalize((String)message4));
            }
        }
    }

    private static final void checkSuperCalls(MultiMap<PsiElement, String> conflicts2, KotlinPushDownContext context, KtNamedDeclaration member, ArrayList<KtNamedDeclaration> membersToPush) {
        member.accept(new KtTreeVisitorVoid(context, membersToPush, conflicts2){
            final /* synthetic */ KotlinPushDownContext $context;
            final /* synthetic */ ArrayList $membersToPush;
            final /* synthetic */ MultiMap $conflicts;

            public void visitSuperExpression(@NotNull KtSuperExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver(expression2);
                if (ktQualifiedExpression == null) {
                    return;
                }
                KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
                KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny(qualifiedExpression.getSelectorExpression());
                if (!(ktExpression instanceof KtSimpleNameExpression)) {
                    ktExpression = null;
                }
                KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression refExpr = ktSimpleNameExpression;
                for (DeclarationDescriptor descriptor2 : ReferenceUtilKt.getMainReference(refExpr).resolveToDescriptors(this.$context.getSourceClassContext())) {
                    ClassDescriptor containingClass;
                    CallableMemberDescriptor memberDescriptor;
                    DeclarationDescriptor declarationDescriptor = descriptor2;
                    if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                        declarationDescriptor = null;
                    }
                    if ((CallableMemberDescriptor)declarationDescriptor == null) {
                        continue;
                    }
                    DeclarationDescriptor declarationDescriptor2 = memberDescriptor.getContainingDeclaration();
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                        declarationDescriptor2 = null;
                    }
                    if ((ClassDescriptor)declarationDescriptor2 == null) {
                        continue;
                    }
                    if (!DescriptorUtils.isSubclass(this.$context.getSourceClassDescriptor(), containingClass)) continue;
                    Object object = DescriptorUtilsKt.findCallableMemberBySignature$default(this.$context.getSourceClassDescriptor(), memberDescriptor, false, 2, null);
                    if (object == null || (object = object.getSource()) == null || (object = KotlinSourceElementKt.getPsi((SourceElement)object)) == null) {
                        continue;
                    }
                    Object memberInSource = object;
                    if (CollectionsKt.contains((Iterable)this.$membersToPush, (Object)memberInSource)) continue;
                    this.$conflicts.putValue((Object)qualifiedExpression, (Object)("Pushed member won't be available in '" + qualifiedExpression.getText() + '\''));
                }
            }
            {
                this.$context = $captured_local_variable$0;
                this.$membersToPush = $captured_local_variable$1;
                this.$conflicts = $captured_local_variable$2;
            }
        });
    }

    public static final void checkExternalUsages(@NotNull MultiMap<PsiElement, String> conflicts2, @NotNull PsiElement member, @NotNull ClassDescriptor targetClassDescriptor2, @NotNull ResolutionFacade resolutionFacade) {
        Intrinsics.checkParameterIsNotNull(conflicts2, (String)"conflicts");
        Intrinsics.checkParameterIsNotNull((Object)member, (String)"member");
        Intrinsics.checkParameterIsNotNull((Object)targetClassDescriptor2, (String)"targetClassDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade, (String)"resolutionFacade");
        Iterator iterator2 = ReferencesSearch.search((PsiElement)member, (SearchScope)((SearchScope)member.getResolveScope()), (boolean)false).iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor receiverClassDescriptor;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            KtSimpleNameExpression calleeExpr;
            PsiReference ref;
            PsiReference psiReference = ref = (PsiReference)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"ref");
            PsiElement psiElement2 = psiReference.getElement();
            if (!(psiElement2 instanceof KtSimpleNameExpression)) {
                psiElement2 = null;
            }
            if ((KtSimpleNameExpression)psiElement2 == null) {
                continue;
            }
            if (CallUtilKt.getResolvedCall(calleeExpr, ResolutionFacade.DefaultImpls.analyze$default(resolutionFacade, calleeExpr, null, 2, null)) == null) {
                continue;
            }
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
            KtElement callElement2 = call2.getCallElement();
            ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
            if (dispatchReceiver == null || dispatchReceiver instanceof Qualifier) continue;
            ClassifierDescriptor classifierDescriptor = dispatchReceiver.getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            if (DescriptorUtils.isSubclass(receiverClassDescriptor, targetClassDescriptor2)) continue;
            StringBuilder stringBuilder = new StringBuilder().append("Pushed member won't be available in '");
            KtElement ktElement = callElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"callElement");
            conflicts2.putValue((Object)callElement2, (Object)stringBuilder.append(ktElement.getText()).append('\'').toString());
        }
    }

    private static final void checkVisibility(MultiMap<PsiElement, String> conflicts2, KotlinPushDownContext context, KtNamedDeclaration member, ClassDescriptor targetClassDescriptor2) {
        Function1<DeclarationDescriptor, Unit> reportConflictIfAny$ = new Function1<DeclarationDescriptor, Unit>(targetClassDescriptor2, context, member, conflicts2){
            final /* synthetic */ ClassDescriptor $targetClassDescriptor;
            final /* synthetic */ KotlinPushDownContext $context;
            final /* synthetic */ KtNamedDeclaration $member;
            final /* synthetic */ MultiMap $conflicts;

            public final void invoke(@NotNull DeclarationDescriptor targetDescriptor) {
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
                DeclarationDescriptor declarationDescriptor = targetDescriptor;
                if (!(declarationDescriptor instanceof DeclarationDescriptorWithSource)) {
                    declarationDescriptor = null;
                }
                if ((object = (DeclarationDescriptorWithSource)declarationDescriptor) == null || (object = object.getSource()) == null || (object = KotlinSourceElementKt.getPsi((SourceElement)object)) == null) {
                    return;
                }
                Object target = object;
                if (targetDescriptor instanceof DeclarationDescriptorWithVisibility && !Visibilities.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)targetDescriptor, this.$targetClassDescriptor)) {
                    StringBuilder stringBuilder = new StringBuilder().append("");
                    DeclarationDescriptor declarationDescriptor2 = this.$context.getMemberDescriptors().get(this.$member);
                    if (declarationDescriptor2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String message2 = stringBuilder.append(PullUpConflictsUtilsKt.renderForConflicts(declarationDescriptor2)).append(' ').append("uses ").append(PullUpConflictsUtilsKt.renderForConflicts(targetDescriptor)).append(", ").append("which is not accessible from the ").append(PullUpConflictsUtilsKt.renderForConflicts(this.$targetClassDescriptor)).toString();
                    this.$conflicts.putValue(target, (Object)StringsKt.capitalize((String)message2));
                }
            }
            {
                this.$targetClassDescriptor = classDescriptor;
                this.$context = kotlinPushDownContext;
                this.$member = ktNamedDeclaration;
                this.$conflicts = multiMap;
                super(1);
            }
        };
        member.accept(new KtTreeVisitorVoid(context, reportConflictIfAny$){
            final /* synthetic */ KotlinPushDownContext $context;
            final /* synthetic */ checkVisibility.1 $reportConflictIfAny$1;

            /*
             * WARNING - void declaration
             */
            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitReferenceExpression(expression2);
                PsiReference[] psiReferenceArray = expression2.getReferences();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"expression.references");
                Object $receiver$iv = psiReferenceArray;
                Object object = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (void element$iv$iv : $receiver$iv$iv) {
                    Collection<DeclarationDescriptor> collection;
                    PsiReference it = (PsiReference)element$iv$iv;
                    PsiReference psiReference = it;
                    if (!(psiReference instanceof KtReference)) {
                        psiReference = null;
                    }
                    if ((collection = (KtReference)psiReference) == null || (collection = collection.resolveToDescriptors(this.$context.getSourceClassContext())) == null) {
                        collection = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = collection;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    E element$iv = object.next();
                    DeclarationDescriptor p1 = (DeclarationDescriptor)element$iv;
                    this.$reportConflictIfAny$1.invoke(p1);
                }
            }
            {
                this.$context = $captured_local_variable$0;
                this.$reportConflictIfAny$1 = $captured_local_variable$1;
            }
        });
    }
}

