/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u001c\u001a\u00020\u0005J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u001f\u001a\u00020\u000eJ\u0012\u0010 \u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00150\u0004H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\tj\b\u0012\u0004\u0012\u00020\u0005`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fj\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0010\u001a*\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\r0\fj\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\r`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/ir/util/DependenciesCollector;", "", "()V", "dependencyModules", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getDependencyModules", "()Ljava/util/Collection;", "modulesForDependencyDescriptors", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "packageFragmentsForDependencyDescriptors", "Ljava/util/LinkedHashMap;", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "Lkotlin/collections/LinkedHashMap;", "topLevelDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "addTopLevelDeclaration", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "addTopLevelDescriptor", "descriptor", "collectTopLevelDescriptorsForUnboundSymbols", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getPackageFragments", "moduleDescriptor", "getTopLevelDeclaration", "getTopLevelDescriptors", "packageFragmentDescriptor", "addTopLevelDeclarations", "ir.tree"})
public final class DependenciesCollector {
    private final LinkedHashSet<ModuleDescriptor> modulesForDependencyDescriptors = new LinkedHashSet();
    private final LinkedHashMap<ModuleDescriptor, Set<PackageFragmentDescriptor>> packageFragmentsForDependencyDescriptors = new LinkedHashMap();
    private final LinkedHashMap<PackageFragmentDescriptor, Set<DeclarationDescriptor>> topLevelDescriptors = new LinkedHashMap();

    @NotNull
    public final Collection<ModuleDescriptor> getDependencyModules() {
        return this.modulesForDependencyDescriptors;
    }

    @NotNull
    public final Collection<PackageFragmentDescriptor> getPackageFragments(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Set<PackageFragmentDescriptor> set2 = this.packageFragmentsForDependencyDescriptors.get(moduleDescriptor);
        return set2 != null ? (Collection)set2 : (Collection)CollectionsKt.emptyList();
    }

    @NotNull
    public final Collection<DeclarationDescriptor> getTopLevelDescriptors(@NotNull PackageFragmentDescriptor packageFragmentDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)packageFragmentDescriptor, (String)"packageFragmentDescriptor");
        Set<DeclarationDescriptor> set2 = this.topLevelDescriptors.get(packageFragmentDescriptor);
        return set2 != null ? (Collection)set2 : (Collection)CollectionsKt.emptyList();
    }

    public final void collectTopLevelDescriptorsForUnboundSymbols(@NotNull SymbolTable symbolTable) {
        Intrinsics.checkParameterIsNotNull((Object)symbolTable, (String)"symbolTable");
        boolean bl = symbolTable.getUnboundTypeParameters().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unbound type parameters: " + symbolTable.getUnboundTypeParameters();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = symbolTable.getUnboundValueParameters().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unbound value parameters: " + symbolTable.getUnboundValueParameters();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = symbolTable.getUnboundVariables().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unbound variables: " + symbolTable.getUnboundVariables();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundClasses());
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundConstructors());
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundEnumEntries());
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundFields());
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundSimpleFunctions());
    }

    private final void addTopLevelDeclarations(@NotNull Collection<? extends IrSymbol> $receiver) {
        Iterable $receiver$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            IrSymbol it = (IrSymbol)element$iv;
            this.addTopLevelDeclaration(it);
        }
    }

    public final void addTopLevelDeclaration(@NotNull IrSymbol symbol2) {
        Intrinsics.checkParameterIsNotNull((Object)symbol2, (String)"symbol");
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        DeclarationDescriptor topLevelDeclaration = this.getTopLevelDeclaration(descriptor2);
        this.addTopLevelDescriptor(topLevelDeclaration);
    }

    private final DeclarationDescriptor getTopLevelDeclaration(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor2 = containingDeclaration;
        if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
            declarationDescriptor = descriptor2;
        } else if (declarationDescriptor2 instanceof ClassDescriptor) {
            declarationDescriptor = this.getTopLevelDeclaration(containingDeclaration);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Package or class expected: " + containingDeclaration)));
        }
        return declarationDescriptor;
    }

    private final void addTopLevelDescriptor(DeclarationDescriptor descriptor2) {
        Object object;
        Object object2;
        PackageFragmentDescriptor packageFragmentDescriptor;
        PackageFragmentDescriptor packageFragmentDescriptor2 = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class);
        if (packageFragmentDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        PackageFragmentDescriptor packageFragmentDescriptor3 = packageFragmentDescriptor = packageFragmentDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)packageFragmentDescriptor3, (String)"packageFragmentDescriptor");
        ModuleDescriptor moduleDescriptor = packageFragmentDescriptor3.getContainingDeclaration();
        this.modulesForDependencyDescriptors.add(moduleDescriptor);
        Map $receiver$iv = this.packageFragmentsForDependencyDescriptors;
        Object value$iv = $receiver$iv.get(moduleDescriptor);
        if (value$iv == null) {
            LinkedHashSet answer$iv = new LinkedHashSet();
            $receiver$iv.put(moduleDescriptor, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        ((Set)object2).add(packageFragmentDescriptor);
        $receiver$iv = this.topLevelDescriptors;
        PackageFragmentDescriptor key$iv = packageFragmentDescriptor;
        Object value$iv2 = $receiver$iv.get(key$iv);
        if (value$iv2 == null) {
            LinkedHashSet answer$iv = new LinkedHashSet();
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        ((Set)object).add(descriptor2);
    }
}

