/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.QualifierReceiverKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tower.ExpressionKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolutionOldInferenceKt;
import org.jetbrains.kotlin.resolve.calls.tower.PSIFunctionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.SimplePSIKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.SubKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiverKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001aB\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0014H\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"psiCallArgument", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCallArgument;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "getPsiCallArgument", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;)Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCallArgument;", "psiExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getPsiExpression", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;)Lorg/jetbrains/kotlin/psi/KtExpression;", "createSimplePSICallArgument", "Lorg/jetbrains/kotlin/resolve/calls/tower/SimplePSIKotlinCallArgument;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "dataFlowInfoBeforeThisArgument", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "typeInfoForArgument", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "contextForArgument", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "setResultDataFlowInfoIfRelevant", "", "resultDataFlowInfo", "frontend"})
public final class NewCallArgumentsKt {
    @NotNull
    public static final PSIKotlinCallArgument getPsiCallArgument(@NotNull KotlinCallArgument $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = $receiver instanceof PSIKotlinCallArgument;
        if (_Assertions.ENABLED && !bl) {
            String string = "Incorrect KotlinCallArgument: " + $receiver + ". Java class: " + $receiver.getClass().getCanonicalName();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (PSIKotlinCallArgument)$receiver;
    }

    @Nullable
    public static final KtExpression getPsiExpression(@NotNull KotlinCallArgument $receiver) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KotlinCallArgument kotlinCallArgument = $receiver;
        if (kotlinCallArgument instanceof ReceiverExpressionKotlinCallArgument) {
            ReceiverValue $receiver$iv = ((ReceiverExpressionKotlinCallArgument)$receiver).getReceiver().getReceiverValue();
            ReceiverValue receiverValue = $receiver$iv;
            if (!(receiverValue instanceof ExpressionReceiver)) {
                receiverValue = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
            ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        } else if (kotlinCallArgument instanceof QualifierReceiverKotlinCallArgument) {
            QualifierReceiver $receiver$iv = ((QualifierReceiverKotlinCallArgument)$receiver).getReceiver();
            QualifierReceiver qualifierReceiver = $receiver$iv;
            if (!(qualifierReceiver instanceof Qualifier)) {
                qualifierReceiver = null;
            }
            Qualifier qualifier = (Qualifier)qualifierReceiver;
            ktExpression = qualifier != null ? QualifierKt.getExpression(qualifier) : null;
        } else {
            ktExpression = NewCallArgumentsKt.getPsiCallArgument($receiver).getValueArgument().getArgumentExpression();
        }
        return ktExpression;
    }

    public static final void setResultDataFlowInfoIfRelevant(@NotNull KotlinCallArgument $receiver, @NotNull DataFlowInfo resultDataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)resultDataFlowInfo, (String)"resultDataFlowInfo");
        if ($receiver instanceof PSIFunctionKotlinCallArgument) {
            ((PSIFunctionKotlinCallArgument)$receiver).setLambdaInitialDataFlowInfo(resultDataFlowInfo);
        }
    }

    @Nullable
    public static final SimplePSIKotlinCallArgument createSimplePSICallArgument(@NotNull BasicCallResolutionContext contextForArgument, @NotNull ValueArgument valueArgument, @NotNull KotlinTypeInfo typeInfoForArgument) {
        Intrinsics.checkParameterIsNotNull((Object)contextForArgument, (String)"contextForArgument");
        Intrinsics.checkParameterIsNotNull((Object)valueArgument, (String)"valueArgument");
        Intrinsics.checkParameterIsNotNull((Object)typeInfoForArgument, (String)"typeInfoForArgument");
        BindingTrace bindingTrace = contextForArgument.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"contextForArgument.trace");
        BindingContext bindingContext2 = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"contextForArgument.trace.bindingContext");
        StatementFilter statementFilter = contextForArgument.statementFilter;
        Intrinsics.checkExpressionValueIsNotNull((Object)statementFilter, (String)"contextForArgument.statementFilter");
        DeclarationDescriptor declarationDescriptor = contextForArgument.scope.getOwnerDescriptor();
        DataFlowInfo dataFlowInfo = contextForArgument.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"contextForArgument.dataFlowInfo");
        LanguageVersionSettings languageVersionSettings = contextForArgument.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)languageVersionSettings, (String)"contextForArgument.languageVersionSettings");
        return NewCallArgumentsKt.createSimplePSICallArgument(bindingContext2, statementFilter, declarationDescriptor, valueArgument, dataFlowInfo, typeInfoForArgument, languageVersionSettings);
    }

    @Nullable
    public static final SimplePSIKotlinCallArgument createSimplePSICallArgument(@NotNull BindingContext bindingContext2, @NotNull StatementFilter statementFilter, @NotNull DeclarationDescriptor ownerDescriptor, @NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfoBeforeThisArgument, @NotNull KotlinTypeInfo typeInfoForArgument, @NotNull LanguageVersionSettings languageVersionSettings) {
        ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo;
        KotlinType kotlinType;
        CallResolutionResult onlyResolvedCall;
        CallResolutionResult callResolutionResult;
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)statementFilter, (String)"statementFilter");
        Intrinsics.checkParameterIsNotNull((Object)ownerDescriptor, (String)"ownerDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)valueArgument, (String)"valueArgument");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfoBeforeThisArgument, (String)"dataFlowInfoBeforeThisArgument");
        Intrinsics.checkParameterIsNotNull((Object)typeInfoForArgument, (String)"typeInfoForArgument");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        KtExpression ktExpression2 = KtPsiUtil.getLastElementDeparenthesized(valueArgument.getArgumentExpression(), statementFilter);
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression ktExpression3 = ktExpression = ktExpression2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ktExpression");
        Call call2 = CallUtilKt.getCall(ktExpression3, bindingContext2);
        if (call2 != null) {
            Call call3;
            Call it = call3 = call2;
            callResolutionResult = (CallResolutionResult)bindingContext2.get(BindingContext.ONLY_RESOLVED_CALL, it);
        } else {
            callResolutionResult = onlyResolvedCall = null;
        }
        if ((kotlinType = typeInfoForArgument.getType()) == null || (kotlinType = kotlinType.unwrap()) == null) {
            ResolvedAtom resolvedAtom = onlyResolvedCall;
            kotlinType = resolvedAtom != null && (resolvedAtom = resolvedAtom.getResultCallAtom()) != null ? ResolutionAtomsKt.getFreshReturnType((ResolvedCallAtom)resolvedAtom) : null;
        }
        if (kotlinType == null) {
            return null;
        }
        KotlinType baseType = kotlinType;
        ReceiverValueWithSmartCastInfo it = receiverValueWithSmartCastInfo = NewResolutionOldInferenceKt.transformToReceiverWithSmartCastInfo(ownerDescriptor, bindingContext2, typeInfoForArgument.getDataFlowInfo(), ExpressionReceiver.Companion.create(ktExpression, baseType, bindingContext2), languageVersionSettings);
        ReceiverValueWithSmartCastInfo receiverToCast = onlyResolvedCall == null ? QualifierReceiverKt.prepareReceiverRegardingCaptureTypes(it) : it;
        return onlyResolvedCall == null ? (SimplePSIKotlinCallArgument)new ExpressionKotlinCallArgumentImpl(valueArgument, dataFlowInfoBeforeThisArgument, typeInfoForArgument.getDataFlowInfo(), receiverToCast) : (SimplePSIKotlinCallArgument)new SubKotlinCallArgumentImpl(valueArgument, dataFlowInfoBeforeThisArgument, typeInfoForArgument.getDataFlowInfo(), receiverToCast, onlyResolvedCall);
    }
}

