/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkVersionUtil {
    public static boolean isAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion minVersion) {
        JavaSdkVersion version;
        if (element == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(0);
        }
        if (minVersion == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(1);
        }
        return (version = JavaSdkVersionUtil.getJavaSdkVersion(element)) == null || version.isAtLeast(minVersion);
    }

    public static JavaSdkVersion getJavaSdkVersion(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(2);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null ? JavaSdkVersionUtil.getJavaSdkVersion(ModuleRootManager.getInstance((Module)module).getSdk()) : null;
    }

    public static JavaSdkVersion getJavaSdkVersion(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkType() instanceof JavaSdk ? ((JavaSdk)sdk.getSdkType()).getVersion(sdk) : null;
    }

    @Nullable
    public static Sdk findJdkByVersion(@NotNull JavaSdkVersion version) {
        if (version == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(3);
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        Sdk candidate = null;
        for (Sdk sdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk)) {
            JavaSdkVersion v = javaSdk.getVersion(sdk);
            if (v == version) {
                return sdk;
            }
            if (candidate != null || v == null || !v.isAtLeast(version)) continue;
            candidate = sdk;
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/projectRoots/JavaSdkVersionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAtLeast";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getJavaSdkVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findJdkByVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

