/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

public class UsageEvents
implements Parcelable {
    public static final String INSTANT_APP_PACKAGE_NAME = "android.instant_app";
    public static final String INSTANT_APP_CLASS_NAME = "android.instant_class";
    private List<Event> mEventsToWrite = null;
    private Parcel mParcel = null;
    private final int mEventCount;
    private int mIndex = 0;
    private String[] mStringPool;
    public static final Parcelable.Creator<UsageEvents> CREATOR = new Parcelable.Creator<UsageEvents>(){

        @Override
        public UsageEvents createFromParcel(Parcel source) {
            return new UsageEvents(source);
        }

        public UsageEvents[] newArray(int size) {
            return new UsageEvents[size];
        }
    };

    public UsageEvents(Parcel in) {
        this.mEventCount = in.readInt();
        this.mIndex = in.readInt();
        if (this.mEventCount > 0) {
            this.mStringPool = in.createStringArray();
            int listByteLength = in.readInt();
            int positionInParcel = in.readInt();
            this.mParcel = Parcel.obtain();
            this.mParcel.setDataPosition(0);
            this.mParcel.appendFrom(in, in.dataPosition(), listByteLength);
            this.mParcel.setDataSize(this.mParcel.dataPosition());
            this.mParcel.setDataPosition(positionInParcel);
        }
    }

    UsageEvents() {
        this.mEventCount = 0;
    }

    public UsageEvents(List<Event> events, String[] stringPool) {
        this.mStringPool = stringPool;
        this.mEventCount = events.size();
        this.mEventsToWrite = events;
    }

    public boolean hasNextEvent() {
        return this.mIndex < this.mEventCount;
    }

    public boolean getNextEvent(Event eventOut) {
        if (this.mIndex >= this.mEventCount) {
            return false;
        }
        this.readEventFromParcel(this.mParcel, eventOut);
        ++this.mIndex;
        if (this.mIndex >= this.mEventCount) {
            this.mParcel.recycle();
            this.mParcel = null;
        }
        return true;
    }

    public void resetToStart() {
        this.mIndex = 0;
        if (this.mParcel != null) {
            this.mParcel.setDataPosition(0);
        }
    }

    private int findStringIndex(String str) {
        int index = Arrays.binarySearch(this.mStringPool, str);
        if (index < 0) {
            throw new IllegalStateException("String '" + str + "' is not in the string pool");
        }
        return index;
    }

    private void writeEventToParcel(Event event, Parcel p, int flags) {
        int packageIndex = event.mPackage != null ? this.findStringIndex(event.mPackage) : -1;
        int classIndex = event.mClass != null ? this.findStringIndex(event.mClass) : -1;
        p.writeInt(packageIndex);
        p.writeInt(classIndex);
        p.writeInt(event.mEventType);
        p.writeLong(event.mTimeStamp);
        switch (event.mEventType) {
            case 5: {
                event.mConfiguration.writeToParcel(p, flags);
                break;
            }
            case 8: {
                p.writeString(event.mShortcutId);
                break;
            }
            case 9: {
                p.writeString(event.mAction);
                p.writeString(event.mContentType);
                p.writeStringArray(event.mContentAnnotations);
            }
        }
    }

    private void readEventFromParcel(Parcel p, Event eventOut) {
        int packageIndex = p.readInt();
        eventOut.mPackage = packageIndex >= 0 ? this.mStringPool[packageIndex] : null;
        int classIndex = p.readInt();
        eventOut.mClass = classIndex >= 0 ? this.mStringPool[classIndex] : null;
        eventOut.mEventType = p.readInt();
        eventOut.mTimeStamp = p.readLong();
        eventOut.mConfiguration = null;
        eventOut.mShortcutId = null;
        eventOut.mAction = null;
        eventOut.mContentType = null;
        eventOut.mContentAnnotations = null;
        switch (eventOut.mEventType) {
            case 5: {
                eventOut.mConfiguration = Configuration.CREATOR.createFromParcel(p);
                break;
            }
            case 8: {
                eventOut.mShortcutId = p.readString();
                break;
            }
            case 9: {
                eventOut.mAction = p.readString();
                eventOut.mContentType = p.readString();
                eventOut.mContentAnnotations = p.createStringArray();
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mEventCount);
        dest.writeInt(this.mIndex);
        if (this.mEventCount > 0) {
            dest.writeStringArray(this.mStringPool);
            if (this.mEventsToWrite != null) {
                Parcel p = Parcel.obtain();
                try {
                    p.setDataPosition(0);
                    for (int i = 0; i < this.mEventCount; ++i) {
                        Event event = this.mEventsToWrite.get(i);
                        this.writeEventToParcel(event, p, flags);
                    }
                    int listByteLength = p.dataPosition();
                    dest.writeInt(listByteLength);
                    dest.writeInt(0);
                    dest.appendFrom(p, 0, listByteLength);
                }
                finally {
                    p.recycle();
                }
            } else if (this.mParcel != null) {
                dest.writeInt(this.mParcel.dataSize());
                dest.writeInt(this.mParcel.dataPosition());
                dest.appendFrom(this.mParcel, 0, this.mParcel.dataSize());
            } else {
                throw new IllegalStateException("Either mParcel or mEventsToWrite must not be null");
            }
        }
    }

    public static class Event {
        public static final int NONE = 0;
        public static final int MOVE_TO_FOREGROUND = 1;
        public static final int MOVE_TO_BACKGROUND = 2;
        public static final int END_OF_DAY = 3;
        public static final int CONTINUE_PREVIOUS_DAY = 4;
        public static final int CONFIGURATION_CHANGE = 5;
        public static final int SYSTEM_INTERACTION = 6;
        public static final int USER_INTERACTION = 7;
        public static final int SHORTCUT_INVOCATION = 8;
        public static final int CHOOSER_ACTION = 9;
        public static final int FLAG_IS_PACKAGE_INSTANT_APP = 1;
        public String mPackage;
        public String mClass;
        public long mTimeStamp;
        public int mEventType;
        public Configuration mConfiguration;
        public String mShortcutId;
        public String mAction;
        public String mContentType;
        public String[] mContentAnnotations;
        public int mFlags;

        public Event() {
        }

        public Event(Event orig) {
            this.mPackage = orig.mPackage;
            this.mClass = orig.mClass;
            this.mTimeStamp = orig.mTimeStamp;
            this.mEventType = orig.mEventType;
            this.mConfiguration = orig.mConfiguration;
            this.mShortcutId = orig.mShortcutId;
            this.mAction = orig.mAction;
            this.mContentType = orig.mContentType;
            this.mContentAnnotations = orig.mContentAnnotations;
            this.mFlags = orig.mFlags;
        }

        public String getPackageName() {
            return this.mPackage;
        }

        public String getClassName() {
            return this.mClass;
        }

        public long getTimeStamp() {
            return this.mTimeStamp;
        }

        public int getEventType() {
            return this.mEventType;
        }

        public Configuration getConfiguration() {
            return this.mConfiguration;
        }

        public String getShortcutId() {
            return this.mShortcutId;
        }

        public Event getObfuscatedIfInstantApp() {
            if ((this.mFlags & 1) == 0) {
                return this;
            }
            Event ret = new Event(this);
            ret.mPackage = UsageEvents.INSTANT_APP_PACKAGE_NAME;
            ret.mClass = UsageEvents.INSTANT_APP_CLASS_NAME;
            return ret;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface EventFlags {
        }
    }
}

