/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.FontFamily;
import android.graphics.FontFamily_Delegate;
import android.graphics.Typeface;
import android.graphics.fonts.FontVariationAxis;
import android.text.FontConfig;
import android.util.ArrayMap;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Font;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;

public final class Typeface_Delegate {
    public static final String SYSTEM_FONTS = "/system/fonts/";
    private static final DelegateManager<Typeface_Delegate> sManager = new DelegateManager<Typeface_Delegate>(Typeface_Delegate.class);
    private static long sDefaultTypeface;
    private final FontFamily_Delegate[] mFontFamilies;
    private final int mStyle;
    private final int mWeight;
    private SoftReference<EnumMap<FontFamily_Delegate.FontVariant, List<Font>>> mFontsCache = new SoftReference<Object>(null);

    public Typeface_Delegate(FontFamily_Delegate[] fontFamilies, int style2, int weight) {
        this.mFontFamilies = fontFamilies;
        this.mStyle = style2;
        this.mWeight = weight;
    }

    public static Typeface_Delegate getDelegate(long nativeTypeface) {
        return sManager.getDelegate(nativeTypeface);
    }

    public static void resetDefaults() {
        if (FontFamily_Delegate.getFontLocation() != null) {
            Typeface.sDefaults = null;
        }
    }

    @LayoutlibDelegate
    static synchronized long nativeCreateFromTypeface(long native_instance, int style2) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            delegate = sManager.getDelegate(sDefaultTypeface);
        }
        if (delegate == null) {
            return 0L;
        }
        return sManager.addNewDelegate(new Typeface_Delegate(delegate.mFontFamilies, style2, delegate.mWeight));
    }

    @LayoutlibDelegate
    static long nativeCreateFromTypefaceWithExactStyle(long native_instance, int weight, boolean italic) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            delegate = sManager.getDelegate(sDefaultTypeface);
        }
        if (delegate == null) {
            return 0L;
        }
        int style2 = weight >= 600 ? (italic ? 3 : 1) : (italic ? 2 : 0);
        return sManager.addNewDelegate(new Typeface_Delegate(delegate.mFontFamilies, style2, weight));
    }

    @LayoutlibDelegate
    static synchronized long nativeCreateFromTypefaceWithVariation(long native_instance, List<FontVariationAxis> axes) {
        long newInstance = Typeface_Delegate.nativeCreateFromTypeface(native_instance, 0);
        if (newInstance != 0L) {
            Bridge.getLog().fidelityWarning("unsupported", "nativeCreateFromTypefaceWithVariation is not supported", null, null);
        }
        return newInstance;
    }

    @LayoutlibDelegate
    static synchronized int[] nativeGetSupportedAxes(long native_instance) {
        return null;
    }

    @LayoutlibDelegate
    static long nativeCreateWeightAlias(long native_instance, int weight) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            delegate = sManager.getDelegate(sDefaultTypeface);
        }
        if (delegate == null) {
            return 0L;
        }
        Typeface_Delegate weightAlias = new Typeface_Delegate(delegate.mFontFamilies, delegate.mStyle, weight);
        return sManager.addNewDelegate(weightAlias);
    }

    @LayoutlibDelegate
    static synchronized long nativeCreateFromArray(long[] familyArray, int weight, int italic) {
        FontFamily_Delegate[] fontFamilies = new FontFamily_Delegate[familyArray.length];
        for (int i = 0; i < familyArray.length; ++i) {
            fontFamilies[i] = FontFamily_Delegate.getDelegate(familyArray[i]);
        }
        if (weight == -1) {
            weight = 400;
        }
        if (italic == -1) {
            italic = 0;
        }
        int style2 = weight >= 600 ? (italic == 1 ? 3 : 1) : (italic == 1 ? 2 : 0);
        Typeface_Delegate delegate = new Typeface_Delegate(fontFamilies, style2, weight);
        return sManager.addNewDelegate(delegate);
    }

    @LayoutlibDelegate
    static void nativeUnref(long native_instance) {
        sManager.removeJavaReferenceFor(native_instance);
    }

    @LayoutlibDelegate
    static int nativeGetStyle(long native_instance) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            return 0;
        }
        return delegate.mStyle;
    }

    @LayoutlibDelegate
    static void nativeSetDefault(long native_instance) {
        sDefaultTypeface = native_instance;
    }

    @LayoutlibDelegate
    static int nativeGetWeight(long native_instance) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            return 0;
        }
        return delegate.mWeight;
    }

    @LayoutlibDelegate
    static void buildSystemFallback(String xmlPath, String fontDir, ArrayMap<String, Typeface> fontMap, ArrayMap<String, FontFamily[]> fallbackMap) {
        Typeface.buildSystemFallback_Original(FontFamily_Delegate.getFontLocation() + "/fonts.xml", fontDir, fontMap, fallbackMap);
    }

    @LayoutlibDelegate
    static FontFamily createFontFamily(String familyName, List<FontConfig.Font> fonts, String[] languageTags, int variant, Map<String, ByteBuffer> cache, String fontDir) {
        FontFamily fontFamily = new FontFamily(languageTags, variant);
        for (FontConfig.Font font : fonts) {
            String fullPathName = fontDir + font.getFontName();
            FontFamily_Delegate.addFont(fontFamily.mBuilderPtr, fullPathName, font.getWeight(), font.isItalic());
        }
        fontFamily.freeze();
        return fontFamily;
    }

    @LayoutlibDelegate
    static Typeface create(String familyName, int style2) {
        if (familyName != null && Files.exists(Paths.get(familyName, new String[0]), new LinkOption[0])) {
            return Typeface.createFromFile(familyName);
        }
        return Typeface.create_Original(familyName, style2);
    }

    @LayoutlibDelegate
    static Typeface create(Typeface family, int style2) {
        return Typeface.create_Original(family, style2);
    }

    @LayoutlibDelegate
    static Typeface create(Typeface family, int style2, boolean isItalic) {
        return Typeface.create_Original(family, style2, isItalic);
    }

    private static List<Font> computeFonts(FontFamily_Delegate.FontVariant variant, FontFamily_Delegate[] fontFamilies, int inputWeight, int inputStyle) {
        int weight = inputWeight + 50 + ((inputStyle & 1) == 0 ? 0 : 300);
        if (weight > 1000) {
            weight = 1000;
        } else if (weight < 100) {
            weight = 100;
        }
        boolean isItalic = (inputStyle & 2) != 0;
        ArrayList<Font> fonts = new ArrayList<Font>(fontFamilies.length);
        for (int i = 0; i < fontFamilies.length; ++i) {
            FontFamily_Delegate ffd = fontFamilies[i];
            if (ffd == null || !ffd.isValid()) continue;
            Font font = ffd.getFont(weight, isItalic);
            if (font != null) {
                FontFamily_Delegate.FontVariant ffdVariant = ffd.getVariant();
                if (ffdVariant == FontFamily_Delegate.FontVariant.NONE) {
                    fonts.add(font);
                    continue;
                }
                assert (i < fontFamilies.length - 1);
                FontFamily_Delegate ffd2 = fontFamilies[++i];
                assert (ffd2 != null);
                FontFamily_Delegate.FontVariant ffd2Variant = ffd2.getVariant();
                Font font2 = ffd2.getFont(weight, isItalic);
                assert (ffd2Variant != FontFamily_Delegate.FontVariant.NONE && ffd2Variant != ffdVariant && font2 != null);
                if (variant == ffd.getVariant()) {
                    fonts.add(font);
                    continue;
                }
                fonts.add(font2);
                continue;
            }
            fonts.add(null);
        }
        return fonts;
    }

    public Iterable<Font> getFonts(FontFamily_Delegate.FontVariant variant) {
        assert (variant != FontFamily_Delegate.FontVariant.NONE);
        return new FontsIterator(this.mFontFamilies, variant, this.mWeight, this.mStyle);
    }

    private static class FontsIterator
    implements Iterator<Font>,
    Iterable<Font> {
        private final FontFamily_Delegate[] fontFamilies;
        private final int weight;
        private final boolean isItalic;
        private final FontFamily_Delegate.FontVariant variant;
        private int index = 0;

        private FontsIterator(FontFamily_Delegate[] fontFamilies, FontFamily_Delegate.FontVariant variant, int weight, int style2) {
            int boldExtraWeight = (style2 & 1) == 0 ? 0 : 300;
            this.weight = Math.min(Math.max(100, weight + 50 + boldExtraWeight), 1000);
            this.isItalic = (style2 & 2) != 0;
            this.fontFamilies = fontFamilies;
            this.variant = variant;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.fontFamilies.length;
        }

        @Override
        public Font next() {
            FontFamily_Delegate ffd;
            if ((ffd = this.fontFamilies[this.index++]) == null || !ffd.isValid()) {
                return null;
            }
            Font font = ffd.getFont(this.weight, this.isItalic);
            if (font == null) {
                return null;
            }
            FontFamily_Delegate.FontVariant ffdVariant = ffd.getVariant();
            if (ffdVariant == FontFamily_Delegate.FontVariant.NONE) {
                return font;
            }
            assert (this.index < this.fontFamilies.length - 1);
            FontFamily_Delegate ffd2 = this.fontFamilies[this.index++];
            assert (ffd2 != null);
            if (ffdVariant == this.variant) {
                return font;
            }
            FontFamily_Delegate.FontVariant ffd2Variant = ffd2.getVariant();
            Font font2 = ffd2.getFont(this.weight, this.isItalic);
            assert (ffd2Variant != FontFamily_Delegate.FontVariant.NONE && ffd2Variant != ffdVariant && font2 != null);
            return this.variant == ffd.getVariant() ? font : font2;
        }

        @Override
        public Iterator<Font> iterator() {
            return this;
        }

        @Override
        public Spliterator<Font> spliterator() {
            return Spliterators.spliterator(this.iterator(), (long)this.fontFamilies.length, 1088);
        }
    }
}

