/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class TvStreamConfig
implements Parcelable {
    static final String TAG = TvStreamConfig.class.getSimpleName();
    public static final int STREAM_TYPE_INDEPENDENT_VIDEO_SOURCE = 1;
    public static final int STREAM_TYPE_BUFFER_PRODUCER = 2;
    private int mStreamId;
    private int mType;
    private int mMaxWidth;
    private int mMaxHeight;
    private int mGeneration;
    public static final Parcelable.Creator<TvStreamConfig> CREATOR = new Parcelable.Creator<TvStreamConfig>(){

        @Override
        public TvStreamConfig createFromParcel(Parcel source) {
            try {
                return new Builder().streamId(source.readInt()).type(source.readInt()).maxWidth(source.readInt()).maxHeight(source.readInt()).generation(source.readInt()).build();
            }
            catch (Exception e) {
                Log.e(TAG, "Exception creating TvStreamConfig from parcel", e);
                return null;
            }
        }

        public TvStreamConfig[] newArray(int size) {
            return new TvStreamConfig[size];
        }
    };

    private TvStreamConfig() {
    }

    public int getStreamId() {
        return this.mStreamId;
    }

    public int getType() {
        return this.mType;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    public int getGeneration() {
        return this.mGeneration;
    }

    public String toString() {
        return "TvStreamConfig {mStreamId=" + this.mStreamId + ";mType=" + this.mType + ";mGeneration=" + this.mGeneration + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStreamId);
        dest.writeInt(this.mType);
        dest.writeInt(this.mMaxWidth);
        dest.writeInt(this.mMaxHeight);
        dest.writeInt(this.mGeneration);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TvStreamConfig)) {
            return false;
        }
        TvStreamConfig config = (TvStreamConfig)obj;
        return config.mGeneration == this.mGeneration && config.mStreamId == this.mStreamId && config.mType == this.mType && config.mMaxWidth == this.mMaxWidth && config.mMaxHeight == this.mMaxHeight;
    }

    public static class Builder {
        private Integer mStreamId;
        private Integer mType;
        private Integer mMaxWidth;
        private Integer mMaxHeight;
        private Integer mGeneration;

        public Builder streamId(int streamId) {
            this.mStreamId = streamId;
            return this;
        }

        public Builder type(int type) {
            this.mType = type;
            return this;
        }

        public Builder maxWidth(int maxWidth) {
            this.mMaxWidth = maxWidth;
            return this;
        }

        public Builder maxHeight(int maxHeight) {
            this.mMaxHeight = maxHeight;
            return this;
        }

        public Builder generation(int generation) {
            this.mGeneration = generation;
            return this;
        }

        public TvStreamConfig build() {
            if (this.mStreamId == null || this.mType == null || this.mMaxWidth == null || this.mMaxHeight == null || this.mGeneration == null) {
                throw new UnsupportedOperationException();
            }
            TvStreamConfig config = new TvStreamConfig();
            config.mStreamId = this.mStreamId;
            config.mType = this.mType;
            config.mMaxWidth = this.mMaxWidth;
            config.mMaxHeight = this.mMaxHeight;
            config.mGeneration = this.mGeneration;
            return config;
        }
    }
}

