/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ConnectivityManager;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import libcore.net.http.Dns;
import libcore.net.http.HttpURLConnectionFactory;

public class Network
implements Parcelable {
    public final int netId;
    private volatile NetworkBoundSocketFactory mNetworkBoundSocketFactory = null;
    private volatile HttpURLConnectionFactory mUrlConnectionFactory;
    private final Object mLock = new Object();
    private static final boolean httpKeepAlive = Boolean.parseBoolean(System.getProperty("http.keepAlive", "true"));
    private static final int httpMaxConnections = httpKeepAlive ? Integer.parseInt(System.getProperty("http.maxConnections", "5")) : 0;
    private static final long httpKeepAliveDurationMs = Long.parseLong(System.getProperty("http.keepAliveDuration", "300000"));
    public static final Parcelable.Creator<Network> CREATOR = new Parcelable.Creator<Network>(){

        @Override
        public Network createFromParcel(Parcel in) {
            int netId = in.readInt();
            return new Network(netId);
        }

        public Network[] newArray(int size) {
            return new Network[size];
        }
    };

    public Network(int netId) {
        this.netId = netId;
    }

    public Network(Network that) {
        this.netId = that.netId;
    }

    public InetAddress[] getAllByName(String host) throws UnknownHostException {
        return InetAddress.getAllByNameOnNet((String)host, (int)this.netId);
    }

    public InetAddress getByName(String host) throws UnknownHostException {
        return InetAddress.getByNameOnNet((String)host, (int)this.netId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketFactory getSocketFactory() {
        if (this.mNetworkBoundSocketFactory == null) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mNetworkBoundSocketFactory == null) {
                    this.mNetworkBoundSocketFactory = new NetworkBoundSocketFactory(this.netId);
                }
            }
        }
        return this.mNetworkBoundSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitUrlConnectionFactory() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUrlConnectionFactory == null) {
                Dns dnsLookup = hostname -> Arrays.asList(this.getAllByName(hostname));
                HttpURLConnectionFactory urlConnectionFactory = new HttpURLConnectionFactory();
                urlConnectionFactory.setDns(dnsLookup);
                urlConnectionFactory.setNewConnectionPool(httpMaxConnections, httpKeepAliveDurationMs, TimeUnit.MILLISECONDS);
                this.mUrlConnectionFactory = urlConnectionFactory;
            }
        }
    }

    public URLConnection openConnection(URL url) throws IOException {
        ConnectivityManager cm = ConnectivityManager.getInstanceOrNull();
        if (cm == null) {
            throw new IOException("No ConnectivityManager yet constructed, please construct one");
        }
        ProxyInfo proxyInfo = cm.getProxyForNetwork(this);
        Proxy proxy = proxyInfo != null ? proxyInfo.makeProxy() : Proxy.NO_PROXY;
        return this.openConnection(url, proxy);
    }

    public URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy is null");
        }
        this.maybeInitUrlConnectionFactory();
        SocketFactory socketFactory = this.getSocketFactory();
        return this.mUrlConnectionFactory.openConnection(url, socketFactory, proxy);
    }

    public void bindSocket(DatagramSocket socket) throws IOException {
        socket.getReuseAddress();
        this.bindSocket(socket.getFileDescriptor$());
    }

    public void bindSocket(Socket socket) throws IOException {
        socket.getReuseAddress();
        this.bindSocket(socket.getFileDescriptor$());
    }

    public void bindSocket(FileDescriptor fd) throws IOException {
        int err;
        try {
            SocketAddress peer = Os.getpeername(fd);
            InetAddress inetPeer = ((InetSocketAddress)peer).getAddress();
            if (!inetPeer.isAnyLocalAddress()) {
                throw new SocketException("Socket is connected");
            }
        }
        catch (ErrnoException e) {
            if (e.errno != OsConstants.ENOTCONN) {
                throw e.rethrowAsSocketException();
            }
        }
        catch (ClassCastException e) {
            throw new SocketException("Only AF_INET/AF_INET6 sockets supported");
        }
        if ((err = NetworkUtils.bindSocketToNetwork(fd.getInt$(), this.netId)) != 0) {
            throw new ErrnoException("Binding socket to network " + this.netId, -err).rethrowAsSocketException();
        }
    }

    public long getNetworkHandle() {
        if (this.netId == 0) {
            return 0L;
        }
        long HANDLE_MAGIC = 16435934L;
        return (long)this.netId << 32 | 0xFACADEL;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.netId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network)obj;
        return this.netId == other.netId;
    }

    public int hashCode() {
        return this.netId * 11;
    }

    public String toString() {
        return Integer.toString(this.netId);
    }

    private class NetworkBoundSocketFactory
    extends SocketFactory {
        private final int mNetId;

        public NetworkBoundSocketFactory(int netId) {
            this.mNetId = netId;
        }

        private Socket connectToHost(String host, int port, SocketAddress localAddress) throws IOException {
            InetAddress[] hostAddresses = Network.this.getAllByName(host);
            for (int i = 0; i < hostAddresses.length; ++i) {
                try {
                    Socket socket = this.createSocket();
                    if (localAddress != null) {
                        socket.bind(localAddress);
                    }
                    socket.connect(new InetSocketAddress(hostAddresses[i], port));
                    return socket;
                }
                catch (IOException e) {
                    if (i != hostAddresses.length - 1) continue;
                    throw e;
                }
            }
            throw new UnknownHostException(host);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.connectToHost(host, port, new InetSocketAddress(localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket socket = this.createSocket();
            socket.bind(new InetSocketAddress(localAddress, localPort));
            socket.connect(new InetSocketAddress(address, port));
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            Socket socket = this.createSocket();
            socket.connect(new InetSocketAddress(host, port));
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.connectToHost(host, port, null);
        }

        @Override
        public Socket createSocket() throws IOException {
            Socket socket = new Socket();
            Network.this.bindSocket(socket);
            return socket;
        }
    }
}

