/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.XmlPullAttributes;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.util.Map;
import java.util.function.Function;
import org.xmlpull.v1.XmlPullParser;

public class BridgeXmlPullAttributes
extends XmlPullAttributes {
    private final BridgeContext mContext;
    private final boolean mPlatformFile;
    private final Function<String, Map<String, Integer>> mFrameworkEnumValueSupplier;
    private final Function<String, Map<String, Integer>> mProjectEnumValueSupplier;

    BridgeXmlPullAttributes(XmlPullParser parser, BridgeContext context, boolean platformFile, Function<String, Map<String, Integer>> frameworkEnumValueSupplier, Function<String, Map<String, Integer>> projectEnumValueSupplier) {
        super(parser);
        this.mContext = context;
        this.mPlatformFile = platformFile;
        this.mFrameworkEnumValueSupplier = frameworkEnumValueSupplier;
        this.mProjectEnumValueSupplier = projectEnumValueSupplier;
    }

    public BridgeXmlPullAttributes(XmlPullParser parser, BridgeContext context, boolean platformFile) {
        this(parser, context, platformFile, Bridge::getEnumValues, attrName -> {
            RenderResources res = context.getRenderResources();
            ResourceValue attr2 = res.getProjectResource(ResourceType.ATTR, attrName);
            return attr2 instanceof AttrResourceValue ? ((AttrResourceValue)attr2).getAttributeValues() : null;
        });
    }

    @Override
    public int getAttributeNameResource(int index) {
        Integer v;
        String name = this.getAttributeName(index);
        String ns = this.mParser.getAttributeNamespace(index);
        if ("http://schemas.android.com/apk/res/android".equals(ns)) {
            return Bridge.getResourceId(ResourceType.ATTR, name);
        }
        if (this.mContext.getLayoutlibCallback().getNamespace().equals(ns) && (v = this.mContext.getLayoutlibCallback().getResourceId(ResourceType.ATTR, name)) != null) {
            return v;
        }
        return 0;
    }

    @Override
    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToList(value, options, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToBoolean(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        return this.resolveResourceValue(value, defaultValue);
    }

    @Override
    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value == null) {
            return defaultValue;
        }
        ResourceValue r = this.getResourceValue(value);
        if (r != null) {
            value = r.getValue();
        }
        if (value.charAt(0) == '#') {
            return ResourceHelper.getColor(value);
        }
        try {
            return XmlUtils.convertValueToInt(value, defaultValue);
        }
        catch (NumberFormatException e) {
            Integer enumValue;
            Map<String, Integer> enumValues = "http://schemas.android.com/apk/res/android".equals(namespace) ? this.mFrameworkEnumValueSupplier.apply(attribute) : this.mProjectEnumValueSupplier.apply(attribute);
            Integer n = enumValue = enumValues != null ? enumValues.get(value) : null;
            if (enumValue != null) {
                return enumValue;
            }
            throw e;
        }
    }

    @Override
    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToUnsignedInt(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        String s = this.getAttributeValue(namespace, attribute);
        if (s != null) {
            ResourceValue r = this.getResourceValue(s);
            if (r != null) {
                s = r.getValue();
            }
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        return XmlUtils.convertValueToList(this.getAttributeValue(index), options, defaultValue);
    }

    @Override
    public boolean getAttributeBooleanValue(int index, boolean defaultValue) {
        String value = this.getAttributeValue(index);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToBoolean(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeResourceValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        return this.resolveResourceValue(value, defaultValue);
    }

    @Override
    public int getAttributeIntValue(int index, int defaultValue) {
        return this.getAttributeIntValue(this.mParser.getAttributeNamespace(index), this.getAttributeName(index), defaultValue);
    }

    @Override
    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToUnsignedInt(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public float getAttributeFloatValue(int index, float defaultValue) {
        String s = this.getAttributeValue(index);
        if (s != null) {
            ResourceValue r = this.getResourceValue(s);
            if (r != null) {
                s = r.getValue();
            }
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    private ResourceValue getResourceValue(String value) {
        RenderResources resources = this.mContext.getRenderResources();
        return resources.resolveResValue(resources.findResValue(value, this.mPlatformFile));
    }

    private int resolveResourceValue(String value, int defaultValue) {
        Integer id2;
        ResourceValue resource = this.getResourceValue(value);
        if (resource != null && (id2 = this.mPlatformFile || resource.isFramework() ? Bridge.getResourceId(resource.getResourceType(), resource.getName()) : this.mContext.getLayoutlibCallback().getResourceId(resource.getResourceType(), resource.getName())) != null) {
            return id2;
        }
        return defaultValue;
    }
}

