/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Rect;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.autofill.FillEventHistory;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import android.view.autofill.IAutofillWindowPresenter;
import android.view.autofill.ParcelableMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AutofillManager {
    private static final String TAG = "AutofillManager";
    public static final String EXTRA_ASSIST_STRUCTURE = "android.view.autofill.extra.ASSIST_STRUCTURE";
    public static final String EXTRA_AUTHENTICATION_RESULT = "android.view.autofill.extra.AUTHENTICATION_RESULT";
    public static final String EXTRA_CLIENT_STATE = "android.view.autofill.extra.CLIENT_STATE";
    public static final String EXTRA_RESTORE_SESSION_TOKEN = "android.view.autofill.extra.RESTORE_SESSION_TOKEN";
    private static final String SESSION_ID_TAG = "android:sessionId";
    private static final String STATE_TAG = "android:state";
    private static final String LAST_AUTOFILLED_DATA_TAG = "android:lastAutoFilledData";
    public static final int ACTION_START_SESSION = 1;
    public static final int ACTION_VIEW_ENTERED = 2;
    public static final int ACTION_VIEW_EXITED = 3;
    public static final int ACTION_VALUE_CHANGED = 4;
    public static final int FLAG_ADD_CLIENT_ENABLED = 1;
    public static final int FLAG_ADD_CLIENT_DEBUG = 2;
    public static final int FLAG_ADD_CLIENT_VERBOSE = 4;
    private static final int AUTHENTICATION_ID_DATASET_ID_MASK = 65535;
    private static final int AUTHENTICATION_ID_DATASET_ID_SHIFT = 16;
    public static final int AUTHENTICATION_ID_DATASET_ID_UNDEFINED = 65535;
    public static final int PENDING_UI_OPERATION_CANCEL = 1;
    public static final int PENDING_UI_OPERATION_RESTORE = 2;
    public static final int STATE_UNKNOWN = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_SHOWING_SAVE_UI = 4;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    public static final int NO_SESSION = Integer.MIN_VALUE;
    private final IAutoFillManager mService;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private IAutoFillManagerClient mServiceClient;
    @GuardedBy(value="mLock")
    private AutofillCallback mCallback;
    private final Context mContext;
    @GuardedBy(value="mLock")
    private int mSessionId = Integer.MIN_VALUE;
    @GuardedBy(value="mLock")
    private int mState = 1;
    @GuardedBy(value="mLock")
    private boolean mEnabled;
    @GuardedBy(value="mLock")
    private ParcelableMap mLastAutofilledData;
    @GuardedBy(value="mLock")
    private TrackedViews mTrackedViews;
    @GuardedBy(value="mLock")
    private ArraySet<AutofillId> mFillableIds;

    public static int makeAuthenticationId(int requestId, int datasetId) {
        return requestId << 16 | datasetId & 0xFFFF;
    }

    public static int getRequestIdFromAuthenticationId(int authRequestId) {
        return authRequestId >> 16;
    }

    public static int getDatasetIdFromAuthenticationId(int authRequestId) {
        return authRequestId & 0xFFFF;
    }

    public AutofillManager(Context context, IAutoFillManager service) {
        this.mContext = context;
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(Bundle savedInstanceState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLastAutofilledData = (ParcelableMap)savedInstanceState.getParcelable(LAST_AUTOFILLED_DATA_TAG);
            if (this.isActiveLocked()) {
                Log.w(TAG, "New session was started before onCreate()");
                return;
            }
            this.mSessionId = savedInstanceState.getInt(SESSION_ID_TAG, Integer.MIN_VALUE);
            this.mState = savedInstanceState.getInt(STATE_TAG, 1);
            if (this.mSessionId != Integer.MIN_VALUE) {
                this.ensureServiceClientAddedIfNeededLocked();
                AutofillClient client = this.getClientLocked();
                if (client != null) {
                    try {
                        boolean sessionWasRestored = this.mService.restoreSession(this.mSessionId, this.mContext.getActivityToken(), this.mServiceClient.asBinder());
                        if (!sessionWasRestored) {
                            Log.w(TAG, "Session " + this.mSessionId + " could not be restored");
                            this.mSessionId = Integer.MIN_VALUE;
                            this.mState = 1;
                        } else {
                            if (Helper.sDebug) {
                                Log.d(TAG, "session " + this.mSessionId + " was restored");
                            }
                            client.autofillCallbackResetableStateAvailable();
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Could not figure out if there was an autofill session", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVisibleForAutofill() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.isActiveLocked() && this.mTrackedViews != null) {
                this.mTrackedViews.onVisibleForAutofillLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSaveInstanceState(Bundle outState) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MIN_VALUE) {
                outState.putInt(SESSION_ID_TAG, this.mSessionId);
            }
            if (this.mState != 1) {
                outState.putInt(STATE_TAG, this.mState);
            }
            if (this.mLastAutofilledData != null) {
                outState.putParcelable(LAST_AUTOFILLED_DATA_TAG, this.mLastAutofilledData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        if (!this.hasAutofillFeature()) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureServiceClientAddedIfNeededLocked();
            return this.mEnabled;
        }
    }

    public FillEventHistory getFillEventHistory() {
        try {
            return this.mService.getFillEventHistory();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public void requestAutofill(View view) {
        this.notifyViewEntered(view, 1);
    }

    public void requestAutofill(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 1);
    }

    public void notifyViewEntered(View view) {
        this.notifyViewEntered(view, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewEntered(View view, int flags) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            this.ensureServiceClientAddedIfNeededLocked();
            if (!this.mEnabled) {
                if (this.mCallback != null) {
                    callback = this.mCallback;
                }
            } else {
                AutofillId id2 = AutofillManager.getAutofillId(view);
                AutofillValue value = view.getAutofillValue();
                if (!this.isActiveLocked()) {
                    this.startSessionLocked(id2, null, value, flags);
                } else {
                    this.updateSessionLocked(id2, null, value, 2, flags);
                }
            }
        }
        if (callback != null) {
            this.mCallback.onAutofillEvent(view, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyViewExited(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureServiceClientAddedIfNeededLocked();
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2 = AutofillManager.getAutofillId(view);
                this.updateSessionLocked(id2, null, null, 3, 0);
            }
        }
    }

    public void notifyViewVisibilityChanged(View view, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, 0, isVisible, false);
    }

    public void notifyViewVisibilityChanged(View view, int virtualId, boolean isVisible) {
        this.notifyViewVisibilityChangedInternal(view, virtualId, isVisible, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewVisibilityChangedInternal(View view, int virtualId, boolean isVisible, boolean virtual) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2;
                AutofillId autofillId = id2 = virtual ? AutofillManager.getAutofillId(view, virtualId) : view.getAutofillId();
                if (!isVisible && this.mFillableIds != null && this.mFillableIds.contains(id2)) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "Hidding UI when view " + id2 + " became invisible");
                    }
                    this.requestHideFillUi(id2, view);
                }
                if (this.mTrackedViews != null) {
                    this.mTrackedViews.notifyViewVisibilityChanged(id2, isVisible);
                }
            }
        }
    }

    public void notifyViewEntered(View view, int virtualId, Rect absBounds) {
        this.notifyViewEntered(view, virtualId, absBounds, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewEntered(View view, int virtualId, Rect bounds, int flags) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            this.ensureServiceClientAddedIfNeededLocked();
            if (!this.mEnabled) {
                if (this.mCallback != null) {
                    callback = this.mCallback;
                }
            } else {
                AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
                if (!this.isActiveLocked()) {
                    this.startSessionLocked(id2, bounds, null, flags);
                } else {
                    this.updateSessionLocked(id2, bounds, null, 2, flags);
                }
            }
        }
        if (callback != null) {
            callback.onAutofillEvent(view, virtualId, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyViewExited(View view, int virtualId) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.ensureServiceClientAddedIfNeededLocked();
            if (this.mEnabled && this.isActiveLocked()) {
                AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
                this.updateSessionLocked(id2, null, null, 3, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyValueChanged(View view) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        AutofillId id2 = null;
        boolean valueWasRead = false;
        AutofillValue value = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastAutofilledData == null) {
                view.setAutofilled(false);
            } else {
                id2 = AutofillManager.getAutofillId(view);
                if (this.mLastAutofilledData.containsKey(id2)) {
                    value = view.getAutofillValue();
                    valueWasRead = true;
                    if (Objects.equals(this.mLastAutofilledData.get(id2), value)) {
                        view.setAutofilled(true);
                    } else {
                        view.setAutofilled(false);
                        this.mLastAutofilledData.remove(id2);
                    }
                } else {
                    view.setAutofilled(false);
                }
            }
            if (!this.mEnabled || !this.isActiveLocked()) {
                return;
            }
            if (id2 == null) {
                id2 = AutofillManager.getAutofillId(view);
            }
            if (!valueWasRead) {
                value = view.getAutofillValue();
            }
            this.updateSessionLocked(id2, null, value, 4, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyValueChanged(View view, int virtualId, AutofillValue value) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || !this.isActiveLocked()) {
                return;
            }
            AutofillId id2 = AutofillManager.getAutofillId(view, virtualId);
            this.updateSessionLocked(id2, null, value, 4, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled && !this.isActiveLocked()) {
                return;
            }
            this.finishSessionLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled && !this.isActiveLocked()) {
                return;
            }
            this.cancelSessionLocked();
        }
    }

    public void disableOwnedAutofillServices() {
        this.disableAutofillServices();
    }

    public void disableAutofillServices() {
        if (!this.hasAutofillFeature()) {
            return;
        }
        try {
            this.mService.disableOwnedAutofillServices(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasEnabledAutofillServices() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isServiceEnabled(this.mContext.getUserId(), this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAutofillSupported() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isServiceSupported(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private AutofillClient getClientLocked() {
        if (this.mContext instanceof AutofillClient) {
            return (AutofillClient)((Object)this.mContext);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAuthenticationResult(int authenticationId, Intent data) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        if (Helper.sDebug) {
            Log.d(TAG, "onAuthenticationResult(): d=" + data);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isActiveLocked() || data == null) {
                return;
            }
            Object result = data.getParcelableExtra(EXTRA_AUTHENTICATION_RESULT);
            Bundle responseData = new Bundle();
            responseData.putParcelable(EXTRA_AUTHENTICATION_RESULT, (Parcelable)result);
            try {
                this.mService.setAuthenticationResult(responseData, this.mSessionId, authenticationId, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error delivering authentication result", e);
            }
        }
    }

    private static AutofillId getAutofillId(View view) {
        return new AutofillId(view.getAutofillViewId());
    }

    private static AutofillId getAutofillId(View parent, int virtualId) {
        return new AutofillId(parent.getAutofillViewId(), virtualId);
    }

    private void startSessionLocked(AutofillId id2, Rect bounds, AutofillValue value, int flags) {
        if (Helper.sVerbose) {
            Log.v(TAG, "startSessionLocked(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", flags=" + flags + ", state=" + this.mState);
        }
        if (this.mState != 1) {
            if (Helper.sDebug) {
                Log.d(TAG, "not starting session for " + id2 + " on state " + this.mState);
            }
            return;
        }
        try {
            AutofillClient client;
            this.mSessionId = this.mService.startSession(this.mContext.getActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId(), this.mCallback != null, flags, this.mContext.getOpPackageName());
            if (this.mSessionId != Integer.MIN_VALUE) {
                this.mState = 2;
            }
            if ((client = this.getClientLocked()) != null) {
                client.autofillCallbackResetableStateAvailable();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void finishSessionLocked() {
        if (Helper.sVerbose) {
            Log.v(TAG, "finishSessionLocked(): " + this.mState);
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.finishSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked();
    }

    private void cancelSessionLocked() {
        if (Helper.sVerbose) {
            Log.v(TAG, "cancelSessionLocked(): " + this.mState);
        }
        if (!this.isActiveLocked()) {
            return;
        }
        try {
            this.mService.cancelSession(this.mSessionId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.resetSessionLocked();
    }

    private void resetSessionLocked() {
        this.mSessionId = Integer.MIN_VALUE;
        this.mState = 1;
        this.mTrackedViews = null;
        this.mFillableIds = null;
    }

    private void updateSessionLocked(AutofillId id2, Rect bounds, AutofillValue value, int action, int flags) {
        if (Helper.sVerbose && action != 3) {
            Log.v(TAG, "updateSessionLocked(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", action=" + action + ", flags=" + flags);
        }
        boolean restartIfNecessary = (flags & 1) != 0;
        try {
            if (restartIfNecessary) {
                int newId = this.mService.updateOrRestartSession(this.mContext.getActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId(), this.mCallback != null, flags, this.mContext.getOpPackageName(), this.mSessionId, action);
                if (newId != this.mSessionId) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "Session restarted: " + this.mSessionId + "=>" + newId);
                    }
                    this.mSessionId = newId;
                    this.mState = this.mSessionId == Integer.MIN_VALUE ? 1 : 2;
                    AutofillClient client = this.getClientLocked();
                    if (client != null) {
                        client.autofillCallbackResetableStateAvailable();
                    }
                }
            } else {
                this.mService.updateSession(this.mSessionId, id2, bounds, value, action, flags, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void ensureServiceClientAddedIfNeededLocked() {
        if (this.getClientLocked() == null) {
            return;
        }
        if (this.mServiceClient == null) {
            this.mServiceClient = new AutofillManagerClient(this);
            try {
                int flags = this.mService.addClient(this.mServiceClient, this.mContext.getUserId());
                this.mEnabled = (flags & 1) != 0;
                Helper.sDebug = (flags & 2) != 0;
                Helper.sVerbose = (flags & 4) != 0;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(AutofillCallback callback) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null) {
                return;
            }
            boolean hadCallback = this.mCallback != null;
            this.mCallback = callback;
            if (!hadCallback) {
                try {
                    this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), true);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(AutofillCallback callback) {
        if (!this.hasAutofillFeature()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback == null || this.mCallback == null || callback != this.mCallback) {
                return;
            }
            this.mCallback = null;
            try {
                this.mService.setHasCallback(this.mSessionId, this.mContext.getUserId(), false);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (this.mSessionId == sessionId && (client = this.getClientLocked()) != null && client.autofillCallbackRequestShowFillUi(anchor, width, height, anchorBounds, presenter) && this.mCallback != null) {
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 1);
            } else {
                callback.onAutofillEvent(anchor, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent) {
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client;
            if (sessionId == this.mSessionId && (client = this.getClientLocked()) != null) {
                client.autofillCallbackAuthenticate(authenticationId, intent, fillInIntent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(boolean enabled, boolean resetSession, boolean resetClient) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEnabled = enabled;
            if (!this.mEnabled || resetSession) {
                this.resetSessionLocked();
            }
            if (resetClient) {
                this.mServiceClient = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAutofilledIfValuesIs(View view, AutofillValue targetValue) {
        AutofillValue currentValue = view.getAutofillValue();
        if (Objects.equals(currentValue, targetValue)) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(1);
                }
                this.mLastAutofilledData.put(AutofillManager.getAutofillId(view), targetValue);
            }
            view.setAutofilled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            if (sessionId != this.mSessionId) {
                return;
            }
            AutofillClient client = this.getClientLocked();
            if (client == null) {
                return;
            }
            int itemCount = ids.size();
            int numApplied = 0;
            ArrayMap<View, SparseArray<AutofillValue>> virtualValues = null;
            View[] views = client.findViewsByAutofillIdTraversal(this.getViewIds(ids));
            for (i = 0; i < itemCount; ++i) {
                AutofillId id2 = ids.get(i);
                AutofillValue value = values.get(i);
                int viewId = id2.getViewId();
                View view = views[i];
                if (view == null) {
                    Log.w(TAG, "autofill(): no View with id " + viewId);
                    continue;
                }
                if (id2.isVirtual()) {
                    SparseArray<AutofillValue> valuesByParent;
                    if (virtualValues == null) {
                        virtualValues = new ArrayMap<View, SparseArray<AutofillValue>>(1);
                    }
                    if ((valuesByParent = (SparseArray<AutofillValue>)virtualValues.get(view)) == null) {
                        valuesByParent = new SparseArray<AutofillValue>(5);
                        virtualValues.put(view, valuesByParent);
                    }
                    valuesByParent.put(id2.getVirtualChildId(), value);
                    continue;
                }
                if (this.mLastAutofilledData == null) {
                    this.mLastAutofilledData = new ParcelableMap(itemCount - i);
                }
                this.mLastAutofilledData.put(id2, value);
                view.autofill(value);
                this.setAutofilledIfValuesIs(view, value);
                ++numApplied;
            }
            if (virtualValues != null) {
                for (i = 0; i < virtualValues.size(); ++i) {
                    View parent = (View)virtualValues.keyAt(i);
                    SparseArray childrenValues = (SparseArray)virtualValues.valueAt(i);
                    parent.autofill(childrenValues);
                    numApplied += childrenValues.size();
                }
            }
            LogMaker log = new LogMaker(913);
            log.addTaggedData(914, itemCount);
            log.addTaggedData(915, numApplied);
            this.mMetricsLogger.write(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTrackedViews(int sessionId, AutofillId[] trackedIds, boolean saveOnAllViewsInvisible, AutofillId[] fillableIds) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled && this.mSessionId == sessionId) {
                this.mTrackedViews = saveOnAllViewsInvisible ? new TrackedViews(trackedIds) : null;
                if (fillableIds != null) {
                    if (this.mFillableIds == null) {
                        this.mFillableIds = new ArraySet(fillableIds.length);
                    }
                    for (AutofillId id2 : fillableIds) {
                        this.mFillableIds.add(id2);
                    }
                    if (Helper.sVerbose) {
                        Log.v(TAG, "setTrackedViews(): fillableIds=" + fillableIds + ", mFillableIds" + this.mFillableIds);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSaveUiState(int sessionId, boolean shown) {
        if (Helper.sDebug) {
            Log.d(TAG, "setSaveUiState(" + sessionId + "): " + shown);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId != Integer.MIN_VALUE) {
                Log.w(TAG, "setSaveUiState(" + sessionId + ", " + shown + ") called on existing session " + this.mSessionId + "; cancelling it");
                this.cancelSessionLocked();
            }
            if (shown) {
                this.mSessionId = sessionId;
                this.mState = 4;
            } else {
                this.mSessionId = Integer.MIN_VALUE;
                this.mState = 1;
            }
        }
    }

    private void requestHideFillUi(AutofillId id2) {
        View anchor = this.findView(id2);
        if (Helper.sVerbose) {
            Log.v(TAG, "requestHideFillUi(" + id2 + "): anchor = " + anchor);
        }
        if (anchor == null) {
            return;
        }
        this.requestHideFillUi(id2, anchor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestHideFillUi(AutofillId id2, View anchor) {
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            AutofillClient client = this.getClientLocked();
            if (client != null && client.autofillCallbackRequestHideFillUi() && this.mCallback != null) {
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 2);
            } else {
                callback.onAutofillEvent(anchor, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNoFillUi(int sessionId, AutofillId id2) {
        View anchor = this.findView(id2);
        if (anchor == null) {
            return;
        }
        AutofillCallback callback = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionId == sessionId && this.getClientLocked() != null) {
                callback = this.mCallback;
            }
        }
        if (callback != null) {
            if (id2.isVirtual()) {
                callback.onAutofillEvent(anchor, id2.getVirtualChildId(), 3);
            } else {
                callback.onAutofillEvent(anchor, 3);
            }
        }
    }

    private int[] getViewIds(AutofillId[] autofillIds) {
        int numIds = autofillIds.length;
        int[] viewIds = new int[numIds];
        for (int i = 0; i < numIds; ++i) {
            viewIds[i] = autofillIds[i].getViewId();
        }
        return viewIds;
    }

    private int[] getViewIds(List<AutofillId> autofillIds) {
        int numIds = autofillIds.size();
        int[] viewIds = new int[numIds];
        for (int i = 0; i < numIds; ++i) {
            viewIds[i] = autofillIds.get(i).getViewId();
        }
        return viewIds;
    }

    private View findView(AutofillId autofillId) {
        AutofillClient client = this.getClientLocked();
        if (client == null) {
            return null;
        }
        return client.findViewByAutofillIdTraversal(autofillId.getViewId());
    }

    public boolean hasAutofillFeature() {
        return this.mService != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPendingSaveUi(int operation, IBinder token) {
        if (Helper.sVerbose) {
            Log.v(TAG, "onPendingSaveUi(" + operation + "): " + token);
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onPendingSaveUi(operation, token);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    public void dump(String outerPrefix, PrintWriter pw) {
        pw.print(outerPrefix);
        pw.println("AutofillManager:");
        String pfx = outerPrefix + "  ";
        pw.print(pfx);
        pw.print("sessionId: ");
        pw.println(this.mSessionId);
        pw.print(pfx);
        pw.print("state: ");
        pw.println(DebugUtils.flagsToString(AutofillManager.class, "STATE_", this.mState));
        pw.print(pfx);
        pw.print("enabled: ");
        pw.println(this.mEnabled);
        pw.print(pfx);
        pw.print("hasService: ");
        pw.println(this.mService != null);
        pw.print(pfx);
        pw.print("hasCallback: ");
        pw.println(this.mCallback != null);
        pw.print(pfx);
        pw.print("last autofilled data: ");
        pw.println(this.mLastAutofilledData);
        pw.print(pfx);
        pw.print("tracked views: ");
        if (this.mTrackedViews == null) {
            pw.println("null");
        } else {
            String pfx2 = pfx + "  ";
            pw.println();
            pw.print(pfx2);
            pw.print("visible:");
            pw.println(this.mTrackedViews.mVisibleTrackedIds);
            pw.print(pfx2);
            pw.print("invisible:");
            pw.println(this.mTrackedViews.mInvisibleTrackedIds);
        }
        pw.print(pfx);
        pw.print("fillable ids: ");
        pw.println(this.mFillableIds);
    }

    private boolean isActiveLocked() {
        return this.mState == 2;
    }

    private void post(Runnable runnable) {
        AutofillClient client = this.getClientLocked();
        if (client == null) {
            if (Helper.sVerbose) {
                Log.v(TAG, "ignoring post() because client is null");
            }
            return;
        }
        client.runOnUiThread(runnable);
    }

    private static class AutofillManagerClient
    extends IAutoFillManagerClient.Stub {
        private final WeakReference<AutofillManager> mAfm;

        AutofillManagerClient(AutofillManager autofillManager) {
            this.mAfm = new WeakReference<AutofillManager>(autofillManager);
        }

        @Override
        public void setState(boolean enabled, boolean resetSession, boolean resetClient) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setState(enabled, resetSession, resetClient));
            }
        }

        @Override
        public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.autofill(sessionId, ids, values));
            }
        }

        @Override
        public void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.authenticate(sessionId, authenticationId, intent, fillInIntent));
            }
        }

        @Override
        public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestShowFillUi(sessionId, id2, width, height, anchorBounds, presenter));
            }
        }

        @Override
        public void requestHideFillUi(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.requestHideFillUi(id2));
            }
        }

        @Override
        public void notifyNoFillUi(int sessionId, AutofillId id2) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.notifyNoFillUi(sessionId, id2));
            }
        }

        @Override
        public void startIntentSender(IntentSender intentSender, Intent intent) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> {
                    try {
                        afm.mContext.startIntentSender(intentSender, intent, 0, 0, 0);
                    }
                    catch (IntentSender.SendIntentException e) {
                        Log.e(AutofillManager.TAG, "startIntentSender() failed for intent:" + intentSender, e);
                    }
                });
            }
        }

        @Override
        public void setTrackedViews(int sessionId, AutofillId[] ids, boolean saveOnAllViewsInvisible, AutofillId[] fillableIds) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setTrackedViews(sessionId, ids, saveOnAllViewsInvisible, fillableIds));
            }
        }

        @Override
        public void setSaveUiState(int sessionId, boolean shown) {
            AutofillManager afm = (AutofillManager)this.mAfm.get();
            if (afm != null) {
                afm.post(() -> afm.setSaveUiState(sessionId, shown));
            }
        }
    }

    public static abstract class AutofillCallback {
        public static final int EVENT_INPUT_SHOWN = 1;
        public static final int EVENT_INPUT_HIDDEN = 2;
        public static final int EVENT_INPUT_UNAVAILABLE = 3;

        public void onAutofillEvent(View view, int event) {
        }

        public void onAutofillEvent(View view, int virtualId, int event) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AutofillEventType {
        }
    }

    private class TrackedViews {
        private ArraySet<AutofillId> mVisibleTrackedIds;
        private ArraySet<AutofillId> mInvisibleTrackedIds;

        private <T> boolean isInSet(ArraySet<T> set, T value) {
            return set != null && set.contains(value);
        }

        private <T> ArraySet<T> addToSet(ArraySet<T> set, T valueToAdd) {
            if (set == null) {
                set = new ArraySet(1);
            }
            set.add(valueToAdd);
            return set;
        }

        private <T> ArraySet<T> removeFromSet(ArraySet<T> set, T valueToRemove) {
            if (set == null) {
                return null;
            }
            set.remove(valueToRemove);
            if (set.isEmpty()) {
                return null;
            }
            return set;
        }

        TrackedViews(AutofillId[] trackedIds) {
            AutofillClient client = AutofillManager.this.getClientLocked();
            if (trackedIds != null && client != null) {
                boolean[] isVisible = client.isVisibleForAutofill() ? client.getViewVisibility(AutofillManager.this.getViewIds(trackedIds)) : new boolean[trackedIds.length];
                int numIds = trackedIds.length;
                for (int i = 0; i < numIds; ++i) {
                    AutofillId id2 = trackedIds[i];
                    if (isVisible[i]) {
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                        continue;
                    }
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (Helper.sVerbose) {
                Log.v(AutofillManager.TAG, "TrackedViews(trackedIds=" + trackedIds + "):  mVisibleTrackedIds=" + this.mVisibleTrackedIds + " mInvisibleTrackedIds=" + this.mInvisibleTrackedIds);
            }
            if (this.mVisibleTrackedIds == null) {
                AutofillManager.this.finishSessionLocked();
            }
        }

        void notifyViewVisibilityChanged(AutofillId id2, boolean isVisible) {
            AutofillClient client = AutofillManager.this.getClientLocked();
            if (Helper.sDebug) {
                Log.d(AutofillManager.TAG, "notifyViewVisibilityChanged(): id=" + id2 + " isVisible=" + isVisible);
            }
            if (client != null && client.isVisibleForAutofill()) {
                if (isVisible) {
                    if (this.isInSet(this.mInvisibleTrackedIds, id2)) {
                        this.mInvisibleTrackedIds = this.removeFromSet(this.mInvisibleTrackedIds, id2);
                        this.mVisibleTrackedIds = this.addToSet(this.mVisibleTrackedIds, id2);
                    }
                } else if (this.isInSet(this.mVisibleTrackedIds, id2)) {
                    this.mVisibleTrackedIds = this.removeFromSet(this.mVisibleTrackedIds, id2);
                    this.mInvisibleTrackedIds = this.addToSet(this.mInvisibleTrackedIds, id2);
                }
            }
            if (this.mVisibleTrackedIds == null) {
                if (Helper.sVerbose) {
                    Log.v(AutofillManager.TAG, "No more visible ids. Invisibile = " + this.mInvisibleTrackedIds);
                }
                AutofillManager.this.finishSessionLocked();
            }
        }

        void onVisibleForAutofillLocked() {
            AutofillClient client = AutofillManager.this.getClientLocked();
            ArraySet<AutofillId> updatedVisibleTrackedIds = null;
            ArraySet<AutofillId> updatedInvisibleTrackedIds = null;
            if (client != null) {
                AutofillId id2;
                int i;
                boolean[] isVisible;
                if (this.mInvisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedInvisibleIds = new ArrayList<AutofillId>(this.mInvisibleTrackedIds);
                    isVisible = client.getViewVisibility(AutofillManager.this.getViewIds(orderedInvisibleIds));
                    int numInvisibleTrackedIds = orderedInvisibleIds.size();
                    for (i = 0; i < numInvisibleTrackedIds; ++i) {
                        id2 = orderedInvisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            if (!Helper.sDebug) continue;
                            Log.d(AutofillManager.TAG, "onVisibleForAutofill() " + id2 + " became visible");
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                    }
                }
                if (this.mVisibleTrackedIds != null) {
                    ArrayList<AutofillId> orderedVisibleIds = new ArrayList<AutofillId>(this.mVisibleTrackedIds);
                    isVisible = client.getViewVisibility(AutofillManager.this.getViewIds(orderedVisibleIds));
                    int numVisibleTrackedIds = orderedVisibleIds.size();
                    for (i = 0; i < numVisibleTrackedIds; ++i) {
                        id2 = orderedVisibleIds.get(i);
                        if (isVisible[i]) {
                            updatedVisibleTrackedIds = this.addToSet(updatedVisibleTrackedIds, id2);
                            continue;
                        }
                        updatedInvisibleTrackedIds = this.addToSet(updatedInvisibleTrackedIds, id2);
                        if (!Helper.sDebug) continue;
                        Log.d(AutofillManager.TAG, "onVisibleForAutofill() " + id2 + " became invisible");
                    }
                }
                this.mInvisibleTrackedIds = updatedInvisibleTrackedIds;
                this.mVisibleTrackedIds = updatedVisibleTrackedIds;
            }
            if (this.mVisibleTrackedIds == null) {
                AutofillManager.this.finishSessionLocked();
            }
        }
    }

    public static interface AutofillClient {
        public void autofillCallbackAuthenticate(int var1, IntentSender var2, Intent var3);

        public void autofillCallbackResetableStateAvailable();

        public boolean autofillCallbackRequestShowFillUi(View var1, int var2, int var3, Rect var4, IAutofillWindowPresenter var5);

        public boolean autofillCallbackRequestHideFillUi();

        public boolean[] getViewVisibility(int[] var1);

        public boolean isVisibleForAutofill();

        public View[] findViewsByAutofillIdTraversal(int[] var1);

        public View findViewByAutofillIdTraversal(int var1);

        public void runOnUiThread(Runnable var1);
    }
}

