/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.DexPathList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import libcore.io.Libcore;

@Deprecated
public class DexFile {
    private Object mCookie;
    private Object mInternalCookie;
    private final String mFileName;
    public static final int NO_DEXOPT_NEEDED = 0;
    public static final int DEX2OAT_FROM_SCRATCH = 1;
    public static final int DEX2OAT_FOR_BOOT_IMAGE = 2;
    public static final int DEX2OAT_FOR_FILTER = 3;
    public static final int DEX2OAT_FOR_RELOCATION = 4;

    @Deprecated
    public DexFile(File file) throws IOException {
        this(file.getPath());
    }

    DexFile(File file, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this(file.getPath(), loader, elements);
    }

    @Deprecated
    public DexFile(String fileName) throws IOException {
        this(fileName, null, null);
    }

    DexFile(String fileName, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this.mInternalCookie = this.mCookie = DexFile.openDexFile(fileName, null, 0, loader, elements);
        this.mFileName = fileName;
    }

    DexFile(ByteBuffer buf) throws IOException {
        this.mInternalCookie = this.mCookie = DexFile.openInMemoryDexFile(buf);
        this.mFileName = null;
    }

    private DexFile(String sourceName, String outputName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        if (outputName != null) {
            try {
                String parent = new File(outputName).getParent();
                if (Libcore.os.getuid() != Libcore.os.stat((String)parent).st_uid) {
                    throw new IllegalArgumentException("Optimized data directory " + parent + " is not owned by the current user. Shared storage cannot protect your application from code injection attacks.");
                }
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
        }
        this.mInternalCookie = this.mCookie = DexFile.openDexFile(sourceName, outputName, flags, loader, elements);
        this.mFileName = sourceName;
    }

    @Deprecated
    public static DexFile loadDex(String sourcePathName, String outputPathName, int flags) throws IOException {
        return DexFile.loadDex(sourcePathName, outputPathName, flags, null, null);
    }

    static DexFile loadDex(String sourcePathName, String outputPathName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        return new DexFile(sourcePathName, outputPathName, flags, loader, elements);
    }

    public String getName() {
        return this.mFileName;
    }

    public String toString() {
        if (this.mFileName != null) {
            return this.getName();
        }
        return "InMemoryDexFile[cookie=" + Arrays.toString((long[])this.mCookie) + "]";
    }

    public void close() throws IOException {
        if (this.mInternalCookie != null) {
            if (DexFile.closeDexFile(this.mInternalCookie)) {
                this.mInternalCookie = null;
            }
            this.mCookie = null;
        }
    }

    public Class loadClass(String name, ClassLoader loader) {
        String slashName = name.replace('.', '/');
        return this.loadClassBinaryName(slashName, loader, null);
    }

    public Class loadClassBinaryName(String name, ClassLoader loader, List<Throwable> suppressed) {
        return DexFile.defineClass(name, loader, this.mCookie, this, suppressed);
    }

    private static Class defineClass(String name, ClassLoader loader, Object cookie, DexFile dexFile, List<Throwable> suppressed) {
        Class result;
        block4: {
            result = null;
            try {
                result = DexFile.defineClassNative(name, loader, cookie, dexFile);
            }
            catch (NoClassDefFoundError e) {
                if (suppressed != null) {
                    suppressed.add(e);
                }
            }
            catch (ClassNotFoundException e) {
                if (suppressed == null) break block4;
                suppressed.add(e);
            }
        }
        return result;
    }

    public Enumeration<String> entries() {
        return new DFEnum(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mInternalCookie != null && !DexFile.closeDexFile(this.mInternalCookie)) {
                throw new AssertionError((Object)"Failed to close dex file in finalizer.");
            }
            this.mInternalCookie = null;
            this.mCookie = null;
        }
        finally {
            super.finalize();
        }
    }

    private static Object openDexFile(String sourceName, String outputName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        return DexFile.openDexFileNative(new File(sourceName).getAbsolutePath(), outputName == null ? null : new File(outputName).getAbsolutePath(), flags, loader, elements);
    }

    private static Object openInMemoryDexFile(ByteBuffer buf) throws IOException {
        if (buf.isDirect()) {
            return DexFile.createCookieWithDirectBuffer(buf, buf.position(), buf.limit());
        }
        return DexFile.createCookieWithArray(buf.array(), buf.position(), buf.limit());
    }

    private static Object createCookieWithDirectBuffer(ByteBuffer byteBuffer, int n, int n2) {
        return OverrideMethod.invokeA("dalvik.system.DexFile#createCookieWithDirectBuffer(Ljava/nio/ByteBuffer;II)Ljava/lang/Object;", true, null);
    }

    private static Object createCookieWithArray(byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeA("dalvik.system.DexFile#createCookieWithArray([BII)Ljava/lang/Object;", true, null);
    }

    boolean isBackedByOatFile() {
        return DexFile.isBackedByOatFile(this.mCookie);
    }

    private static boolean closeDexFile(Object object) {
        return OverrideMethod.invokeI("dalvik.system.DexFile#closeDexFile(Ljava/lang/Object;)Z", true, null) != 0;
    }

    private static Class defineClassNative(String string2, ClassLoader classLoader, Object object, DexFile dexFile) throws ClassNotFoundException, NoClassDefFoundError {
        return (Class)OverrideMethod.invokeA("dalvik.system.DexFile#defineClassNative(Ljava/lang/String;Ljava/lang/ClassLoader;Ljava/lang/Object;Ldalvik/system/DexFile;)Ljava/lang/Class;", true, null);
    }

    private static String[] getClassNameList(Object object) {
        return (String[])OverrideMethod.invokeA("dalvik.system.DexFile#getClassNameList(Ljava/lang/Object;)[Ljava/lang/String;", true, null);
    }

    private static boolean isBackedByOatFile(Object object) {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isBackedByOatFile(Ljava/lang/Object;)Z", true, null) != 0;
    }

    private static Object openDexFileNative(String string2, String string3, int n, ClassLoader classLoader, DexPathList.Element[] elementArray) {
        return OverrideMethod.invokeA("dalvik.system.DexFile#openDexFileNative(Ljava/lang/String;Ljava/lang/String;ILjava/lang/ClassLoader;[Ldalvik/system/DexPathList$Element;)Ljava/lang/Object;", true, null);
    }

    public static boolean isDexOptNeeded(String string2) throws FileNotFoundException, IOException {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isDexOptNeeded(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static int getDexOptNeeded(String string2, String string3, String string4, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        return OverrideMethod.invokeI("dalvik.system.DexFile#getDexOptNeeded(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)I", true, null);
    }

    public static String getDexFileStatus(String string2, String string3) throws FileNotFoundException {
        return (String)OverrideMethod.invokeA("dalvik.system.DexFile#getDexFileStatus(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    public static String[] getDexFileOutputPaths(String string2, String string3) throws FileNotFoundException {
        return (String[])OverrideMethod.invokeA("dalvik.system.DexFile#getDexFileOutputPaths(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", true, null);
    }

    public static boolean isValidCompilerFilter(String string2) {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isValidCompilerFilter(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static boolean isProfileGuidedCompilerFilter(String string2) {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isProfileGuidedCompilerFilter(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static String getNonProfileGuidedCompilerFilter(String string2) {
        return (String)OverrideMethod.invokeA("dalvik.system.DexFile#getNonProfileGuidedCompilerFilter(Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    public static String getSafeModeCompilerFilter(String string2) {
        return (String)OverrideMethod.invokeA("dalvik.system.DexFile#getSafeModeCompilerFilter(Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    private static class DFEnum
    implements Enumeration<String> {
        private int mIndex = 0;
        private String[] mNameList;

        DFEnum(DexFile df) {
            this.mNameList = DexFile.getClassNameList(df.mCookie);
        }

        @Override
        public boolean hasMoreElements() {
            return this.mIndex < this.mNameList.length;
        }

        @Override
        public String nextElement() {
            return this.mNameList[this.mIndex++];
        }
    }
}

