/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.ClassInstrumenter;
import com.intellij.rt.coverage.instrumentation.NewSamplingInstrumenter;
import com.intellij.rt.coverage.instrumentation.SamplingInstrumenter;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class Instrumentator {
    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        new Instrumentator().performPremain(argsString, instrumentation);
    }

    public void performPremain(String argsString, Instrumentation instrumentation) throws Exception {
        List excludePatterns;
        List includePatterns;
        ProjectData data;
        File sourceMapFile;
        File dataFile;
        String[] args;
        if (argsString != null) {
            File argsFile = new File(argsString);
            if (argsFile.isFile()) {
                try {
                    args = this.readArgsFromFile(argsString);
                }
                catch (IOException e) {
                    ErrorReporter.reportError((String)"Arguments were not passed correctly", (Throwable)e);
                    return;
                }
            } else {
                args = Instrumentator.tokenize(argsString);
            }
        } else {
            args = new String[]{};
        }
        boolean traceLines = args.length > 0 && Boolean.valueOf(args[1]) != false;
        boolean sampling = args.length == 0 || Boolean.valueOf(args[4]) != false;
        File file = dataFile = args.length > 0 ? new File(args[0]) : null;
        if (dataFile != null) {
            ErrorReporter.setBasePath((String)dataFile.getParent());
        }
        boolean calcUnloaded = args.length > 0 && Boolean.valueOf(args[2]) != false;
        ProjectData initialData = null;
        if (args.length > 0 && Boolean.valueOf(args[3]).booleanValue() && dataFile.isFile()) {
            initialData = ProjectDataLoader.load(dataFile);
        }
        int i = 5;
        if (args.length > 5 && Boolean.valueOf(args[5]).booleanValue()) {
            sourceMapFile = new File(args[6]);
            i = 7;
        } else {
            sourceMapFile = null;
        }
        ProjectData projectData = data = args.length == 0 ? ProjectData.createProjectData() : ProjectData.createProjectData((File)dataFile, (ProjectData)initialData, (boolean)traceLines, (boolean)sampling);
        if (!data.isTestDiscovery()) {
            includePatterns = new ArrayList();
            System.out.println("---- IntelliJ IDEA coverage runner ---- ");
            System.out.println(sampling ? "sampling ..." : "tracing " + (traceLines ? "and tracking per test coverage ..." : "..."));
            String excludes = "-exclude";
            System.out.println("include patterns:");
            while (i < args.length && !"-exclude".equals(args[i])) {
                try {
                    includePatterns.add(Pattern.compile(args[i]));
                    System.out.println(args[i]);
                }
                catch (PatternSyntaxException ex) {
                    System.err.println("Problem occurred with include pattern " + args[i]);
                    System.err.println(ex.getDescription());
                    System.err.println("This may cause no tests run and no coverage collected");
                    System.exit(1);
                }
                ++i;
            }
            System.out.println("exclude patterns:");
            ++i;
            excludePatterns = new ArrayList();
            while (i < args.length) {
                try {
                    Pattern pattern = Pattern.compile(args[i]);
                    excludePatterns.add(pattern);
                    System.out.println(pattern.pattern());
                }
                catch (PatternSyntaxException ex) {
                    System.err.println("Problem occurred with exclude pattern " + args[i]);
                    System.err.println(ex.getDescription());
                    System.err.println("This may cause no tests run and no coverage collected");
                    System.exit(1);
                }
                ++i;
            }
        } else {
            includePatterns = Collections.emptyList();
            excludePatterns = Collections.emptyList();
        }
        final ClassFinder cf = new ClassFinder(includePatterns, excludePatterns);
        if (dataFile != null) {
            SaveHook hook = new SaveHook(dataFile, calcUnloaded, cf);
            hook.setSourceMapFile(sourceMapFile);
            Runtime.getRuntime().addShutdownHook(new Thread(hook));
        }
        instrumentation.addTransformer(new ClassFileTransformer(){
            private boolean computeFrames = this.computeFrames();

            public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                if (data.isStopped()) {
                    return null;
                }
                try {
                    if (className == null) {
                        return null;
                    }
                    if (className.endsWith(".class")) {
                        className = className.substring(0, className.length() - 6);
                    }
                    if ((className = className.replace('\\', '.').replace('/', '.')).startsWith("com.intellij.rt.") || className.startsWith("java.") || className.startsWith("sun.") || className.startsWith("gnu.trove.") || className.startsWith("org.jetbrains.org.objectweb.asm.") || className.startsWith("org.apache.oro.text.regex.")) {
                        return null;
                    }
                    if (ClassNameUtil.shouldExclude(className, excludePatterns)) {
                        return null;
                    }
                    cf.addClassLoader(loader);
                    if (includePatterns.isEmpty() && loader != null) {
                        return Instrumentator.this.instrument(classfileBuffer, data, className, loader, this.computeFrames, sourceMapFile != null);
                    }
                    for (Object includePattern : includePatterns) {
                        if (!((Pattern)includePattern).matcher(className).matches()) continue;
                        return Instrumentator.this.instrument(classfileBuffer, data, className, loader, this.computeFrames, sourceMapFile != null);
                    }
                }
                catch (Throwable e) {
                    ErrorReporter.reportError((String)("Error during class instrumentation: " + className), (Throwable)e);
                }
                return null;
            }

            private boolean computeFrames() {
                return System.getProperty("idea.coverage.no.frames") == null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readArgsFromFile(String arg) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(arg);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            while (reader.ready()) {
                result.add(reader.readLine());
            }
        }
        finally {
            reader.close();
        }
        return result.toArray(new String[result.size()]);
    }

    private byte[] instrument(byte[] classfileBuffer, ProjectData data, String className, ClassLoader loader, boolean computeFrames, boolean shouldCalculateSource) {
        int version;
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = computeFrames ? Instrumentator.getClassWriter((version = Instrumentator.getClassFileVersion(cr)) >= 50 && version != 196653 ? 2 : 1, loader) : Instrumentator.getClassWriter(1, loader);
        ClassVisitor cv = this.createClassVisitor(data, className, loader, shouldCalculateSource, cr, cw);
        cr.accept(cv, 0);
        return cw.toByteArray();
    }

    protected ClassVisitor createClassVisitor(ProjectData data, String className, ClassLoader loader, boolean shouldCalculateSource, ClassReader cr, ClassWriter cw) {
        if (data.isSampling()) {
            if (System.getProperty("idea.new.sampling.coverage") != null) {
                return new NewSamplingInstrumenter(data, (ClassVisitor)cw, cr, className, shouldCalculateSource);
            }
            return new SamplingInstrumenter(data, (ClassVisitor)cw, className, shouldCalculateSource);
        }
        return new ClassInstrumenter(data, (ClassVisitor)cw, className, shouldCalculateSource);
    }

    private static ClassWriter getClassWriter(int flags, ClassLoader classLoader) {
        return new MyClassWriter(flags, classLoader);
    }

    public static int getClassFileVersion(ClassReader reader) {
        final int[] classFileVersion = new int[1];
        reader.accept(new ClassVisitor(393216){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                classFileVersion[0] = version;
            }
        }, 0);
        return classFileVersion[0];
    }

    private static String[] tokenize(String argumentString) {
        ArrayList<String> tokenizedArgs = new ArrayList<String>();
        StringBuffer currentArg = new StringBuffer();
        block4: for (int i = 0; i < argumentString.length(); ++i) {
            char c = argumentString.charAt(i);
            switch (c) {
                default: {
                    currentArg.append(c);
                    continue block4;
                }
                case ' ': {
                    String arg = currentArg.toString();
                    if (arg.length() > 0) {
                        tokenizedArgs.add(arg);
                    }
                    currentArg = new StringBuffer();
                    continue block4;
                }
                case '\"': {
                    char d;
                    ++i;
                    while (i < argumentString.length() && (d = argumentString.charAt(i)) != '\"') {
                        currentArg.append(d);
                        ++i;
                    }
                    break block0;
                }
            }
        }
        String arg = currentArg.toString();
        if (arg.length() > 0) {
            tokenizedArgs.add(arg);
        }
        return tokenizedArgs.toArray(new String[tokenizedArgs.size()]);
    }

    private static class MyClassWriter
    extends ClassWriter {
        public static final String JAVA_LANG_OBJECT = "java/lang/Object";
        private final ClassLoader classLoader;

        public MyClassWriter(int flags, ClassLoader classLoader) {
            super(flags);
            this.classLoader = classLoader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            try {
                String result;
                block5: {
                    ClassReader info1 = this.typeInfo(type1);
                    ClassReader info2 = this.typeInfo(type2);
                    String superType = this.checkImplementInterface(type1, type2, info1, info2);
                    if (superType != null) {
                        return superType;
                    }
                    superType = this.checkImplementInterface(type2, type1, info2, info1);
                    if (superType != null) {
                        return superType;
                    }
                    StringBuilder b1 = this.typeAncestors(type1, info1);
                    StringBuilder b2 = this.typeAncestors(type2, info2);
                    result = JAVA_LANG_OBJECT;
                    int end1 = b1.length();
                    int end2 = b2.length();
                    while (true) {
                        String p2;
                        int start1 = b1.lastIndexOf(";", end1 - 1);
                        int start2 = b2.lastIndexOf(";", end2 - 1);
                        if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block5;
                        String p1 = b1.substring(start1 + 1, end1);
                        if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                        result = p1;
                        end1 = start1;
                        end2 = start2;
                    }
                    return result;
                }
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
        }

        private String checkImplementInterface(String type1, String type2, ClassReader info1, ClassReader info2) throws IOException {
            if ((info1.getAccess() & 0x200) != 0) {
                if (this.typeImplements(type2, info2, type1)) {
                    return type1;
                }
                return JAVA_LANG_OBJECT;
            }
            return null;
        }

        private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
            StringBuilder b = new StringBuilder();
            while (!JAVA_LANG_OBJECT.equals(type)) {
                b.append(';').append(type);
                type = info.getSuperName();
                info = this.typeInfo(type);
            }
            return b;
        }

        private boolean typeImplements(String type, ClassReader classReader, String interfaceName) throws IOException {
            while (!JAVA_LANG_OBJECT.equals(type)) {
                String[] itfs;
                for (String itf1 : itfs = classReader.getInterfaces()) {
                    if (!itf1.equals(interfaceName)) continue;
                    return true;
                }
                for (String itf : itfs) {
                    if (!this.typeImplements(itf, this.typeInfo(itf), interfaceName)) continue;
                    return true;
                }
                type = classReader.getSuperName();
                classReader = this.typeInfo(type);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClassReader typeInfo(String type) throws IOException {
            InputStream is = null;
            try {
                is = this.classLoader.getResourceAsStream(type + ".class");
                ClassReader classReader = new ClassReader(is);
                return classReader;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}

