/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiPackage;
import com.android.tools.lint.checks.ApiParser;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Api {
    private final Map<String, ApiClass> mClasses;
    private final Map<String, ApiPackage> mPackages;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Api parseApi(File apiFile) {
        try (FileInputStream inputStream = new FileInputStream(apiFile);){
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            XmlUtils.configureSaxFactory((SAXParserFactory)parserFactory, (boolean)false, (boolean)false);
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)parserFactory);
            ApiParser apiParser = new ApiParser();
            parser.parse((InputStream)inputStream, (DefaultHandler)apiParser);
            ((InputStream)inputStream).close();
            Api api = new Api(apiParser.getClasses(), apiParser.getPackages());
            return api;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Api(Map<String, ApiClass> classes, Map<String, ApiPackage> packages) {
        this.mClasses = new HashMap<String, ApiClass>(classes);
        this.mPackages = new HashMap<String, ApiPackage>(packages);
    }

    ApiClass getClass(String fqcn) {
        return this.mClasses.get(fqcn);
    }

    Map<String, ApiClass> getClasses() {
        return Collections.unmodifiableMap(this.mClasses);
    }

    Map<String, ApiPackage> getPackages() {
        return Collections.unmodifiableMap(this.mPackages);
    }
}

