/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.JvmElementActionsFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldActionKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/GroovyElementActionsFactory;", "Lcom/intellij/lang/jvm/actions/JvmElementActionsFactory;", "()V", "createAddFieldActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "targetClass", "Lcom/intellij/lang/jvm/JvmClass;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "intellij.groovy"})
public final class GroovyElementActionsFactory
extends JvmElementActionsFactory {
    @NotNull
    public List<IntentionAction> createAddFieldActions(@NotNull JvmClass targetClass, @NotNull CreateFieldRequest request) {
        CreateFieldAction createFieldAction;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        PsiClass psiClass = JvmPsiUtilKt.toGroovyClassOrNull(targetClass);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass javaClass = psiClass;
        boolean constantRequested = request.getConstant() || javaClass.isInterface() || request.getModifiers().containsAll((Collection)CreateFieldActionKt.getConstantModifiers());
        ArrayList result = new ArrayList();
        if (constantRequested || StringUtil.isCapitalized((String)request.getFieldName())) {
            collection = result;
            createFieldAction = new CreateFieldAction(javaClass, request, true);
            collection.add(createFieldAction);
        }
        if (!constantRequested) {
            collection = result;
            createFieldAction = new CreateFieldAction(javaClass, request, false);
            collection.add(createFieldAction);
        }
        return result;
    }
}

