/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a\u000e\u0010\t\u001a\u00020\u0004*\u0004\u0018\u00010\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\u0004*\u00020\nH\u0000\u00a8\u0006\f"}, d2={"getGroovyFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "Lcom/intellij/psi/PsiFile;", "isAnonymousClassReference", "", "Lorg/jetbrains/plugins/groovy/lang/psi/GrReferenceElement;", "isMethodWithLiteralName", "Lcom/intellij/psi/PsiMethod;", "isReferenceWithLiteralName", "isStringNameElement", "Lcom/intellij/psi/PsiElement;", "isThisOrSuper", "intellij.groovy.psi"})
public final class UtilKt {
    @Nullable
    public static final GroovyFileBase getGroovyFile(@NotNull PsiFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile psiFile = $receiver.getViewProvider().getPsi((Language)GroovyLanguage.INSTANCE);
        if (!(psiFile instanceof GroovyFileBase)) {
            psiFile = null;
        }
        return (GroovyFileBase)psiFile;
    }

    public static final boolean isMethodWithLiteralName(@NotNull PsiMethod $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof GrMethod && UtilKt.isStringNameElement(((GrMethod)$receiver).getNameIdentifierGroovy());
    }

    public static final boolean isReferenceWithLiteralName(@NotNull GrReferenceElement<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return UtilKt.isStringNameElement($receiver.getReferenceNameElement());
    }

    private static final boolean isStringNameElement(@Nullable PsiElement $receiver) {
        PsiElement psiElement = $receiver;
        return TokenSets.STRING_LITERAL_SET.contains(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null);
    }

    public static final boolean isAnonymousClassReference(@NotNull GrReferenceElement<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        PsiElement psiElement = $receiver.getParent();
        if (!(psiElement instanceof GrAnonymousClassDefinition)) {
            psiElement = null;
        }
        GrAnonymousClassDefinition grAnonymousClassDefinition = (GrAnonymousClassDefinition)psiElement;
        return Intrinsics.areEqual((Object)(grAnonymousClassDefinition != null ? grAnonymousClassDefinition.getBaseClassReferenceGroovy() : null), $receiver);
    }

    public static final boolean isThisOrSuper(@NotNull PsiElement $receiver) {
        ASTNode aSTNode;
        ASTNode it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ASTNode aSTNode2 = $receiver.getNode();
        return aSTNode2 != null && (aSTNode2 = aSTNode2.getElementType()) != null ? Intrinsics.areEqual((Object)(it = (aSTNode = aSTNode2)), (Object)GroovyTokenTypes.kTHIS) || Intrinsics.areEqual((Object)it, (Object)GroovyTokenTypes.kSUPER) : false;
    }
}

