/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;

public abstract class GrReferenceElementImpl<Q extends PsiElement>
extends GroovyPsiElementImpl
implements GrReferenceElement<Q> {
    private static final String DUMMY_FQN = "05ab655a-0e15-4f35-909d-9dff5e757f63";
    private volatile String myQualifiedReferenceName;
    private volatile String myCachedQName;
    private volatile String myCachedTextSkipWhiteSpaceAndComments;

    public GrReferenceElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrReferenceElementImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myQualifiedReferenceName = DUMMY_FQN;
    }

    public void subtreeChanged() {
        this.myQualifiedReferenceName = DUMMY_FQN;
        this.myCachedQName = null;
        this.myCachedTextSkipWhiteSpaceAndComments = null;
        super.subtreeChanged();
    }

    @Override
    public String getReferenceName() {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            return nameElement.getText();
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedReferenceName() {
        String qualifiedReferenceName = this.myQualifiedReferenceName;
        if (qualifiedReferenceName == DUMMY_FQN) {
            this.myQualifiedReferenceName = qualifiedReferenceName = PsiImplUtilKt.getQualifiedReferenceName(this);
        }
        return qualifiedReferenceName;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement refNameElement = this.getReferenceNameElement();
        if (refNameElement != null) {
            int offsetInParent = refNameElement.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + refNameElement.getTextLength());
        }
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement != null) {
            ASTNode newNameNode;
            ASTNode node = nameElement.getNode();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            try {
                newNameNode = factory.createReferenceNameFromText(newElementName).getNode();
            }
            catch (IncorrectOperationException e) {
                newNameNode = factory.createLiteralFromValue(newElementName).getFirstChild().getNode();
            }
            assert (newNameNode != null && node != null);
            this.getNode().replaceChild(node, newNameNode);
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean preserveQualification;
        if (element == null) {
            GrReferenceElementImpl.$$$reportNull$$$0(1);
        }
        if (this.isReferenceTo(element)) {
            return this;
        }
        boolean fullyQualified = this.isFullyQualified();
        boolean bl = preserveQualification = GroovyCodeStyleSettingsFacade.getInstance(this.getProject()).useFqClassNames() && fullyQualified;
        if (element instanceof PsiClass) {
            String qualifiedName = ((PsiClass)element).getQualifiedName();
            if (!preserveQualification || qualifiedName == null) {
                String newName = ((PsiClass)element).getName();
                this.setQualifier((Q)null);
                GrReferenceElementImpl newElement = (GrReferenceElementImpl)this.handleElementRename(newName);
                if (newElement.isReferenceTo(element) || qualifiedName == null || JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qualifiedName, this.getResolveScope()) == null) {
                    return newElement;
                }
            }
            GrReferenceElement<Q> qualifiedRef = this.bindWithQualifiedRef(qualifiedName);
            if (!preserveQualification) {
                JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences(qualifiedRef);
            }
            return qualifiedRef;
        }
        if (element instanceof PsiMember) {
            PsiMember member = (PsiMember)element;
            if (!this.isPhysical()) {
                return this;
            }
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            GrReferenceElement<Q> qualifiedRef = this.bindWithQualifiedRef(qName);
            if (!preserveQualification) {
                JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences(qualifiedRef);
            }
            return qualifiedRef;
        }
        if (element instanceof PsiPackage) {
            return this.bindWithQualifiedRef(((PsiPackage)element).getQualifiedName());
        }
        throw new IncorrectOperationException("Cannot bind to:" + element + " of class " + element.getClass());
    }

    protected abstract GrReferenceElement<Q> bindWithQualifiedRef(@NotNull String var1);

    protected boolean bindsCorrectly(PsiElement element) {
        return this.isReferenceTo(element);
    }

    public abstract boolean isFullyQualified();

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        GrTypeArgumentList typeArgsList = this.getTypeArgumentList();
        if (typeArgsList == null) {
            if (PsiType.EMPTY_ARRAY == null) {
                GrReferenceElementImpl.$$$reportNull$$$0(2);
            }
            return PsiType.EMPTY_ARRAY;
        }
        GrTypeElement[] args = typeArgsList.getTypeArgumentElements();
        if (args.length == 0) {
            if (PsiType.EMPTY_ARRAY == null) {
                GrReferenceElementImpl.$$$reportNull$$$0(3);
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] result = PsiType.createArray((int)args.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = args[i].getType();
        }
        if (result == null) {
            GrReferenceElementImpl.$$$reportNull$$$0(4);
        }
        return result;
    }

    @Override
    @Nullable
    public GrTypeArgumentList getTypeArgumentList() {
        return (GrTypeArgumentList)this.findChildByType(GroovyElementTypes.TYPE_ARGUMENTS);
    }

    @Override
    public void setQualifier(@Nullable Q newQualifier) {
        PsiImplUtil.setQualifier(this, newQualifier);
    }

    @Override
    @NotNull
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName((String)this.getTextSkipWhiteSpaceAndComments(), (boolean)false);
        }
        String string = cachedQName;
        if (string == null) {
            GrReferenceElementImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String getTextSkipWhiteSpaceAndComments() {
        String whiteSpaceAndComments = this.myCachedTextSkipWhiteSpaceAndComments;
        if (whiteSpaceAndComments == null) {
            this.myCachedTextSkipWhiteSpaceAndComments = whiteSpaceAndComments = PsiImplUtil.getTextSkipWhiteSpaceAndComments(this.getNode());
        }
        return whiteSpaceAndComments;
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrReferenceElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrReferenceElementImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

