/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrTypeArgumentListImpl
extends GroovyPsiElementImpl
implements GrTypeArgumentList {
    public GrTypeArgumentListImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrTypeArgumentListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitTypeArgumentList(this);
    }

    public String toString() {
        return "Type arguments";
    }

    @Override
    public GrTypeElement[] getTypeArgumentElements() {
        return (GrTypeElement[])this.findChildrenByClass(GrTypeElement.class);
    }

    @Override
    public PsiType[] getTypeArguments() {
        GrTypeElement[] elements = this.getTypeArgumentElements();
        if (elements.length == 0) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] result = PsiType.createArray((int)elements.length);
        for (int i = 0; i < elements.length; ++i) {
            result[i] = elements[i].getType();
        }
        return result;
    }

    @Override
    public boolean isDiamond() {
        return this.getTypeArgumentElements().length == 0;
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first == last && first.getPsi() instanceof GrTypeElement) {
            if (anchor == null) {
                anchor = this.getLastChild().getNode();
                before = true;
            }
            if (this.getTypeArgumentElements().length > 0) {
                if (before == null || before.booleanValue()) {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                } else {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor.getTreeNext());
                }
            }
            return super.addInternal(first, last, anchor, before);
        }
        return super.addInternal(first, last, anchor, before);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrTypeArgumentListImpl", "<init>"));
    }
}

