/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.imports.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImport;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/impl/NonFqnImport;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyImport;", "()V", "classFqn", "", "getClassFqn", "()Ljava/lang/String;", "resolveImport", "Lcom/intellij/psi/PsiClass;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "intellij.groovy.psi"})
public abstract class NonFqnImport
implements GroovyImport {
    @NotNull
    public abstract String getClassFqn();

    @Nullable
    public PsiClass resolveImport(@NotNull GroovyFileBase file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
        GlobalSearchScope scope = file.getResolveScope();
        PsiClass clazz = facade.findClass(this.getClassFqn(), scope);
        if (clazz != null) {
            return clazz;
        }
        if (Intrinsics.areEqual((Object)StringUtil.getShortName((String)this.getClassFqn()), (Object)this.getClassFqn()) ^ true) {
            return null;
        }
        String fqn = StringUtil.getQualifiedName((String)file.getPackageName(), (String)this.getClassFqn());
        return facade.findClass(fqn, scope);
    }
}

